/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorfieldrounder;

import java.text.DecimalFormat;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollections;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;

@Description(value="Module that rounds a defined field attribute.")
@Documentation(value="VectorFieldRounder.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Join, VectorTableJoiner")
@Label(value="Vector Processing")
@Status(value=40)
@Name(value="vround")
@License(value="General Public License Version 3 (GPLv3)")
public class VectorFieldRounder
extends JGTModel {
    @Description(value="The vector of which to round a numeric value.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The double field of the number to round.")
    @In
    public String fRound = null;
    @Description(value="The rounding pattern.")
    @In
    public String pPattern = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The modified vector.")
    @Out
    public SimpleFeatureCollection outVector;
    private DecimalFormat formatter = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.pPattern, this.fRound);
        this.formatter = new DecimalFormat(this.pPattern);
        this.outVector = FeatureCollections.newCollection();
        int size = this.inVector.size();
        this.pm.beginTask("Rounding data...", size);
        SimpleFeatureIterator inFeatureIterator = this.inVector.features();
        while (inFeatureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)inFeatureIterator.next();
            Object attribute = feature.getAttribute(this.fRound);
            if (attribute instanceof Number) {
                double num = ((Number)attribute).doubleValue();
                String numStr = this.formatter.format(num);
                numStr = numStr.replaceFirst(",", ".");
                num = Double.parseDouble(numStr);
                feature.setAttribute(this.fRound, (Object)num);
            }
            this.outVector.add((Feature)feature);
            this.pm.worked(1);
        }
        this.pm.done();
        inFeatureIterator.close();
    }
}

