/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.sourcesdirection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollections;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.features.FeatureExtender;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.jgrasstools.gears.utils.sorting.QuickSortAlgorithmObjects;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;

@Description(value="Calculates the direction of maximum slope for a source point on a dem.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Status(value=10)
@Label(value="Vector Processing")
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class SourcesDirectionCalculator
extends JGTModel {
    @Description(value="The source point features.")
    @In
    public SimpleFeatureCollection inSources;
    @Description(value="Resolution to use.")
    @In
    public double pRes = Double.NaN;
    @Description(value="The input coverage.")
    @In
    public GridCoverage2D inCoverage = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The source point features with the added azimuth angle.")
    @Out
    public SimpleFeatureCollection outSources;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outSources == null, this.doReset)) {
            return;
        }
        SimpleFeatureIterator inFeatureIterator = this.inSources.features();
        this.outSources = FeatureCollections.newCollection();
        FeatureExtender fExt = new FeatureExtender((SimpleFeatureType)this.inSources.getSchema(), new String[]{"azimuth", "availpixels", "c11", "c12", "c13", "c21", "c22", "c23", "c31", "c32", "c33"}, new Class[]{Double.class, Integer.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class});
        double[] res = this.resFromCoverage(this.inCoverage);
        if (res[0] != this.pRes) {
            double scaleX = res[0] / this.pRes;
            double scaleY = res[1] / this.pRes;
            System.out.println(res[0] + "/" + res[1] + "/" + scaleX + "/" + scaleY);
            this.inCoverage = (GridCoverage2D)Operations.DEFAULT.subsampleAverage((GridCoverage)this.inCoverage, scaleX, scaleY);
        }
        Envelope2D env = this.inCoverage.getEnvelope2D();
        GridGeometry2D gridGeometry = this.inCoverage.getGridGeometry();
        int size = this.inSources.size();
        this.pm.beginTask("Extracting azimuth...", size);
        while (inFeatureIterator.hasNext()) {
            this.pm.worked(1);
            SimpleFeature feature = (SimpleFeature)inFeatureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            Coordinate coordinate = geometry.getCoordinate();
            if (!env.contains(coordinate.x, coordinate.y)) continue;
            GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
            int cols = gridRange.width;
            int rows = gridRange.height;
            GridCoordinates2D centerGC = gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(coordinate.x, coordinate.y));
            GridCoordinates2D c11 = new GridCoordinates2D(centerGC.x - 1, centerGC.y - 1);
            GridCoordinates2D c12 = new GridCoordinates2D(centerGC.x, centerGC.y - 1);
            GridCoordinates2D c13 = new GridCoordinates2D(centerGC.x + 1, centerGC.y - 1);
            GridCoordinates2D c21 = new GridCoordinates2D(centerGC.x - 1, centerGC.y);
            GridCoordinates2D c23 = new GridCoordinates2D(centerGC.x + 1, centerGC.y);
            GridCoordinates2D c31 = new GridCoordinates2D(centerGC.x - 1, centerGC.y + 1);
            GridCoordinates2D c32 = new GridCoordinates2D(centerGC.x, centerGC.y + 1);
            GridCoordinates2D c33 = new GridCoordinates2D(centerGC.x + 1, centerGC.y + 1);
            double[] center = this.inCoverage.evaluate(centerGC, (double[])null);
            double dz11 = -10000.0;
            double dz12 = -10000.0;
            double dz13 = -10000.0;
            double dz21 = -10000.0;
            double dz23 = -10000.0;
            double dz31 = -10000.0;
            double dz32 = -10000.0;
            double dz33 = -10000.0;
            int pixelNum = 0;
            boolean oneIsNull = false;
            double[] v11 = this.getPixelValue(this.inCoverage, cols, rows, c11);
            if (v11 != null) {
                ++pixelNum;
                dz11 = (center[0] - v11[0]) / Math.sqrt(2.0);
            } else {
                oneIsNull = true;
            }
            double[] v12 = this.getPixelValue(this.inCoverage, cols, rows, c12);
            if (v12 != null) {
                ++pixelNum;
                dz12 = center[0] - v12[0];
            } else {
                oneIsNull = true;
            }
            double[] v13 = this.getPixelValue(this.inCoverage, cols, rows, c13);
            if (v13 != null) {
                ++pixelNum;
                dz13 = (center[0] - v13[0]) / Math.sqrt(2.0);
            } else {
                oneIsNull = true;
            }
            double[] v21 = this.getPixelValue(this.inCoverage, cols, rows, c21);
            if (v21 != null) {
                ++pixelNum;
                dz21 = center[0] - v21[0];
            } else {
                oneIsNull = true;
            }
            double[] v23 = this.getPixelValue(this.inCoverage, cols, rows, c23);
            if (v23 != null) {
                ++pixelNum;
                dz23 = center[0] - v23[0];
            } else {
                oneIsNull = true;
            }
            double[] v31 = this.getPixelValue(this.inCoverage, cols, rows, c31);
            if (v31 != null) {
                ++pixelNum;
                dz31 = (center[0] - v31[0]) / Math.sqrt(2.0);
            } else {
                oneIsNull = true;
            }
            double[] v32 = this.getPixelValue(this.inCoverage, cols, rows, c32);
            if (v32 != null) {
                ++pixelNum;
                dz32 = center[0] - v32[0];
            } else {
                oneIsNull = true;
            }
            double[] v33 = this.getPixelValue(this.inCoverage, cols, rows, c33);
            if (v33 != null) {
                ++pixelNum;
                dz33 = (center[0] - v33[0]) / Math.sqrt(2.0);
            } else {
                oneIsNull = true;
            }
            Object[] cArray = new GridCoordinates2D[]{c31, c32, c33, c21, c23, c11, c12, c13};
            double[] tArray = new double[]{dz31, dz32, dz33, dz21, dz23, dz11, dz12, dz13};
            QuickSortAlgorithmObjects qSobj = new QuickSortAlgorithmObjects(null);
            qSobj.sort(tArray, cArray);
            Object steepestCoord = cArray[cArray.length - 1];
            Point2D steepestWorldCoord = CoverageUtilities.gridToWorld(gridGeometry, ((GridCoordinates2D)steepestCoord).x, ((GridCoordinates2D)steepestCoord).y);
            double[] c = new double[]{steepestWorldCoord.getX(), steepestWorldCoord.getY()};
            Point2D centerCoordOnGrid = CoverageUtilities.gridToWorld(gridGeometry, centerGC.x, centerGC.y);
            double[] cent = new double[]{centerCoordOnGrid.getX(), centerCoordOnGrid.getY()};
            double azimuth = -9999.0;
            if (!oneIsNull) {
                azimuth = GeometryUtilities.azimuth(new Coordinate(cent[0], cent[1]), new Coordinate(c[0], c[1]));
            }
            SimpleFeature azimuthFeature = fExt.extendFeature(feature, new Object[]{azimuth, pixelNum, this.getValue(v11), this.getValue(v12), this.getValue(v13), this.getValue(v21), this.getValue(center), this.getValue(v23), this.getValue(v31), this.getValue(v32), this.getValue(v33)});
            this.outSources.add((Feature)azimuthFeature);
        }
        this.pm.done();
    }

    private double getValue(double[] array) {
        return array != null ? array[0] : -9999.0;
    }

    private double[] getPixelValue(GridCoverage2D dem, int cols, int rows, GridCoordinates2D gridCoordinate) {
        if (gridCoordinate.x >= 0 && gridCoordinate.x < cols && gridCoordinate.y >= 0 && gridCoordinate.y < rows) {
            double[] value = dem.evaluate(gridCoordinate, (double[])null);
            return value;
        }
        return null;
    }

    private double[] resFromCoverage(GridCoverage2D dem) {
        GridGeometry2D gridGeometry = dem.getGridGeometry();
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double[] res = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToCRS), XAffineTransform.getScaleY0((AffineTransform)gridToCRS)};
        return res;
    }
}

