/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.rastercattofeatureattribute;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.image.RenderedImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollections;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.features.FeatureExtender;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;

@Description(value="Module that extracts raster categories and adds them to a feature collection.")
@Documentation(value="RasterCatToFeatureAttribute.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Status(value=40)
@Label(value="Vector Processing")
@Name(value="rat2featureattr")
@License(value="General Public License Version 3 (GPLv3)")
public class RasterCatToFeatureAttribute
extends JGTModel {
    @Description(value="The raster on which to map the vector features.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The vector to use for the geometric mapping.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The name for the new field to create.")
    @In
    public String fNew = "new";
    @Description(value="The position of the coordinate to take in the case of multi geometries.")
    @In
    public String pPos = "middle";
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The extended vector.")
    @Out
    public SimpleFeatureCollection outVector = null;
    private static final String MIDDLE = "middle";
    private static final String START = "start";
    private static final String END = "end";
    private RandomIter inIter = null;
    private GridGeometry2D gridGeometry;

    @Execute
    public void process() throws Exception {
        if (this.inIter == null) {
            RenderedImage inputRI = this.inRaster.getRenderedImage();
            this.inIter = RandomIterFactory.create((RenderedImage)inputRI, null);
            this.gridGeometry = this.inRaster.getGridGeometry();
        }
        SimpleFeatureType featureType = (SimpleFeatureType)this.inVector.getSchema();
        FeatureExtender fExt = new FeatureExtender(featureType, new String[]{this.fNew}, new Class[]{Double.class});
        Envelope2D inCoverageEnvelope = this.inRaster.getEnvelope2D();
        this.outVector = FeatureCollections.newCollection();
        SimpleFeatureIterator featureIterator = this.inVector.features();
        int all = this.inVector.size();
        this.pm.beginTask("Extracting raster information...", all);
        while (featureIterator.hasNext()) {
            Coordinate c;
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            double value = -1.0;
            Coordinate[] coordinates = geometry.getCoordinates();
            if (GeometryUtilities.getGeometryType(geometry) == GeometryUtilities.GEOMETRYTYPE.POINT || GeometryUtilities.getGeometryType(geometry) == GeometryUtilities.GEOMETRYTYPE.MULTIPOINT) {
                c = coordinates[0];
            } else if (GeometryUtilities.getGeometryType(geometry) == GeometryUtilities.GEOMETRYTYPE.LINE || GeometryUtilities.getGeometryType(geometry) == GeometryUtilities.GEOMETRYTYPE.MULTILINE) {
                c = this.pPos.trim().equalsIgnoreCase(START) ? coordinates[0] : (this.pPos.trim().equalsIgnoreCase(END) ? coordinates[coordinates.length - 1] : coordinates[coordinates.length / 2]);
            } else if (GeometryUtilities.getGeometryType(geometry) == GeometryUtilities.GEOMETRYTYPE.POLYGON || GeometryUtilities.getGeometryType(geometry) == GeometryUtilities.GEOMETRYTYPE.MULTIPOLYGON) {
                Point centroid = geometry.getCentroid();
                c = geometry.contains((Geometry)centroid) ? centroid.getCoordinate() : coordinates[0];
            } else {
                throw new ModelsIllegalargumentException("The Geometry type is not supported.", this);
            }
            if (!inCoverageEnvelope.contains(c.x, c.y)) continue;
            GridCoordinates2D gridCoord = this.gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(c.x, c.y));
            value = this.inIter.getSampleDouble(gridCoord.x, gridCoord.y, 0);
            if (JGTConstants.isNovalue(value) || value >= 3.4028234663852886E38 || value <= -3.4028234663852886E38) {
                value = -9999.0;
            }
            SimpleFeature extendedFeature = fExt.extendFeature(feature, new Object[]{value});
            this.outVector.add((Feature)extendedFeature);
            this.pm.worked(1);
        }
        featureIterator.close();
        this.pm.done();
    }
}

