/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.intersections;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Finds intersection geometries in feature collections")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Vector")
@Label(value="Vector Processing")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class IntersectionFinder
extends JGTModel {
    @Description(value="The map to test for intersections.")
    @In
    public SimpleFeatureCollection inMap = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The intersections points map.")
    @Out
    public SimpleFeatureCollection outPointsMap = null;
    @Description(value="The intersections lines map.")
    @Out
    public SimpleFeatureCollection outLinesMap = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outPointsMap == null && this.outLinesMap == null, this.doReset)) {
            return;
        }
        this.outPointsMap = FeatureCollections.newCollection();
        this.outLinesMap = FeatureCollections.newCollection();
        GeometryUtilities.GEOMETRYTYPE geometryType = GeometryUtilities.getGeometryType(((SimpleFeatureType)this.inMap.getSchema()).getGeometryDescriptor().getType());
        switch (geometryType) {
            case LINE: 
            case MULTILINE: {
                this.intersectLines();
                break;
            }
            case POLYGON: 
            case MULTIPOLYGON: {
                throw new ModelsIllegalargumentException("The module doesn't work for polygons yet.", this);
            }
            default: {
                throw new ModelsIllegalargumentException("The module doesn't work for points.", this.getClass().getSimpleName());
            }
        }
    }

    private void intersectLines() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("pointintersections");
        b.setCRS(((SimpleFeatureType)this.inMap.getSchema()).getCoordinateReferenceSystem());
        b.add("the_geom", Point.class);
        SimpleFeatureType pointType = b.buildFeatureType();
        b = new SimpleFeatureTypeBuilder();
        b.setName("lineintersections");
        b.setCRS(((SimpleFeatureType)this.inMap.getSchema()).getCoordinateReferenceSystem());
        b.add("the_geom", LineString.class);
        SimpleFeatureType linesType = b.buildFeatureType();
        int size = this.inMap.size();
        ArrayList<Geometry> geometriesList = new ArrayList<Geometry>();
        SimpleFeatureIterator linesIterator = this.inMap.features();
        this.pm.beginTask("Collecting geometries...", size);
        while (linesIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)linesIterator.next();
            Geometry line = (Geometry)feature.getDefaultGeometry();
            geometriesList.add(line);
            this.pm.worked(1);
        }
        this.pm.done();
        linesIterator.close();
        int id = 0;
        this.pm.beginTask("Checking intersections...", size);
        for (int i = 0; i < size; ++i) {
            Geometry line = (Geometry)geometriesList.get(i);
            PreparedGeometry preparedLine = PreparedGeometryFactory.prepare((Geometry)line);
            for (int j = i + 1; j < size; ++j) {
                Geometry otherGeometry = (Geometry)geometriesList.get(j);
                if (!preparedLine.intersects(otherGeometry)) continue;
                Geometry intersection = line.intersection(otherGeometry);
                int numGeometries = intersection.getNumGeometries();
                for (int k = 0; k < numGeometries; ++k) {
                    SimpleFeature feature;
                    Object[] values;
                    SimpleFeatureBuilder builder;
                    Geometry geometryN = intersection.getGeometryN(k);
                    if (geometryN instanceof Point) {
                        builder = new SimpleFeatureBuilder(pointType);
                        Point p = (Point)geometryN;
                        values = new Object[]{p};
                        builder.addAll(values);
                        feature = builder.buildFeature(pointType.getTypeName() + "." + id++);
                        this.outPointsMap.add((Feature)feature);
                        continue;
                    }
                    if (!(geometryN instanceof LineString)) continue;
                    builder = new SimpleFeatureBuilder(linesType);
                    LineString l = (LineString)geometryN;
                    values = new Object[]{l};
                    builder.addAll(values);
                    feature = builder.buildFeature(linesType.getTypeName() + "." + id++);
                    this.outLinesMap.add((Feature)feature);
                }
            }
            this.pm.worked(1);
        }
        this.pm.done();
    }
}

