/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.contoursextractor;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import java.awt.geom.AffineTransform;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Collection;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.spatial.PixelOrientation;

@Description(value="Module that extracts contour lines from a raster.")
@Documentation(value="ContourExtractor.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Status(value=5)
@Label(value="Vector Processing")
@Name(value="contourextract")
@License(value="General Public License Version 3 (GPLv3)")
public class ContourExtractor
extends JGTModel {
    @Description(value="The raster on which to calculate the contours.")
    @In
    public GridCoverage2D inCoverage;
    @Description(value="The minimum value for the contours.")
    @In
    public Double pMin;
    @Description(value="The maximum value for the contours.")
    @In
    public Double pMax;
    @Description(value="The contours interval.")
    @In
    public Double pInterval;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The generated contour lines vector.")
    @Out
    public SimpleFeatureCollection outGeodata = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outGeodata == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inCoverage, this.pMin, this.pMax, this.pInterval);
        if (this.pMin > this.pMax) {
            throw new ModelsIllegalargumentException("Min has to be bigger than Max.", this);
        }
        AffineTransform mt2D = (AffineTransform)this.inCoverage.getGridGeometry().getGridToCRS2D(PixelOrientation.CENTER);
        ArrayList<Double> contourIntervals = new ArrayList<Double>();
        this.pm.message("Adding levels:");
        for (double level = this.pMin.doubleValue(); level <= this.pMax; level += this.pInterval.doubleValue()) {
            contourIntervals.add(level);
            this.pm.message("-> " + level);
        }
        this.pm.beginTask("Extracting contours...", -1);
        ParameterBlockJAI pb = new ParameterBlockJAI("Contour");
        pb.setSource("source0", (Object)this.inCoverage.getRenderedImage());
        pb.setParameter("levels", contourIntervals);
        RenderedOp dest = JAI.create((String)"Contour", (ParameterBlock)pb);
        Collection contours = (Collection)dest.getProperty("contours");
        this.pm.done();
        this.outGeodata = FeatureCollections.newCollection();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("contours");
        b.setCRS(this.inCoverage.getCoordinateReferenceSystem());
        b.add("the_geom", LineString.class);
        b.add("elevation", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        int id = 0;
        AffineTransformation jtsTransformation = new AffineTransformation(mt2D.getScaleX(), mt2D.getShearX(), mt2D.getTranslateX(), mt2D.getShearY(), mt2D.getScaleY(), mt2D.getTranslateY());
        for (LineString lineString : contours) {
            Object userData = lineString.getUserData();
            double elev = -1.0;
            if (userData instanceof Double) {
                elev = (Double)userData;
                lineString.setUserData(null);
            }
            lineString.apply((CoordinateSequenceFilter)jtsTransformation);
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            Object[] values = new Object[]{lineString, elev};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(type.getTypeName() + "." + id);
            ++id;
            this.outGeodata.add((Feature)feature);
        }
    }
}

