/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.contourlabels;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.features.FilterUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Generates a layer of point features with a given label text and angle, following reference lines intersecting them with a layer of countourlines.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Contourlines, Vector")
@Label(value="Vector Processing")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class ContourLinesLabeler
extends JGTModel {
    @Description(value="The contour lines.")
    @In
    public SimpleFeatureCollection inContour;
    @Description(value="Field name of the contour elevation")
    @In
    public String fElevation;
    @Description(value="The lines to intersect with the contours to generate label points.")
    @In
    public SimpleFeatureCollection inLines;
    @Description(value="The buffer to consider for every line.")
    @In
    public double buffer;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The labeled point layer.")
    @Out
    public SimpleFeatureCollection outPoints = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outPoints == null, this.doReset)) {
            return;
        }
        SimpleFeatureType inSchema = (SimpleFeatureType)this.inContour.getSchema();
        MemoryDataStore memDatastore = new MemoryDataStore(this.inContour);
        SimpleFeatureSource contourSource = memDatastore.getFeatureSource(memDatastore.getTypeNames()[0]);
        CoordinateReferenceSystem crs = inSchema.getCoordinateReferenceSystem();
        this.outPoints = FeatureCollections.newCollection();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("labelpoints");
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        b.add("elevation", Double.class);
        b.add("azimuth", Double.class);
        b.add("minus90", Double.class);
        SimpleFeatureType outType = b.buildFeatureType();
        int count = 0;
        SimpleFeatureIterator lineFeatureIterator = this.inLines.features();
        while (lineFeatureIterator.hasNext()) {
            SimpleFeature line = (SimpleFeature)lineFeatureIterator.next();
            Geometry lineGeom = (Geometry)line.getDefaultGeometry();
            Geometry lineBuffer = lineGeom.buffer(this.buffer);
            BoundingBox lineBounds = line.getBounds();
            Filter bboxFilter = FilterUtilities.getBboxFilter("the_geom", lineBounds);
            SimpleFeatureCollection filteredContours = contourSource.getFeatures(bboxFilter);
            SimpleFeatureIterator contourIterator = filteredContours.features();
            while (contourIterator.hasNext()) {
                Coordinate second;
                SimpleFeature contour = (SimpleFeature)contourIterator.next();
                Geometry contourGeom = (Geometry)contour.getDefaultGeometry();
                if (!lineBuffer.intersects(contourGeom)) continue;
                Geometry intersection = lineBuffer.intersection(contourGeom);
                Coordinate[] coordinates = intersection.getCoordinates();
                Coordinate first = coordinates[0];
                double azimuth = GeometryUtilities.azimuth(first, second = coordinates[1]);
                double azimuthFrom90 = azimuth - 90.0;
                if (azimuthFrom90 < 0.0) {
                    azimuthFrom90 = 360.0 + azimuthFrom90;
                }
                double elevation = ((Number)contour.getAttribute(this.fElevation)).doubleValue();
                Point labelPoint = GeometryUtilities.gf().createPoint(first);
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(outType);
                Object[] values = new Object[]{labelPoint, elevation, azimuth, azimuthFrom90};
                builder.addAll(values);
                SimpleFeature pointFeature = builder.buildFeature(outType.getTypeName() + "." + count++);
                this.outPoints.add((Feature)pointFeature);
            }
        }
    }
}

