/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.utils.gcpoints2world;

import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.math.Statistics;
import org.geotools.referencing.operation.builder.AdvancedAffineBuilder;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.SimilarTransformBuilder;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.opengis.geometry.DirectPosition;

@Description(value="A module to calculate world file coefficients from set of GCPs")
@Author(name="Jan Jezek", contact="http://code.google.com/p/oldmapsonline/")
@Keywords(value="gcp, wld")
@Status(value=5)
@Name(value="gcps2wld")
@License(value="General Public License Version 3 (GPLv3)")
public class GroundControlPoints2World
extends JGTModel {
    @Description(value="The file containing the ground control points.")
    @UI(value="infile")
    @In
    public String inFile;
    @Description(value="pSkew")
    @In
    public Double pSkew;
    @Description(value="pPhix")
    @In
    public Double pPhix;
    @Description(value="pPhiy")
    @In
    public Double pPhiy;
    @Description(value="pTx")
    @In
    public Double pTx;
    @Description(value="pTy")
    @In
    public Double pTy;
    @Description(value="pSx")
    @In
    public Double pSx;
    @Description(value="pSy")
    @In
    public Double pSy;
    @Description(value="doSimilar")
    @In
    public boolean doSimilar = false;
    @Description(value="outScaley")
    @Out
    public double outScaley;
    @Description(value="outScalex")
    @Out
    public double outScalex;
    @Description(value="outSheary")
    @Out
    public double outSheary;
    @Description(value="outShearx")
    @Out
    public double outShearx;
    @Description(value="outTranslatex")
    @Out
    public double outTranslatex;
    @Description(value="outTranslatey")
    @Out
    public double outTranslatey;
    @Description(value="outErrmean")
    @Out
    public double outErrmean;
    @Description(value="outErrrms")
    @Out
    public double outErrrms;
    @Description(value="outErrmax")
    @Out
    public double outErrmax;
    @Description(value="outErrmin")
    @Out
    public double outErrmin;

    @Execute
    public void process() throws Exception {
        String s;
        this.checkNull(this.inFile);
        ArrayList<MappedPosition> mps = new ArrayList<MappedPosition>();
        FileInputStream stream = new FileInputStream(this.inFile);
        BufferedReader cti = new BufferedReader(new InputStreamReader(stream));
        while ((s = cti.readLine()) != null) {
            String[] line = s.trim().split("\\s+");
            DirectPosition2D tp = new DirectPosition2D(null, (double)new Float(line[0]).floatValue(), (double)new Float(line[1]).floatValue());
            DirectPosition2D sp = new DirectPosition2D(null, (double)new Float(line[2]).floatValue(), (double)new Float(line[3]).floatValue());
            MappedPosition mp = new MappedPosition((DirectPosition)sp, (DirectPosition)tp);
            mps.add(mp);
        }
        Object ab = this.doSimilar ? new SimilarTransformBuilder(mps) : new AdvancedAffineBuilder(mps);
        ((AdvancedAffineBuilder)ab).setConstrain("sxy", this.pSkew.doubleValue());
        ((AdvancedAffineBuilder)ab).setConstrain("phix", this.pPhix.doubleValue());
        ((AdvancedAffineBuilder)ab).setConstrain("phiy", this.pPhiy.doubleValue());
        ((AdvancedAffineBuilder)ab).setConstrain("tx", this.pTx.doubleValue());
        ((AdvancedAffineBuilder)ab).setConstrain("ty", this.pTy.doubleValue());
        ((AdvancedAffineBuilder)ab).setConstrain("sx", this.pSx.doubleValue());
        ((AdvancedAffineBuilder)ab).setConstrain("sy", this.pSy.doubleValue());
        this.outScalex = ((AffineTransform)ab.getMathTransform()).getScaleX();
        this.outScaley = ((AffineTransform)ab.getMathTransform()).getScaleY();
        this.outSheary = ((AffineTransform)ab.getMathTransform()).getShearY();
        this.outShearx = ((AffineTransform)ab.getMathTransform()).getShearX();
        this.outTranslatex = ((AffineTransform)ab.getMathTransform()).getTranslateX();
        this.outTranslatey = ((AffineTransform)ab.getMathTransform()).getTranslateY();
        Statistics errorStatistics = ab.getErrorStatistics();
        this.outErrmean = errorStatistics.mean();
        this.outErrrms = errorStatistics.rms();
        this.outErrmax = errorStatistics.maximum();
        this.outErrmin = errorStatistics.minimum();
    }
}

