/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.utils.fileiterator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Initialize;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.files.FileTraversal;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that iterates over files in a folder")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Iterator, File")
@Label(value="List Data Reader")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class FileIterator
extends JGTModel {
    @Description(value="The folder on which to iterate")
    @UI(value="infolder")
    @In
    public String inFolder;
    @Description(value="Regular expression to match the file names.")
    @In
    public String pRegex = null;
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The current file of the list of files in the folder.")
    @Out
    public String outCurrentfile = null;
    @Description(value="All the files that were found matching.")
    @Out
    public List<File> filesList = null;
    @Description(value="All the file path that were found matching.")
    @Out
    public List<String> pathsList = null;
    private int fileIndex = 0;
    private String prjWkt;

    @Initialize
    public void initProcess() {
        this.doProcess = true;
    }

    @Execute
    public void process() throws Exception {
        if (this.pCode != null) {
            CoordinateReferenceSystem crs = CRS.decode((String)this.pCode);
            this.prjWkt = crs.toWKT();
        }
        if (this.filesList == null) {
            this.filesList = new ArrayList<File>();
            this.pathsList = new ArrayList<String>();
            new FileTraversal(){

                @Override
                public void onFile(File f) {
                    if (FileIterator.this.pRegex == null) {
                        FileIterator.this.filesList.add(f);
                        FileIterator.this.pathsList.add(f.getAbsolutePath());
                    } else if (f.getName().matches(".*" + FileIterator.this.pRegex + ".*")) {
                        FileIterator.this.filesList.add(f);
                        FileIterator.this.pathsList.add(f.getAbsolutePath());
                    }
                }
            }.traverse(new File(this.inFolder));
            if (this.prjWkt != null) {
                for (File file : this.filesList) {
                    String nameWithoutExtention = FileUtilities.getNameWithoutExtention(file);
                    File prjFile = new File(file.getParentFile(), nameWithoutExtention + ".prj");
                    if (prjFile.exists()) continue;
                    FileUtilities.writeFile(this.prjWkt, prjFile);
                }
            }
        }
        this.outCurrentfile = this.filesList.get(this.fileIndex).getAbsolutePath();
        if (this.fileIndex == this.filesList.size() - 1) {
            this.doProcess = false;
        }
        ++this.fileIndex;
    }

    public static void addPrj(String folder, String epsg) throws Exception {
        FileIterator fiter = new FileIterator();
        fiter.inFolder = folder;
        fiter.pCode = epsg;
        fiter.process();
    }
}

