/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.windowsampler;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jaitools.imageutils.WindowIterator;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;

@Description(value="Module to do coverage downsampling on defined windows.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Downsampling, Interpolation")
@Label(value="Raster Processing")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class WindowSampler
extends JGTModel {
    @Description(value="The input coverage.")
    @In
    public GridCoverage2D inGeodata;
    @Description(value="The mode to use: average (0 = default), sum (1), max (2), min (3).")
    @In
    public int pMode = 0;
    @Description(value="The windows rows to use (default is 3).")
    @In
    public int pRows = 3;
    @Description(value="The window cols to use (default is 3).")
    @In
    public int pCols = 3;
    @Description(value="The windows rows to use (default is = pCols).")
    @In
    public Integer pXstep;
    @Description(value="The window cols to use (default is = pRows).")
    @In
    public Integer pYstep;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The output coverage.")
    @Out
    public GridCoverage2D outGeodata;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inGeodata);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inGeodata);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        int xstep = cols;
        int ystep = rows;
        if (this.pXstep != null) {
            xstep = this.pXstep;
        }
        if (this.pYstep != null) {
            ystep = this.pYstep;
        }
        int newRows = (int)Math.ceil((double)rows / (double)ystep);
        int newCols = (int)Math.ceil((double)cols / (double)xstep);
        WritableRaster outputWR = CoverageUtilities.createDoubleWritableRaster(newCols, newRows, null, null, Double.NaN);
        WindowIterator iter = new WindowIterator(this.inGeodata.getRenderedImage(), null, new Dimension(this.pCols, this.pRows), new Point(0, 0), xstep, ystep, (Number)Double.NaN);
        for (int r = 0; r < newRows; ++r) {
            for (int c = 0; c < newCols; ++c) {
                double[][] window = iter.getWindowDouble((double[][])null);
                double newValue = this.calculateValue(window);
                iter.next();
                outputWR.setSample(c, r, 0, newValue);
            }
        }
        this.outGeodata = CoverageUtilities.buildCoverage("downsampled", outputWR, (HashMap<String, Double>)regionMap, this.inGeodata.getCoordinateReferenceSystem());
    }

    private double calculateValue(double[][] window) {
        switch (this.pMode) {
            case 0: {
                double avg = 0.0;
                int num = 0;
                for (int i = 0; i < window.length; ++i) {
                    for (int j = 0; j < window[0].length; ++j) {
                        if (JGTConstants.isNovalue(window[i][j])) continue;
                        avg += window[i][j];
                        ++num;
                    }
                }
                return avg /= (double)num;
            }
            case 1: {
                double sum = 0.0;
                for (int i = 0; i < window.length; ++i) {
                    for (int j = 0; j < window[0].length; ++j) {
                        if (JGTConstants.isNovalue(window[i][j])) continue;
                        sum += window[i][j];
                    }
                }
                return sum;
            }
            case 2: {
                double max = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < window.length; ++i) {
                    for (int j = 0; j < window[0].length; ++j) {
                        if (JGTConstants.isNovalue(window[i][j])) continue;
                        max = Math.max(window[i][j], max);
                    }
                }
                return max;
            }
            case 3: {
                double min = Double.POSITIVE_INFINITY;
                for (int i = 0; i < window.length; ++i) {
                    for (int j = 0; j < window[0].length; ++j) {
                        if (JGTConstants.isNovalue(window[i][j])) continue;
                        min = Math.min(window[i][j], min);
                    }
                }
                return min;
            }
        }
        throw new ModelsIllegalargumentException("Mode not recognized: " + this.pMode, this);
    }
}

