/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.transformer;

import javax.media.jai.Interpolation;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.Operations;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.modules.JGTProcessingRegion;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;

@Description(value="Module to do coverage resolution resampling.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Convert")
@Label(value="Raster Processing")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class RasterResolutionResampler
extends JGTModel {
    @Description(value="The input coverage.")
    @In
    public GridCoverage2D inGeodata;
    @Description(value="The interpolation type to use: nearest neightbour (0), bilinear (1), bicubic (2)")
    @In
    public int pInterpolation = 0;
    @Description(value="The new resolution in X")
    @In
    public Double pXres;
    @Description(value="The new resolution in Y (if null taken same as pXres)")
    @In
    public Double pYres;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The output coverage.")
    @Out
    public GridCoverage2D outGeodata;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inGeodata, this.pXres);
        if (this.pYres == null) {
            this.pYres = this.pXres;
        }
        JGTProcessingRegion region = new JGTProcessingRegion(this.inGeodata);
        region.setWEResolution(this.pXres);
        region.setNSResolution(this.pYres);
        GridGeometry2D newGridGeometry = region.getGridGeometry(this.inGeodata.getCoordinateReferenceSystem());
        Interpolation interpolation = Interpolation.getInstance((int)0);
        switch (this.pInterpolation) {
            case 1: {
                interpolation = Interpolation.getInstance((int)1);
                break;
            }
            case 2: {
                interpolation = Interpolation.getInstance((int)2);
                break;
            }
        }
        this.pm.beginTask("Resampling...", -1);
        this.outGeodata = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)this.inGeodata, this.inGeodata.getCoordinateReferenceSystem(), (GridGeometry)newGridGeometry, interpolation);
        this.pm.done();
    }
}

