/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.summary;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jaitools.media.jai.zonalstats.Result;
import org.jaitools.media.jai.zonalstats.ZonalStats;
import org.jaitools.numeric.Statistic;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.math.CoupledFieldsMoments;

@Description(value="Calculate a summary of the map with base statistics.")
@Documentation(value="RasterSummary.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Statistics, Raster, Mapcalc")
@Label(value="Raster Processing")
@Name(value="rsummary")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterSummary
extends JGTModel {
    @Description(value="The map to analize.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The number of bins for the histogram (default = 100).")
    @In
    public int pBins = 100;
    @Description(value="Flag that defines if the histogram should be done also (default = false).")
    @In
    public boolean doHistogram = false;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The min value.")
    @Out
    public Double outMin = null;
    @Description(value="The max value.")
    @Out
    public Double outMax = null;
    @Description(value="The mean value.")
    @Out
    public Double outMean = null;
    @Description(value="The standard deviation value.")
    @Out
    public Double outSdev = null;
    @Description(value="The range value.")
    @Out
    public Double outRange = null;
    @Description(value="The sum value.")
    @Out
    public Double outSum = null;
    @Description(value="The histogram.")
    @Out
    public double[][] outCb = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outMin == null, this.doReset)) {
            return;
        }
        RenderedImage inRI = this.inRaster.getRenderedImage();
        ParameterBlockJAI pb = new ParameterBlockJAI("ZonalStats");
        pb.setSource("dataImage", (Object)inRI);
        Statistic[] stats = new Statistic[]{Statistic.MIN, Statistic.MAX, Statistic.MEAN, Statistic.SDEV, Statistic.RANGE, Statistic.SUM};
        pb.setParameter("stats", (Object)stats);
        RenderedOp op = JAI.create((String)"ZonalStats", (ParameterBlock)pb);
        ZonalStats zonalStats = (ZonalStats)op.getProperty("ZonalStatsProperty");
        List results = zonalStats.results();
        for (Result result : results) {
            Statistic statistic = result.getStatistic();
            Double value = result.getValue();
            switch (statistic) {
                case MIN: {
                    this.outMin = value;
                    break;
                }
                case MAX: {
                    this.outMax = value;
                    break;
                }
                case MEAN: {
                    this.outMean = value;
                    break;
                }
                case SDEV: {
                    this.outSdev = value;
                    break;
                }
                case RANGE: {
                    this.outRange = value;
                    break;
                }
                case SUM: {
                    this.outSum = value;
                    break;
                }
            }
        }
        if (!this.doHistogram) {
            return;
        }
        double[][] cb = new CoupledFieldsMoments().process(inRI, null, this.pBins, 1, 2, this.pm, 1);
        int width = inRI.getWidth();
        int height = inRI.getHeight();
        int pixelsNum = width * height;
        this.outCb = new double[cb.length + 1][3];
        double sum = 0.0;
        for (int i = 0; i < this.outCb.length; ++i) {
            double nans;
            if (i < this.outCb.length - 1) {
                this.outCb[i][0] = cb[i][0];
                this.outCb[i][1] = cb[i][1];
                sum += cb[i][1];
                this.outCb[i][2] = cb[i][1] * 100.0 / (double)pixelsNum;
                continue;
            }
            this.outCb[i][0] = Double.NaN;
            this.outCb[i][1] = nans = (double)pixelsNum - sum;
            this.outCb[i][2] = nans * 100.0 / (double)pixelsNum;
        }
    }
}

