/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.scanline;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.exceptions.ModelsRuntimeException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module for polygon vector to raster conversion.")
@Documentation(value="ScanLineRasterizer.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Rasterize")
@Label(value="Raster Processing")
@Status(value=40)
@Name(value="rscanline")
@License(value="General Public License Version 3 (GPLv3)")
public class ScanLineRasterizer
extends JGTModel {
    @Description(value="The vector to rasterize.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The value to use as raster value if no field is given.")
    @In
    public Double pValue = null;
    @Description(value="The field to use to retrieve the category value for the raster.")
    @In
    public String fCat = null;
    @Description(value="The north bound of the region to consider")
    @UI(value="process_north")
    @In
    public Double north = null;
    @Description(value="The south bound of the region to consider")
    @UI(value="process_south")
    @In
    public Double south = null;
    @Description(value="The west bound of the region to consider")
    @UI(value="process_west")
    @In
    public Double west = null;
    @Description(value="The east bound of the region to consider")
    @UI(value="process_east")
    @In
    public Double east = null;
    @Description(value="The rows of the region to consider")
    @UI(value="process_rows")
    @In
    public Integer rows = null;
    @Description(value="The cols of the region to consider")
    @UI(value="process_cols")
    @In
    public Integer cols = null;
    @Description(value="Max threads to use (default 15)")
    @In
    public Integer pMaxThreads = 15;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;
    private WritableRaster outWR;
    private int height;
    private int width;
    private GeometryFactory gf = GeometryUtilities.gf();
    private RegionMap paramsMap;
    private double xRes;

    @Execute
    public void process() throws Exception {
        GeometryType type;
        this.checkNull(this.inVector);
        if (this.pValue == null && this.fCat == null) {
            throw new ModelsIllegalargumentException("One of pValue or the fCat have to be defined.", this);
        }
        SimpleFeatureType schema = (SimpleFeatureType)this.inVector.getSchema();
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        GridGeometry2D pGrid = CoverageUtilities.gridGeometryFromRegionValues(this.north, this.south, this.east, this.west, this.cols, this.rows, crs);
        if (this.outWR == null) {
            this.paramsMap = CoverageUtilities.gridGeometry2RegionParamsMap(pGrid);
            this.height = this.paramsMap.getRows();
            this.width = this.paramsMap.getCols();
            this.xRes = this.paramsMap.getXres();
            this.outWR = CoverageUtilities.createDoubleWritableRaster(this.width, this.height, null, null, Double.NaN);
        }
        if (GeometryUtilities.getGeometryType(type = schema.getGeometryDescriptor().getType()) == GeometryUtilities.GEOMETRYTYPE.POINT || GeometryUtilities.getGeometryType(type) == GeometryUtilities.GEOMETRYTYPE.MULTIPOINT) {
            throw new ModelsRuntimeException("Not implemented yet for points", this.getClass().getSimpleName());
        }
        if (GeometryUtilities.getGeometryType(type) == GeometryUtilities.GEOMETRYTYPE.LINE || GeometryUtilities.getGeometryType(type) == GeometryUtilities.GEOMETRYTYPE.MULTILINE) {
            throw new ModelsRuntimeException("Not implemented yet for lines", this.getClass().getSimpleName());
        }
        if (GeometryUtilities.getGeometryType(type) != GeometryUtilities.GEOMETRYTYPE.POLYGON && GeometryUtilities.getGeometryType(type) != GeometryUtilities.GEOMETRYTYPE.MULTIPOLYGON) {
            throw new ModelsIllegalargumentException("Couldn't recognize the geometry type of the file.", this.getClass().getSimpleName());
        }
        this.rasterizepolygon(pGrid);
        this.outRaster = CoverageUtilities.buildCoverage("rasterized", this.outWR, (HashMap<String, Double>)this.paramsMap, ((SimpleFeatureType)this.inVector.getSchema()).getCoordinateReferenceSystem());
    }

    private void rasterizepolygon(final GridGeometry2D gridGeometry) throws InvalidGridGeometryException, TransformException {
        int size = this.inVector.size();
        this.pm.beginTask("Rasterizing features...", size);
        SimpleFeatureIterator featureIterator = this.inVector.features();
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(this.pMaxThreads);
        while (featureIterator.hasNext()) {
            final SimpleFeature feature = (SimpleFeature)featureIterator.next();
            double tmpValue = -1.0;
            tmpValue = this.pValue == null ? ((Double)feature.getAttribute(this.fCat)).doubleValue() : this.pValue.doubleValue();
            final double value = tmpValue;
            final double delta = this.xRes / 4.0;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        Geometry geometry = (Geometry)feature.getDefaultGeometry();
                        int numGeometries = geometry.getNumGeometries();
                        for (int i = 0; i < numGeometries; ++i) {
                            Geometry geometryN = geometry.getGeometryN(i);
                            for (int r = 0; r < ScanLineRasterizer.this.height; ++r) {
                                double[] westPos = gridGeometry.gridToWorld(new GridCoordinates2D(0, r)).getCoordinate();
                                double[] eastPos = gridGeometry.gridToWorld(new GridCoordinates2D(ScanLineRasterizer.this.width - 1, r)).getCoordinate();
                                Coordinate west = new Coordinate(westPos[0], westPos[1]);
                                Coordinate east = new Coordinate(eastPos[0], eastPos[1]);
                                LineString line = ScanLineRasterizer.this.gf.createLineString(new Coordinate[]{west, east});
                                if (!geometryN.intersects((Geometry)line)) continue;
                                Geometry internalLines = geometryN.intersection((Geometry)line);
                                Coordinate[] coords = internalLines.getCoordinates();
                                for (int j = 0; j < coords.length; j += 2) {
                                    Coordinate startC = new Coordinate(coords[j].x + delta, coords[j].y);
                                    Coordinate endC = new Coordinate(coords[j + 1].x - delta, coords[j + 1].y);
                                    GridCoordinates2D startGridCoord = gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(startC.x, startC.x));
                                    GridCoordinates2D endGridCoord = gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(endC.x, endC.x));
                                    for (int k = startGridCoord.x; k <= endGridCoord.x; ++k) {
                                        ScanLineRasterizer.this.outWR.setSample(k, r, 0, value);
                                    }
                                }
                            }
                        }
                        ScanLineRasterizer.this.pm.worked(1);
                    }
                    catch (Exception e) {
                        ScanLineRasterizer.this.pm.errorMessage(e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            };
            fixedThreadPool.execute(runner);
        }
        try {
            fixedThreadPool.shutdown();
            fixedThreadPool.awaitTermination(30L, TimeUnit.DAYS);
            fixedThreadPool.shutdownNow();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pm.done();
        featureIterator.close();
    }
}

