/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.rastervectorintersection;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.jgrasstools.gears.libs.exceptions.ModelsRuntimeException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.modules.r.cutout.CutOut;
import org.jgrasstools.gears.modules.r.scanline.ScanLineRasterizer;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryType;

@Description(value="Module for raster with polygon vector intersection.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Intersect")
@Label(value="Raster Processing")
@Status(value=5)
@Name(value="rvintersector")
@License(value="General Public License Version 3 (GPLv3)")
public class RasterVectorIntersector
extends JGTModel {
    @Description(value="The polygon vector to use for the intersection.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The raster to use for the intersection.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="Flag to use to invert the result (default is false = keep data inside vector)")
    @In
    public boolean doInverse = false;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster, this.inVector);
        SimpleFeatureType schema = (SimpleFeatureType)this.inVector.getSchema();
        GeometryType type = schema.getGeometryDescriptor().getType();
        if (GeometryUtilities.getGeometryType(type) != GeometryUtilities.GEOMETRYTYPE.POLYGON && GeometryUtilities.getGeometryType(type) != GeometryUtilities.GEOMETRYTYPE.MULTIPOLYGON) {
            throw new ModelsRuntimeException("The module works only with polygon vectors.", this);
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        ScanLineRasterizer raster = new ScanLineRasterizer();
        raster.inVector = this.inVector;
        raster.cols = regionMap.getCols();
        raster.rows = regionMap.getRows();
        raster.north = regionMap.getNorth();
        raster.south = regionMap.getSouth();
        raster.east = regionMap.getEast();
        raster.west = regionMap.getWest();
        raster.pValue = 1.0;
        raster.process();
        GridCoverage2D rasterizedVector = raster.outRaster;
        CutOut cutout = new CutOut();
        cutout.pm = this.pm;
        cutout.inRaster = this.inRaster;
        cutout.inMask = rasterizedVector;
        cutout.doInverse = this.doInverse;
        cutout.process();
        this.outRaster = cutout.outRaster;
    }
}

