/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.rasterreprojector;

import javax.media.jai.Interpolation;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module for raster reprojection.")
@Documentation(value="RasterConverter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Crs, Reprojection, Raster, RasterConverter, RasterReader")
@Label(value="Raster Processing")
@Status(value=40)
@Name(value="rreproject")
@License(value="General Public License Version 3 (GPLv3)")
public class RasterReprojector
extends JGTModel {
    @Description(value="The raster that has to be reprojected.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The code defining the target coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The interpolation type to use: nearest neightbour (0), bilinear (1), bicubic (2)")
    @In
    public int pInterpolation = 0;
    @Description(value="The reprojected output raster.")
    @Out
    public GridCoverage2D outRaster = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        CoordinateReferenceSystem targetCrs = CRS.decode((String)this.pCode);
        Interpolation interpolationType = null;
        interpolationType = this.pInterpolation == 1 ? Interpolation.getInstance((int)1) : (this.pInterpolation == 2 ? Interpolation.getInstance((int)2) : (this.pInterpolation == 3 ? Interpolation.getInstance((int)3) : Interpolation.getInstance((int)0)));
        this.outRaster = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)this.inRaster, targetCrs, null, interpolationType);
    }
}

