/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.profile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.coverage.ProfilePoint;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;

@Description(value="Module creating profiles over rasters.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Profile, Raster")
@Label(value="Raster Processing")
@Name(value="profile")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class Profile
extends JGTModel {
    @Description(value="The raster map to use for the profile")
    @In
    public GridCoverage2D inRaster;
    @Description(value="Comma separated list of easting,northing coordinates to trace the profile on (optional).")
    @In
    public String inCoordinates;
    @Description(value="Line vector map to use to trace the profile on (optional).")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The output profile.")
    @Out
    public double[][] outProfile;

    @Execute
    public void process() throws Exception {
        SimpleFeatureIterator featuresIterator;
        int i;
        this.checkNull(this.inRaster);
        if (this.inCoordinates == null && this.inVector == null) {
            throw new ModelsIllegalargumentException("Either the coordinates or a vector map to trace the profile on have to be supplied.", this);
        }
        ArrayList<Coordinate> profileNodesList = new ArrayList<Coordinate>();
        if (this.inCoordinates != null && this.inCoordinates.length() > 0) {
            try {
                this.pm.message("Using supplied coordinates to trace the profile...");
                String[] split = this.inCoordinates.split(",");
                for (i = 0; i < split.length; ++i) {
                    double east = Double.parseDouble(split[i].trim());
                    double north = Double.parseDouble(split[++i].trim());
                    Coordinate tmp = new Coordinate(east, north);
                    profileNodesList.add(tmp);
                }
            }
            catch (Exception e) {
                throw new ModelsIllegalargumentException("A problem occurred while parsing the supplied profile nodes coordinates. Check your syntax.", this);
            }
        } else if (this.inVector != null && (featuresIterator = this.inVector.features()).hasNext()) {
            SimpleFeature f = (SimpleFeature)featuresIterator.next();
            Geometry geom = (Geometry)f.getDefaultGeometry();
            if (GeometryUtilities.isLine(geom)) {
                Coordinate[] coordinates;
                this.pm.message("Using supplied vector map to trace the profile...");
                for (Coordinate coordinate : coordinates = geom.getCoordinates()) {
                    profileNodesList.add(coordinate);
                }
            } else {
                throw new ModelsIllegalargumentException("The module works only for lines.", this);
            }
        }
        if (profileNodesList.size() < 2) {
            throw new ModelsIllegalargumentException("We need at least two coordinates to create a profile. Check your syntax.", this);
        }
        List<ProfilePoint> profilePoints = CoverageUtilities.doProfile(this.inRaster, profileNodesList.toArray(new Coordinate[0]));
        this.outProfile = new double[profilePoints.size()][4];
        for (i = 0; i < profilePoints.size(); ++i) {
            ProfilePoint profilePoint = profilePoints.get(i);
            double progressive = profilePoint.getProgressive();
            double elev = profilePoint.getElevation();
            Coordinate coord = profilePoint.getPosition();
            this.outProfile[i][0] = progressive;
            this.outProfile[i][1] = elev;
            this.outProfile[i][2] = coord.x;
            this.outProfile[i][3] = coord.y;
        }
    }
}

