/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.mapcalc;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.TiledImage;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jaitools.imageutils.ImageUtils;
import org.jaitools.jiffle.Jiffle;
import org.jaitools.jiffle.runtime.AffineCoordinateTransform;
import org.jaitools.jiffle.runtime.CoordinateTransform;
import org.jaitools.jiffle.runtime.JiffleDirectRuntime;
import org.jaitools.jiffle.runtime.JiffleEventListener;
import org.jaitools.jiffle.runtime.JiffleExecutor;
import org.jaitools.jiffle.runtime.JiffleExecutorResult;
import org.jaitools.jiffle.runtime.JiffleProgressListener;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.modules.r.mapcalc.WaitingListener;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module for doing raster map algebra.")
@Documentation(value="Mapcalc.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Mapcalc, Raster, CutOut")
@Label(value="Raster Processing")
@Name(value="mapcalc")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Mapcalc
extends JGTModel {
    @Description(value="The maps that are used in the calculation.")
    @In
    public List<GridCoverage2D> inRasters;
    @Description(value="The function to process.")
    @UI(value="multiline10,mapcalc")
    @In
    public String pFunction;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The resulting map picked from the inserted function.")
    @Out
    public GridCoverage2D outRaster = null;
    private HashMap<String, Double> regionParameters = null;
    private CoordinateReferenceSystem crs;
    private Rectangle2D worldBounds;
    private long updateInterval;
    private long totalCount = 100L;

    @Execute
    public void process() throws Exception {
        int nRows;
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        String script = this.pFunction;
        script = script.trim();
        Jiffle jiffle = new Jiffle();
        jiffle.setScript(script);
        jiffle.compile();
        JiffleDirectRuntime jiffleRuntime = jiffle.getRuntimeInstance();
        CoordinateTransform jiffleCRS = null;
        for (GridCoverage2D mapGC : this.inRasters) {
            if (this.regionParameters == null) {
                this.regionParameters = CoverageUtilities.getRegionParamsFromGridCoverage(mapGC);
                this.crs = mapGC.getCoordinateReferenceSystem();
                this.worldBounds = mapGC.getEnvelope2D().getBounds2D();
                Rectangle gridBounds = mapGC.getGridGeometry().getGridRange2D().getBounds();
                jiffleCRS = Mapcalc.getTransform(this.worldBounds, gridBounds);
                double xRes = this.regionParameters.get("XRES");
                double yRes = this.regionParameters.get("YRES");
                jiffleRuntime.setWorldByResolution(this.worldBounds, xRes, yRes);
            }
            RenderedImage renderedImage = mapGC.getRenderedImage();
            String name = mapGC.getName().toString();
            jiffleRuntime.setSourceImage(name, renderedImage, jiffleCRS);
        }
        if (this.regionParameters == null) {
            throw new ModelsIllegalargumentException("No map has been supplied.", this.getClass().getSimpleName());
        }
        int nCols = this.regionParameters.get("COLS").intValue();
        long pixelsNum = (long)nCols * (long)(nRows = this.regionParameters.get("ROWS").intValue());
        if (pixelsNum < this.totalCount) {
            this.totalCount = pixelsNum;
        }
        this.updateInterval = pixelsNum / this.totalCount;
        String destName = jiffleRuntime.getDestinationVarNames()[0];
        TiledImage destImg = ImageUtils.createConstantImage((int)nCols, (int)nRows, (Number)0.0);
        jiffleRuntime.setDestinationImage(destName, (WritableRenderedImage)destImg, jiffleCRS);
        JiffleExecutor executor = new JiffleExecutor();
        WaitingListener listener = new WaitingListener();
        executor.addEventListener((JiffleEventListener)listener);
        listener.setNumTasks(1);
        executor.submit(jiffleRuntime, new JiffleProgressListener(){
            private long count = 0L;

            public void update(long done) {
                if (this.count == done) {
                    Mapcalc.this.pm.worked(1);
                    this.count += Mapcalc.this.updateInterval;
                }
            }

            public void start() {
                Mapcalc.this.pm.beginTask("Processing maps...", (int)Mapcalc.this.totalCount);
            }

            public void setUpdateInterval(double propPixels) {
            }

            public void setUpdateInterval(long numPixels) {
            }

            public void setTaskSize(long numPixels) {
                this.count = Mapcalc.this.updateInterval;
            }

            public long getUpdateInterval() {
                if (Mapcalc.this.updateInterval == 0L) {
                    return 1L;
                }
                return Mapcalc.this.updateInterval;
            }

            public void finish() {
                Mapcalc.this.pm.done();
            }
        });
        listener.await();
        JiffleExecutorResult result = listener.getResults().get(0);
        Map imgMap = result.getImages();
        RenderedImage destImage = (RenderedImage)imgMap.get(destName);
        this.outRaster = CoverageUtilities.buildCoverage(destName, destImage, this.regionParameters, this.crs);
        executor.shutdown();
    }

    private static CoordinateTransform getTransform(Rectangle2D worldBounds, Rectangle imageBounds) {
        if (worldBounds == null || worldBounds.isEmpty()) {
            throw new IllegalArgumentException("worldBounds must not be null or empty");
        }
        if (imageBounds == null || imageBounds.isEmpty()) {
            throw new IllegalArgumentException("imageBounds must not be null or empty");
        }
        double xscale = (imageBounds.getMaxX() - imageBounds.getMinX()) / (worldBounds.getMaxX() - worldBounds.getMinX());
        double xoff = imageBounds.getMinX() - xscale * worldBounds.getMinX();
        double yscale = (imageBounds.getMaxY() - imageBounds.getMinY()) / (worldBounds.getMaxY() - worldBounds.getMinY());
        double yoff = imageBounds.getMinY() - yscale * worldBounds.getMinY();
        return new AffineCoordinateTransform(new AffineTransform(xscale, 0.0, 0.0, yscale, xoff, yoff));
    }
}

