/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.monitor;

import java.util.logging.Logger;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;

public class LogProgressMonitor
implements IJGTProgressMonitor {
    private static final Logger log = Logger.getLogger("org.jgrasstools");
    protected boolean cancelled = false;
    protected String taskName;
    protected int totalWork;
    protected int runningWork;
    protected int lastPercentage = -1;
    private String prefix = null;

    @Override
    public void beginTask(String name, int totalWork) {
        this.taskName = name;
        this.totalWork = totalWork;
        this.runningWork = 0;
        if (this.prefix != null) {
            this.taskName = this.prefix + this.taskName;
        }
        System.out.println(this.taskName);
    }

    public void beginTask(String name) {
        this.taskName = name;
        this.totalWork = -1;
        this.runningWork = 0;
        if (this.prefix != null) {
            this.taskName = this.prefix + this.taskName;
        }
        System.out.println(this.taskName);
    }

    @Override
    public void done() {
        String msg = "Finished.";
        if (this.prefix != null) {
            msg = this.prefix + msg;
        }
        System.out.println(msg);
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    @Override
    public void setCanceled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public void setTaskName(String name) {
        this.taskName = name;
    }

    @Override
    public void subTask(String name) {
    }

    @Override
    public void worked(int work) {
        if (this.totalWork == -1) {
            String msg = "...";
            if (this.prefix != null) {
                msg = this.prefix + msg;
            }
            System.out.println(msg);
        } else {
            this.runningWork += work;
            int percentage = 100 * this.runningWork / this.totalWork;
            if (percentage % 10 == 0 && percentage != this.lastPercentage) {
                String msg = percentage + "%...";
                if (this.prefix != null) {
                    msg = this.prefix + msg;
                }
                System.out.println(msg);
                this.lastPercentage = percentage;
            }
        }
    }

    @Override
    public <T> T adapt(Class<T> adaptee) {
        return null;
    }

    @Override
    public void errorMessage(String message) {
        System.err.println(message);
    }

    @Override
    public void message(String message) {
        System.out.println(message);
    }
}

