/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.modules;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import javax.vecmath.Point4d;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.DirectPosition2D;
import org.jgrasstools.gears.i18n.GearsMessageHandler;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.ModelsSupporter;
import org.jgrasstools.gears.libs.modules.SplitVectors;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class ModelsEngine {
    private static int[][] DIR = ModelsSupporter.DIR;
    private static int[][] dirIn = ModelsSupporter.DIR_WITHFLOW_ENTERING;
    private static GearsMessageHandler msg = GearsMessageHandler.getInstance();
    public static PixelInCell DEFAULTPIXELANCHOR = PixelInCell.CELL_CENTER;

    public static boolean go_downstream(int[] colRow, double flowdirection) {
        int n = (int)flowdirection;
        if (n == 10) {
            return true;
        }
        if (n < 1 || n > 9) {
            return false;
        }
        colRow[1] = colRow[1] + DIR[n][0];
        colRow[0] = colRow[0] + DIR[n][1];
        return true;
    }

    public static void go_upstream_a(int[] p, RandomIter flowRandomIter, RandomIter tcaRandomIter, RandomIter lRandomIter, int[] param) {
        double area = 0.0;
        double lenght = 0.0;
        int[] point = new int[2];
        int kk = 0;
        int count = 0;
        point[0] = p[0];
        point[1] = p[1];
        for (int k = 1; k <= 8; ++k) {
            if (flowRandomIter.getSampleDouble(p[0] + dirIn[k][1], p[1] + dirIn[k][0], 0) != (double)dirIn[k][2]) continue;
            ++count;
            if (!(tcaRandomIter.getSampleDouble(p[0] + dirIn[k][1], p[1] + dirIn[k][0], 0) >= area)) continue;
            if (tcaRandomIter.getSampleDouble(p[0] + dirIn[k][1], p[1] + dirIn[k][0], 0) == area) {
                if (!(lRandomIter.getSampleDouble(p[0] + dirIn[k][1], p[1] + dirIn[k][0], 0) > lenght)) continue;
                kk = k;
                area = tcaRandomIter.getSampleDouble(p[0] + dirIn[k][1], p[1] + dirIn[k][0], 0);
                lenght = lRandomIter.getSampleDouble(p[0] + dirIn[k][1], p[1] + dirIn[k][0], 0);
                point[0] = p[0] + dirIn[k][1];
                point[1] = p[1] + dirIn[k][0];
                continue;
            }
            kk = k;
            area = tcaRandomIter.getSampleDouble(p[0] + dirIn[k][1], p[1] + dirIn[k][0], 0);
            lenght = lRandomIter.getSampleDouble(p[0] + dirIn[k][1], p[1] + dirIn[k][0], 0);
            point[0] = p[0] + dirIn[k][1];
            point[1] = p[1] + dirIn[k][0];
        }
        p[0] = point[0];
        p[1] = point[1];
        param[0] = kk;
        param[1] = count;
    }

    public static void goUpStreamOnNetFixed(int[] colRow, RandomIter flowIterator, RandomIter netnumIterator, int[] param) {
        int k;
        int kk = 0;
        int count = 0;
        int[] point = new int[2];
        for (k = 1; k <= 8; ++k) {
            if (flowIterator.getSampleDouble(colRow[0] + dirIn[k][1], colRow[1] + dirIn[k][0], 0) != (double)dirIn[k][2]) continue;
            ++count;
            if (netnumIterator.getSampleDouble(colRow[0] + dirIn[k][1], colRow[1] + dirIn[k][0], 0) != netnumIterator.getSampleDouble(colRow[0], colRow[1], 0)) continue;
            kk = k;
            point[0] = colRow[0] + dirIn[k][1];
            point[1] = colRow[1] + dirIn[k][0];
        }
        if (kk == 0) {
            for (k = 1; k <= 8; ++k) {
                if (flowIterator.getSampleDouble(colRow[0] + dirIn[k][1], colRow[1] + dirIn[k][0], 0) != (double)dirIn[k][2]) continue;
                kk = k;
                point[0] = colRow[0] + dirIn[k][1];
                point[1] = colRow[1] + dirIn[k][0];
            }
        }
        colRow[0] = point[0];
        colRow[1] = point[1];
        param[0] = kk;
        param[1] = count;
    }

    public static SimpleFeatureCollection net2ShapeOnly(RenderedImage flowImage, WritableRaster netNumImage, GridGeometry2D gridGeometry, List<Integer> nstream, IJGTProgressMonitor pm) throws IOException, TransformException {
        int activecols = flowImage.getWidth();
        int activerows = flowImage.getHeight();
        int[] flow = new int[2];
        int[] flow_p = new int[2];
        CoordinateList coordlist = new CoordinateList();
        RandomIter m1RandomIter = RandomIterFactory.create((RenderedImage)flowImage, null);
        RandomIter netNumRandomIter = RandomIterFactory.create((Raster)netNumImage, null);
        LineString[] newGeometry = new LineString[nstream.size()];
        ArrayList<LineString> newGeometryVectorLine = new ArrayList<LineString>();
        GeometryFactory newfactory = new GeometryFactory();
        pm.beginTask(msg.message("utils.extracting_network_geometries"), nstream.size());
        for (int num = 1; num <= nstream.size(); ++num) {
            for (int y = 0; y < activerows; ++y) {
                for (int x = 0; x < activecols; ++x) {
                    if (JGTConstants.isNovalue(m1RandomIter.getSampleDouble(x, y, 0))) continue;
                    flow[0] = x;
                    flow[1] = y;
                    if (netNumRandomIter.getSampleDouble(x, y, 0) != (double)num || !ModelsEngine.sourcesNet(m1RandomIter, flow, num, netNumRandomIter)) continue;
                    flow_p[0] = flow[0];
                    flow_p[1] = flow[1];
                    double[] worldPosition = gridGeometry.gridToWorld(new GridCoordinates2D(flow[0], flow[1])).getCoordinate();
                    Coordinate coordSource = new Coordinate(worldPosition[0], worldPosition[1]);
                    coordlist.add((Object)coordSource);
                    if (!ModelsEngine.go_downstream(flow, m1RandomIter.getSampleDouble(flow[0], flow[1], 0))) {
                        return null;
                    }
                    while (!JGTConstants.isNovalue(m1RandomIter.getSampleDouble(flow[0], flow[1], 0)) && m1RandomIter.getSampleDouble(flow[0], flow[1], 0) != 10.0 && netNumRandomIter.getSampleDouble(flow[0], flow[1], 0) == (double)num && !JGTConstants.isNovalue(netNumRandomIter.getSampleDouble(flow[0], flow[1], 0))) {
                        worldPosition = gridGeometry.gridToWorld(new GridCoordinates2D(flow[0], flow[1])).getCoordinate();
                        Coordinate coordPoint = new Coordinate(worldPosition[0], worldPosition[1]);
                        coordlist.add((Object)coordPoint);
                        flow_p[0] = flow[0];
                        flow_p[1] = flow[1];
                        if (ModelsEngine.go_downstream(flow, m1RandomIter.getSampleDouble(flow[0], flow[1], 0))) continue;
                        return null;
                    }
                    worldPosition = gridGeometry.gridToWorld(new GridCoordinates2D(flow[0], flow[1])).getCoordinate();
                    Coordinate coordNode = new Coordinate(worldPosition[0], worldPosition[1]);
                    coordlist.add((Object)coordNode);
                }
            }
            newGeometry[num - 1] = newfactory.createLineString(coordlist.toCoordinateArray());
            newGeometryVectorLine.add(newGeometry[num - 1]);
            coordlist.clear();
            pm.worked(1);
        }
        pm.done();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("network");
        b.setCRS(gridGeometry.getCoordinateReferenceSystem());
        b.add("the_geom", LineString.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        SimpleFeatureCollection featureCollection = FeatureCollections.newCollection();
        int index = 0;
        for (LineString lineString : newGeometryVectorLine) {
            Object[] values = new Object[]{lineString};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(type.getTypeName() + "." + index);
            ++index;
            featureCollection.add((Feature)feature);
        }
        return featureCollection;
    }

    public static List<MultiLineString> net2ShapeGeometries(WritableRandomIter flowIter, RandomIter netNumIter, int[] nstream, GridGeometry2D gridGeometry, IJGTProgressMonitor pm) throws IOException, TransformException {
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int rows = gridRange.height;
        int cols = gridRange.width;
        MathTransform2D gridToCRS2D = gridGeometry.getGridToCRS2D();
        int[] flow = new int[2];
        int[] flow_p = new int[2];
        CoordinateList coordlist = new CoordinateList();
        ArrayList<MultiLineString> newGeometryVectorLine = new ArrayList<MultiLineString>();
        GeometryFactory newfactory = new GeometryFactory();
        pm.beginTask("Extracting the network geometries...", nstream[0]);
        for (int num = 1; num <= nstream[0]; ++num) {
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < cols; ++x) {
                    flow[0] = x;
                    flow[1] = y;
                    if (netNumIter.getSampleDouble(x, y, 0) != (double)num || !ModelsEngine.sourcesNet((RandomIter)flowIter, flow, num, netNumIter)) continue;
                    flow_p[0] = flow[0];
                    flow_p[1] = flow[1];
                    Point2D.Double worldPosition = new Point2D.Double(flow[0], flow[1]);
                    gridToCRS2D.transform((Point2D)worldPosition, (Point2D)worldPosition);
                    Coordinate coordSource = new Coordinate(((Point2D)worldPosition).getX(), ((Point2D)worldPosition).getY());
                    coordlist.add((Object)coordSource);
                    if (!ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0))) {
                        return null;
                    }
                    while (!JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0)) && flowIter.getSampleDouble(flow[0], flow[1], 0) != 10.0 && netNumIter.getSampleDouble(flow[0], flow[1], 0) == (double)num && !JGTConstants.isNovalue(netNumIter.getSampleDouble(flow[0], flow[1], 0))) {
                        worldPosition = new Point2D.Double(flow[0], flow[1]);
                        gridToCRS2D.transform((Point2D)worldPosition, (Point2D)worldPosition);
                        Coordinate coordPoint = new Coordinate(((Point2D)worldPosition).getX(), ((Point2D)worldPosition).getY());
                        coordlist.add((Object)coordPoint);
                        flow_p[0] = flow[0];
                        flow_p[1] = flow[1];
                        if (ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0))) continue;
                        return null;
                    }
                    worldPosition = new Point2D.Double(flow[0], flow[1]);
                    gridToCRS2D.transform((Point2D)worldPosition, (Point2D)worldPosition);
                    Coordinate coordNode = new Coordinate(((Point2D)worldPosition).getX(), ((Point2D)worldPosition).getY());
                    coordlist.add((Object)coordNode);
                }
            }
            newGeometryVectorLine.add(newfactory.createMultiLineString(new LineString[]{newfactory.createLineString(coordlist.toCoordinateArray())}));
            coordlist.clear();
            pm.worked(1);
        }
        pm.done();
        return newGeometryVectorLine;
    }

    public static boolean sourcesNet(RandomIter flowIterator, int[] colRow, int num, RandomIter netNum) {
        int[][] dir = new int[][]{{0, 0, 0}, {1, 0, 5}, {1, -1, 6}, {0, -1, 7}, {-1, -1, 8}, {-1, 0, 1}, {-1, 1, 2}, {0, 1, 3}, {1, 1, 4}};
        if (flowIterator.getSampleDouble(colRow[0], colRow[1], 0) <= 10.0 && flowIterator.getSampleDouble(colRow[0], colRow[1], 0) > 0.0) {
            for (int k = 1; k <= 8; ++k) {
                if (flowIterator.getSampleDouble(colRow[0] + dir[k][0], colRow[1] + dir[k][1], 0) != (double)dir[k][2] || netNum.getSampleDouble(colRow[0] + dir[k][0], colRow[1] + dir[k][1], 0) != (double)num) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static double[] vectorizeDoubleMatrix(RenderedImage input) {
        double[] U = new double[input.getWidth() * input.getHeight()];
        RandomIter inputRandomIter = RandomIterFactory.create((RenderedImage)input, null);
        int j = 0;
        for (int i = 0; i < input.getHeight() * input.getWidth(); i += input.getWidth()) {
            double[] tmp = new double[input.getWidth()];
            for (int k = 0; k < input.getWidth(); ++k) {
                tmp[k] = inputRandomIter.getSampleDouble(k, j, 0);
            }
            System.arraycopy(tmp, 0, U, i, input.getWidth());
            ++j;
        }
        return U;
    }

    public static double split2realvectors(double[] U, double[] T, SplitVectors theSplit, int binNum, int num_max, IJGTProgressMonitor pm) {
        int previousCount;
        double binStep = 0.0;
        double minValue = 0.0;
        int count = 0;
        int minPosition = 0;
        int maxPosition = 0;
        int head = 0;
        int[] bins = new int[U.length];
        if (binNum <= 1) {
            previousCount = 1;
            count = 1;
            int index = 0;
            while (count < U.length) {
                while (count < U.length && U[count] == U[count - 1]) {
                    ++count;
                }
                bins[++index] = count - previousCount;
                previousCount = count++;
                if (++head <= num_max) continue;
                throw new ModelsIllegalargumentException("The number of bin eccedes the maximum number allowed.", "MODEL");
            }
        } else if (binNum > 1) {
            double maxValue = U[U.length - 1];
            for (minPosition = 0; minPosition < U.length && JGTConstants.isNovalue(U[minPosition]); ++minPosition) {
            }
            if (minPosition == U.length) {
                binStep = 0.0;
            } else {
                minValue = U[minPosition];
                maxPosition = U.length - 1;
                binStep = (maxValue - minValue) / (double)(binNum - 1);
            }
            if (binStep != 0.0) {
                int binIndex = 0;
                previousCount = minPosition;
                count = minPosition;
                int emptyBins = 0;
                double runningCenter = minValue + binStep / 2.0;
                for (int n = 0; n < binNum - 1; ++n) {
                    double upperLimitOfBin = n == binNum - 2 ? maxValue : runningCenter + binStep / 2.0;
                    if (U[count] <= upperLimitOfBin) {
                        double value = U[count];
                        while (value <= upperLimitOfBin && ++count <= maxPosition) {
                            value = U[count];
                        }
                        bins[binIndex] = count - previousCount;
                        ++binIndex;
                        ++head;
                        previousCount = count;
                    } else {
                        ++emptyBins;
                    }
                    runningCenter += binStep;
                }
                if (emptyBins != 0) {
                    pm.message(emptyBins + " empty bins where found");
                }
            } else {
                for (double tmpValue : U) {
                    if (JGTConstants.isNovalue(tmpValue)) continue;
                    ++count;
                }
                bins[0] = count;
                head = count;
            }
        }
        if (head < 1) {
            throw new ModelsIllegalargumentException("Something wrong happened in binning", "MODEL");
        }
        theSplit.initIndex(head);
        int maxnumberinbin = 0;
        for (int i = 0; i < head; ++i) {
            theSplit.splitIndex[i] = bins[i];
            if (bins[i] <= maxnumberinbin) continue;
            maxnumberinbin = bins[i];
        }
        theSplit.initValues(head, maxnumberinbin);
        int index = minPosition;
        for (int j = 0; j < head; ++j) {
            int k = 0;
            while ((double)k < theSplit.splitIndex[j]) {
                theSplit.splitValues1[j][k] = U[index];
                theSplit.splitValues2[j][k] = T[index];
                ++index;
                ++k;
            }
        }
        if (binNum < 2) {
            binStep = 0.0;
        }
        return binStep;
    }

    public static double doubleNMoment(double[] m, int nh, double mean, double NN, IJGTProgressMonitor pm) {
        double moment = 0.0;
        double n = 0.0;
        if (NN == 1.0) {
            for (int i = 0; i < nh; ++i) {
                if (JGTConstants.isNovalue(m[i])) continue;
                moment += m[i];
                n += 1.0;
            }
            if (n >= 1.0) {
                moment /= n;
            } else {
                pm.errorMessage("No valid data were processed, setting moment value to zero.");
                moment = 0.0;
            }
        } else if (NN == 2.0) {
            for (int i = 0; i < nh; ++i) {
                if (JGTConstants.isNovalue(m[i])) continue;
                moment += m[i] * m[i];
                n += 1.0;
            }
            if (n >= 1.0) {
                moment = moment / n - mean * mean;
            } else {
                pm.errorMessage("No valid data were processed, setting moment value to zero.");
                moment = 0.0;
            }
        } else {
            for (int i = 0; i < nh; ++i) {
                if (JGTConstants.isNovalue(m[i])) continue;
                moment += Math.pow(m[i] - mean, NN);
                n += 1.0;
            }
            if (n >= 1.0) {
                moment /= n;
            } else {
                pm.errorMessage("No valid data were processed, setting moment value to zero.");
                moment = 0.0;
            }
        }
        return moment;
    }

    public static WritableRaster netNumbering(List<Integer> nstream, RandomIter flowIter, RandomIter networkIter, int width, int height, IJGTProgressMonitor pm) {
        int[] flow = new int[2];
        int gg = 0;
        int n = 0;
        WritableRaster netnumWR = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
        WritableRandomIter netnumIter = RandomIterFactory.createWritable((WritableRaster)netnumWR, null);
        GearsMessageHandler msg = GearsMessageHandler.getInstance();
        pm.beginTask(msg.message("utils.numbering_stream"), height);
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int k;
                flow[0] = i;
                flow[1] = j;
                if (JGTConstants.isNovalue(networkIter.getSampleDouble(i, j, 0)) || flowIter.getSampleDouble(i, j, 0) == 10.0 || netnumIter.getSampleDouble(i, j, 0) != 0.0) continue;
                int f = 0;
                for (k = 1; k <= 8 && (flowIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != (double)dirIn[k][2] || JGTConstants.isNovalue(networkIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0))); ++k) {
                    ++f;
                }
                if (f != 8) continue;
                nstream.add(++n);
                netnumIter.setSample(i, j, 0, n);
                if (!ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0))) {
                    return null;
                }
                while (!JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0)) && netnumIter.getSampleDouble(flow[0], flow[1], 0) == 0.0) {
                    gg = 0;
                    for (k = 1; k <= 8; ++k) {
                        if (JGTConstants.isNovalue(networkIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0)) || flowIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != (double)dirIn[k][2]) continue;
                        ++gg;
                    }
                    if (gg >= 2) {
                        nstream.add(++n);
                        netnumIter.setSample(flow[0], flow[1], 0, n);
                    } else {
                        netnumIter.setSample(flow[0], flow[1], 0, n);
                    }
                    if (ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0))) continue;
                    return null;
                }
            }
            pm.worked(1);
        }
        pm.done();
        return netnumWR;
    }

    public static WritableRaster netNumberingWithTca(List<Integer> nstream, RandomIter mRandomIter, RandomIter netRandomIter, RandomIter tcaRandomIter, int cols, int rows, double tcaTh, IJGTProgressMonitor pm) {
        int[] flow = new int[2];
        int gg = 0;
        int n = 0;
        WritableRaster outImage = CoverageUtilities.createDoubleWritableRaster(cols, rows, null, null, null);
        WritableRandomIter oMatrixRandomIter = RandomIterFactory.createWritable((WritableRaster)outImage, null);
        double tcaValue = 0.0;
        pm.beginTask(msg.message("utils.numbering_stream"), rows);
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < cols; ++i) {
                int k;
                flow[0] = i;
                flow[1] = j;
                if (JGTConstants.isNovalue(netRandomIter.getSampleDouble(i, j, 0)) || mRandomIter.getSampleDouble(i, j, 0) == 10.0 || oMatrixRandomIter.getSampleDouble(i, j, 0) != 0.0) continue;
                int f = 0;
                for (k = 1; k <= 8 && (mRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != (double)dirIn[k][2] || JGTConstants.isNovalue(netRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0))); ++k) {
                    ++f;
                }
                if (f != 8) continue;
                nstream.add(++n);
                tcaValue = tcaRandomIter.getSampleDouble(i, j, 0);
                oMatrixRandomIter.setSample(i, j, 0, n);
                if (!ModelsEngine.go_downstream(flow, mRandomIter.getSampleDouble(flow[0], flow[1], 0))) {
                    return null;
                }
                while (!JGTConstants.isNovalue(mRandomIter.getSampleDouble(flow[0], flow[1], 0)) && oMatrixRandomIter.getSampleDouble(flow[0], flow[1], 0) == 0.0) {
                    gg = 0;
                    for (k = 1; k <= 8; ++k) {
                        if (JGTConstants.isNovalue(netRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0)) || mRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != (double)dirIn[k][2]) continue;
                        ++gg;
                    }
                    if (gg >= 2) {
                        nstream.add(++n);
                        oMatrixRandomIter.setSample(flow[0], flow[1], 0, n);
                        tcaValue = tcaRandomIter.getSampleDouble(flow[0], flow[1], 0);
                    } else if (tcaRandomIter.getSampleDouble(flow[0], flow[1], 0) - tcaValue > tcaTh) {
                        nstream.add(++n);
                        oMatrixRandomIter.setSample(flow[0], flow[1], 0, n);
                        tcaValue = tcaRandomIter.getSampleDouble(flow[0], flow[1], 0);
                    } else {
                        oMatrixRandomIter.setSample(flow[0], flow[1], 0, n);
                    }
                    if (ModelsEngine.go_downstream(flow, mRandomIter.getSampleDouble(flow[0], flow[1], 0))) continue;
                    return null;
                }
            }
            pm.worked(1);
        }
        pm.done();
        return outImage;
    }

    public static WritableRaster netNumberingWithPoints(List<Integer> nstream, RandomIter mRandomIter, RandomIter netRandomIter, int rows, int cols, List<HashMap<String, ?>> attributePoints, List<Geometry> geomVect, GridGeometry2D gridGeometry, IJGTProgressMonitor pm) throws InvalidGridGeometryException, TransformException {
        int[] flow = new int[2];
        int gg = 0;
        int n = 0;
        WritableRaster outImage = CoverageUtilities.createDoubleWritableRaster(cols, rows, null, null, null);
        WritableRandomIter oMatrixRandomIter = RandomIterFactory.createWritable((WritableRaster)outImage, null);
        Rectangle2D regionBox = gridGeometry.getEnvelope2D().getBounds2D();
        ArrayList<Point4d> points = new ArrayList<Point4d>();
        int l = 0;
        int numGeometry = 0;
        for (Geometry pointV : geomVect) {
            for (int i = 0; i < pointV.getNumGeometries(); ++i) {
                GridCoordinates2D gridCoordinate = gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(pointV.getCoordinates()[0].x, pointV.getCoordinates()[0].y));
                Number nodoId = (Number)attributePoints.get(numGeometry).get("RETE_ID");
                if (nodoId == null) {
                    throw new ModelsIllegalargumentException("Field RETE_ID not found", "");
                }
                if (nodoId.intValue() == -1 || !regionBox.contains(new Point2D.Double(pointV.getCoordinates()[0].x, pointV.getCoordinates()[0].y))) continue;
                points.add(new Point4d((double)gridCoordinate.x, (double)gridCoordinate.y, nodoId.doubleValue(), 0.0));
                ++l;
            }
            ++numGeometry;
        }
        int p = 0;
        for (Point4d point4d : points) {
            if (netRandomIter.getSampleDouble((int)point4d.x, (int)point4d.y, 0) == point4d.z) continue;
            for (int i = 1; i < 9; ++i) {
                int indexI = (int)point4d.x + dirIn[i][1];
                int indexJ = (int)point4d.y + dirIn[i][0];
                if (netRandomIter.getSampleDouble(indexI, indexJ, 0) != point4d.z) continue;
                point4d.x = indexI;
                point4d.y = indexJ;
            }
        }
        for (Point4d point4d : points) {
            if (netRandomIter.getSampleDouble((int)point4d.x, (int)point4d.y, 0) != point4d.z) continue;
            ++p;
        }
        pm.beginTask(msg.message("utils.numbering_stream"), rows);
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < cols; ++i) {
                flow[0] = i;
                flow[1] = j;
                if (JGTConstants.isNovalue(netRandomIter.getSampleDouble(i, j, 0)) || mRandomIter.getSampleDouble(i, j, 0) == 10.0 || oMatrixRandomIter.getSampleDouble(i, j, 0) != 0.0) continue;
                int f = 0;
                for (int k = 1; k <= 8 && (mRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != (double)dirIn[k][2] || JGTConstants.isNovalue(netRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0))); ++k) {
                    ++f;
                }
                if (f != 8) continue;
                nstream.add(++n);
                oMatrixRandomIter.setSample(i, j, 0, n);
                if (!ModelsEngine.go_downstream(flow, mRandomIter.getSampleDouble(flow[0], flow[1], 0))) {
                    return null;
                }
                for (Point4d point4d : points) {
                    if (point4d.x != (double)flow[0] || point4d.y != (double)flow[1]) continue;
                    nstream.add(++n);
                    point4d.w = n - 1;
                }
                while (!JGTConstants.isNovalue(mRandomIter.getSampleDouble(flow[0], flow[1], 0)) && oMatrixRandomIter.getSampleDouble(flow[0], flow[1], 0) == 0.0 && mRandomIter.getSampleDouble(flow[0], flow[1], 0) != 10.0) {
                    gg = 0;
                    for (int k = 1; k <= 8; ++k) {
                        if (JGTConstants.isNovalue(netRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0)) || mRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != (double)dirIn[k][2]) continue;
                        ++gg;
                    }
                    if (gg >= 2) {
                        nstream.add(++n);
                        oMatrixRandomIter.setSample(flow[0], flow[1], 0, n);
                    } else {
                        oMatrixRandomIter.setSample(flow[0], flow[1], 0, n);
                    }
                    if (!ModelsEngine.go_downstream(flow, mRandomIter.getSampleDouble(flow[0], flow[1], 0))) {
                        return null;
                    }
                    for (Point4d point4d : points) {
                        if (point4d.x != (double)flow[0] || point4d.y != (double)flow[1]) continue;
                        nstream.add(++n);
                        point4d.w = n - 1;
                    }
                }
            }
            pm.worked(1);
        }
        pm.done();
        return outImage;
    }

    public static WritableRaster netNumberingWithPointsAndTca(List<Integer> nstream, RandomIter mRandomIter, RandomIter netRandomIter, RandomIter tcaRandomIter, double tcaTh, int rows, int cols, List<HashMap<String, ?>> attributePoints, List<Geometry> geomVect, GridGeometry2D gridGeometry, IJGTProgressMonitor pm) throws InvalidGridGeometryException, TransformException {
        int[] flow = new int[2];
        int gg = 0;
        int n = 0;
        double tcaValue = 0.0;
        ArrayList<Point4d> points = new ArrayList<Point4d>();
        Rectangle2D regionBox = gridGeometry.getEnvelope2D().getBounds2D();
        int l = 0;
        int numGeometry = 0;
        for (Geometry pointV : geomVect) {
            for (int i = 0; i < pointV.getNumGeometries(); ++i) {
                GridCoordinates2D gridCoordinate = gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(pointV.getCoordinates()[0].x, pointV.getCoordinates()[0].y));
                Number nodoId = (Number)attributePoints.get(numGeometry).get("RETE_ID");
                if (nodoId == null) {
                    throw new ModelsIllegalargumentException("Field RETE_ID not found", "");
                }
                if (nodoId.intValue() == -1 || !regionBox.contains(new Point2D.Double(pointV.getCoordinates()[0].x, pointV.getCoordinates()[0].y))) continue;
                points.add(new Point4d((double)gridCoordinate.x, (double)gridCoordinate.y, nodoId.doubleValue(), 0.0));
                ++l;
            }
            ++numGeometry;
        }
        int p = 0;
        WritableRaster outImage = CoverageUtilities.createDoubleWritableRaster(cols, rows, null, null, null);
        WritableRandomIter oRandomIter = RandomIterFactory.createWritable((WritableRaster)outImage, null);
        for (Point4d point4d : points) {
            if (netRandomIter.getSampleDouble((int)point4d.x, (int)point4d.y, 0) == point4d.z) continue;
            for (int i = 1; i < 9; ++i) {
                int indexI = (int)point4d.x + dirIn[i][1];
                int indexJ = (int)point4d.y + dirIn[i][0];
                if (netRandomIter.getSampleDouble(indexI, indexJ, 0) != point4d.z) continue;
                point4d.x = indexI;
                point4d.y = indexJ;
            }
        }
        for (Point4d point4d : points) {
            if (netRandomIter.getSampleDouble((int)point4d.x, (int)point4d.y, 0) != point4d.z) continue;
            ++p;
        }
        pm.beginTask(msg.message("utils.numbering_stream"), rows);
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < cols; ++i) {
                flow[0] = i;
                flow[1] = j;
                if (JGTConstants.isNovalue(netRandomIter.getSampleDouble(i, j, 0)) || mRandomIter.getSampleDouble(i, j, 0) == 10.0 || oRandomIter.getSampleDouble(i, j, 0) != 0.0) continue;
                int f = 0;
                for (int k = 1; k <= 8 && (mRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != (double)dirIn[k][2] || JGTConstants.isNovalue(netRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0))); ++k) {
                    ++f;
                }
                if (f != 8) continue;
                nstream.add(++n);
                oRandomIter.setSample(i, j, 0, n);
                if (!ModelsEngine.go_downstream(flow, mRandomIter.getSampleDouble(flow[0], flow[1], 0))) {
                    return null;
                }
                for (Point4d point4d : points) {
                    if (point4d.y != (double)flow[1] || point4d.x != (double)flow[0]) continue;
                    nstream.add(++n);
                    point4d.w = n - 1;
                }
                while (!JGTConstants.isNovalue(mRandomIter.getSampleDouble(flow[0], flow[1], 0)) && oRandomIter.getSampleDouble(flow[0], flow[1], 0) == 0.0 && mRandomIter.getSampleDouble(flow[0], flow[1], 0) != 10.0) {
                    gg = 0;
                    for (int k = 1; k <= 8; ++k) {
                        if (JGTConstants.isNovalue(netRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0)) || mRandomIter.getSampleDouble(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != (double)dirIn[k][2]) continue;
                        ++gg;
                    }
                    if (gg >= 2) {
                        oRandomIter.setSample(flow[0], flow[1], 0, ++n);
                        tcaValue = tcaRandomIter.getSampleDouble(flow[0], flow[1], 0);
                    } else if (tcaRandomIter.getSampleDouble(flow[0], flow[1], 0) - tcaValue > tcaTh) {
                        nstream.add(++n);
                        oRandomIter.setSample(flow[0], flow[1], 0, n);
                        tcaValue = tcaRandomIter.getSampleDouble(flow[0], flow[1], 0);
                    } else {
                        oRandomIter.setSample(flow[0], flow[1], 0, n);
                    }
                    if (!ModelsEngine.go_downstream(flow, mRandomIter.getSampleDouble(flow[0], flow[1], 0))) {
                        return null;
                    }
                    for (Point4d point4d : points) {
                        if (point4d.y != (double)flow[1] || point4d.x != (double)flow[0]) continue;
                        nstream.add(++n);
                        point4d.w = n - 1;
                    }
                }
            }
            pm.worked(1);
        }
        pm.done();
        oRandomIter.done();
        tcaRandomIter.done();
        return outImage;
    }

    public static WritableRaster extractSubbasins(WritableRandomIter flowIter, RandomIter netRandomIter, WritableRandomIter netNumberIter, int rows, int cols, IJGTProgressMonitor pm) {
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                if (JGTConstants.isNovalue(netRandomIter.getSampleDouble(c, r, 0))) continue;
                flowIter.setSample(c, r, 0, 10);
            }
        }
        WritableRaster subbImage = ModelsEngine.go2channel((RandomIter)flowIter, (RandomIter)netNumberIter, cols, rows, pm);
        WritableRandomIter subbRandomIter = RandomIterFactory.createWritable((WritableRaster)subbImage, null);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double subbValue;
                double netValue = netRandomIter.getSampleDouble(c, r, 0);
                double netNumberValue = netNumberIter.getSampleDouble(c, r, 0);
                if (!JGTConstants.isNovalue(netValue)) {
                    subbRandomIter.setSample(c, r, 0, netNumberValue);
                }
                if (NumericsUtilities.dEq(netNumberValue, 0.0)) {
                    netNumberIter.setSample(c, r, 0, Double.NaN);
                }
                if (!NumericsUtilities.dEq(subbValue = subbRandomIter.getSampleDouble(c, r, 0), 0.0)) continue;
                subbRandomIter.setSample(c, r, 0, Double.NaN);
            }
        }
        return subbImage;
    }

    public static WritableRaster go2channel(RandomIter flowIter, RandomIter attributeIter, int cols, int rows, IJGTProgressMonitor pm) {
        int[] flowColRow = new int[2];
        double value = 0.0;
        WritableRaster dist = CoverageUtilities.createDoubleWritableRaster(cols, rows, null, null, null);
        WritableRandomIter distIter = RandomIterFactory.createWritable((WritableRaster)dist, null);
        pm.beginTask("Calculating the distance along the flowstream...", rows - 2);
        for (int r = 1; r < rows - 1; ++r) {
            for (int c = 1; c < cols - 1; ++c) {
                flowColRow[0] = c;
                flowColRow[1] = r;
                if (JGTConstants.isNovalue(flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0)) || !ModelsEngine.isSourcePixel(flowIter, flowColRow[0], flowColRow[1])) continue;
                while (!JGTConstants.isNovalue(flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0)) && flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0) != 10.0) {
                    if (ModelsEngine.go_downstream(flowColRow, flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0))) continue;
                    return null;
                }
                if (JGTConstants.isNovalue(flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0))) {
                    throw new ModelsIllegalargumentException("No proper outlets were found in the flow file", "ModelsEngine");
                }
                if (flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0) != 10.0) {
                    throw new ModelsIllegalargumentException("Undefined situation while go2channel", "ModelsEngine");
                }
                value = attributeIter.getSampleDouble(flowColRow[0], flowColRow[1], 0);
                flowColRow[0] = c;
                flowColRow[1] = r;
                distIter.setSample(c, r, 0, value);
                while (!JGTConstants.isNovalue(flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0)) && flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0) != 10.0) {
                    distIter.setSample(flowColRow[0], flowColRow[1], 0, value);
                    if (ModelsEngine.go_downstream(flowColRow, flowIter.getSampleDouble(flowColRow[0], flowColRow[1], 0))) continue;
                    return null;
                }
            }
            pm.worked(1);
        }
        pm.done();
        return dist;
    }

    public static boolean isSourcePixel(RandomIter flowIter, int col, int row) {
        double flowDirection = flowIter.getSampleDouble(col, row, 0);
        if (flowDirection < 9.0 && flowDirection > 0.0) {
            for (int k = 1; k <= 8; ++k) {
                if (flowIter.getSampleDouble(col + dirIn[k][1], row + dirIn[k][0], 0) != (double)dirIn[k][2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int getFlowDirection(int i, int j) {
        int flow = -1;
        for (int k = 1; k < 9; ++k) {
            if (ModelsSupporter.DIR[k][0] != i || ModelsSupporter.DIR[k][1] != j) continue;
            flow = k;
        }
        return flow;
    }

    public static double width_interpolate(double[][] data, double x, int nx, int ny) {
        int rows = data.length;
        double xuno = 0.0;
        double xdue = 0.0;
        double yuno = 0.0;
        double ydue = 0.0;
        double y = 0.0;
        if (x >= 0.0 && x < data[0][nx]) {
            xuno = 0.0;
            xdue = data[0][nx];
            yuno = 0.0;
            ydue = data[0][ny];
            y = (ydue - yuno) / (xdue - xuno) * (x - xuno) + yuno;
        }
        if (x > data[rows - 1][nx] || x < 0.0) {
            throw new RuntimeException(MessageFormat.format("Error in the interpolation algorithm: entering with x = {0} (min = 0.0 max = {1}", x, data[rows - 1][nx]));
        }
        for (int i = 0; i < rows - 1; ++i) {
            if (!(x > data[i][nx]) || !(x <= data[i + 1][nx])) continue;
            xuno = data[i][nx];
            xdue = data[i + 1][nx];
            yuno = data[i][ny];
            ydue = data[i + 1][ny];
            y = (ydue - yuno) / (xdue - xuno) * (x - xuno) + yuno;
        }
        return y;
    }

    public static double henderson(double[][] data, int tp) {
        int rows = data.length;
        int j = 1;
        int n = 0;
        double dt = 0.0;
        double smax = 0.0;
        for (int i = 1; i < rows; ++i) {
            if (!(data[i][0] + (double)tp <= data[rows - 1][0])) continue;
            double muno = (data[i][1] - data[i - 1][1]) / (data[i][0] - data[i - 1][0]);
            double a = data[i][1] - (data[i][0] + (double)tp) * muno;
            for (j = 1; j <= rows - 1; ++j) {
                double mdue = (data[j][1] - data[j - 1][1]) / (data[j][0] - data[j - 1][0]);
                double b = data[j][1] - data[j][0] * mdue;
                double x = (a - b) / (mdue - muno);
                double y = muno * x + a;
                if (!(x >= data[j - 1][0]) || !(x <= data[j][0]) || !(x - (double)tp >= data[i - 1][0]) || !(x - (double)tp <= data[i][0])) continue;
                double ydue = ModelsEngine.width_interpolate(data, x - (double)tp, 0, 1);
                ++n;
                double s_uno = ModelsEngine.width_interpolate(data, x - (double)tp, 0, 2);
                double s_due = ModelsEngine.width_interpolate(data, x, 0, 2);
                if (!(s_due - s_uno > smax)) continue;
                smax = s_due - s_uno;
                dt = x - (double)tp;
                double d = x;
            }
        }
        return dt;
    }

    public static double gamma(double x) {
        double tmp = (x - 0.5) * Math.log(x + 4.5) - (x + 4.5);
        double ser = 1.0 + 76.18009173 / (x + 0.0) - 86.50532033 / (x + 1.0) + 24.01409822 / (x + 2.0) - 1.231739516 / (x + 3.0) + 0.00120858003 / (x + 4.0) - 5.36382E-6 / (x + 5.0);
        double gamma = Math.exp(tmp + Math.log(ser * Math.sqrt(Math.PI * 2)));
        return gamma;
    }

    public static WritableRaster sumDownstream(RandomIter flowIter, RandomIter mapToSumIter, int width, int height, Double upperThreshold, Double lowerThreshold, IJGTProgressMonitor pm) {
        int[] point = new int[2];
        WritableRaster summedMapWR = CoverageUtilities.createDoubleWritableRaster(width, height, null, null, null);
        WritableRandomIter summedMapIter = RandomIterFactory.createWritable((WritableRaster)summedMapWR, null);
        double uThres = Double.POSITIVE_INFINITY;
        if (upperThreshold != null) {
            uThres = upperThreshold;
        }
        double lThres = Double.NEGATIVE_INFINITY;
        if (lowerThreshold != null) {
            lThres = lowerThreshold;
        }
        pm.beginTask("Calculating downstream sum...", height);
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                double mapToSumValue = mapToSumIter.getSampleDouble(c, r, 0);
                if (!JGTConstants.isNovalue(flowIter.getSampleDouble(c, r, 0)) && mapToSumValue < uThres && mapToSumValue > lThres) {
                    double sumValue;
                    point[0] = c;
                    point[1] = r;
                    while (flowIter.getSampleDouble(point[0], point[1], 0) < 9.0 && !JGTConstants.isNovalue(flowIter.getSampleDouble(point[0], point[1], 0)) && ModelsEngine.checkRange(mapToSumIter.getSampleDouble(point[0], point[1], 0), uThres, lThres)) {
                        sumValue = summedMapIter.getSampleDouble(point[0], point[1], 0) + mapToSumIter.getSampleDouble(c, r, 0);
                        summedMapIter.setSample(point[0], point[1], 0, sumValue);
                        if (ModelsEngine.go_downstream(point, flowIter.getSampleDouble(point[0], point[1], 0))) continue;
                        return null;
                    }
                    sumValue = summedMapIter.getSampleDouble(point[0], point[1], 0) + mapToSumIter.getSampleDouble(c, r, 0);
                    summedMapIter.setSample(point[0], point[1], 0, sumValue);
                    continue;
                }
                summedMapIter.setSample(c, r, 0, Double.NaN);
            }
            pm.worked(1);
        }
        pm.done();
        return summedMapWR;
    }

    private static boolean checkRange(double value, double upper, double lower) {
        return value < upper && value > lower;
    }

    public static boolean tcaMax(RandomIter flowIterator, RandomIter tcaIterator, RandomIter dist, int[] flow, double maz, double diss) {
        for (int k = 1; k <= 8; ++k) {
            if (flowIterator.getSample(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) != dirIn[k][2] || !((double)tcaIterator.getSample(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) >= maz)) continue;
            if ((double)tcaIterator.getSample(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) == maz) {
                if (!((double)dist.getSample(flow[0] + dirIn[k][1], flow[1] + dirIn[k][0], 0) > diss)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static double[] calcInverseSunVector(double[] sunVector) {
        double m = Math.max(Math.abs(sunVector[0]), Math.abs(sunVector[1]));
        return new double[]{-sunVector[0] / m, -sunVector[1] / m, -sunVector[2] / m};
    }

    public static double[] calcNormalSunVector(double[] sunVector) {
        double[] normalSunVector = new double[3];
        normalSunVector[2] = Math.sqrt(Math.pow(sunVector[0], 2.0) + Math.pow(sunVector[1], 2.0));
        normalSunVector[0] = -sunVector[0] * sunVector[2] / normalSunVector[2];
        normalSunVector[1] = -sunVector[1] * sunVector[2] / normalSunVector[2];
        return normalSunVector;
    }

    public static double scalarProduct(double[] a, double[] b) {
        double c = 0.0;
        for (int i = 0; i < a.length; ++i) {
            c += a[i] * b[i];
        }
        return c;
    }

    public static WritableRaster calculateFactor(int h, int w, double[] sunVector, double[] inverseSunVector, double[] normalSunVector, WritableRaster demWR, double dx) {
        int i;
        double casx = 1000000.0 * sunVector[0];
        double casy = 1000000.0 * sunVector[1];
        int f_i = 0;
        int f_j = 0;
        f_i = casx <= 0.0 ? 0 : w - 1;
        f_j = casy <= 0.0 ? 0 : h - 1;
        WritableRaster sOmbraWR = CoverageUtilities.createDoubleWritableRaster(w, h, null, null, 1.0);
        int j = f_j;
        for (i = 0; i < sOmbraWR.getWidth(); ++i) {
            ModelsEngine.shadow(i, j, sOmbraWR, demWR, dx, normalSunVector, inverseSunVector);
        }
        i = f_i;
        for (int k = 0; k < sOmbraWR.getHeight(); ++k) {
            ModelsEngine.shadow(i, k, sOmbraWR, demWR, dx, normalSunVector, inverseSunVector);
        }
        return sOmbraWR;
    }

    private static WritableRaster shadow(int i, int j, WritableRaster tmpWR, WritableRaster demWR, double res, double[] normalSunVector, double[] inverseSunVector) {
        int n = 0;
        double zcompare = -1.7976931348623157E308;
        double dx = inverseSunVector[0] * (double)n;
        double dy = inverseSunVector[1] * (double)n;
        int nCols = tmpWR.getWidth();
        int nRows = tmpWR.getHeight();
        int idx = (int)Math.round((double)i + dx);
        int jdy = (int)Math.round((double)j + dy);
        double[] vectorToOrigin = new double[3];
        while (idx >= 0 && idx <= nCols - 1 && jdy >= 0 && jdy <= nRows - 1) {
            vectorToOrigin[0] = dx * res;
            vectorToOrigin[1] = dy * res;
            int tmpY = (int)((double)j + dy);
            if (tmpY < 0) {
                tmpY = 0;
            } else if (tmpY > nRows) {
                tmpY = nRows - 1;
            }
            int tmpX = (int)((double)i + dx);
            if (tmpX < 0) {
                tmpX = 0;
            } else if (tmpY > nCols) {
                tmpX = nCols - 1;
            }
            vectorToOrigin[2] = demWR.getSampleDouble(idx, jdy, 0);
            double zprojection = ModelsEngine.scalarProduct(vectorToOrigin, normalSunVector);
            if (zprojection < zcompare) {
                tmpWR.setSample(idx, jdy, 0, 0);
            } else {
                zcompare = zprojection;
            }
            dy = inverseSunVector[1] * (double)(++n);
            dx = inverseSunVector[0] * (double)n;
            idx = (int)Math.round((double)i + dx);
            jdy = (int)Math.round((double)j + dy);
        }
        return tmpWR;
    }

    public static boolean verifyDoubleStation(double[] xStation, double[] yStation, double[] zStation, double[] hStation, double xTmp, double yTmp, double zTmp, double hTmp, int i, boolean doMean, IJGTProgressMonitor pm) throws Exception {
        for (int j = 0; j < i - 1; ++j) {
            if (NumericsUtilities.dEq(xTmp, xStation[j]) && NumericsUtilities.dEq(yTmp, yStation[j]) && NumericsUtilities.dEq(zTmp, zStation[j]) && NumericsUtilities.dEq(hTmp, hStation[j])) {
                if (!doMean) {
                    throw new IllegalArgumentException(msg.message("verifyStation.equalsStation1") + xTmp + "/" + yTmp);
                }
                return true;
            }
            if (!NumericsUtilities.dEq(xTmp, xStation[j]) || !NumericsUtilities.dEq(yTmp, yStation[j]) || !NumericsUtilities.dEq(zTmp, zStation[j])) continue;
            if (!doMean) {
                throw new IllegalArgumentException(msg.message("verifyStation.equalsStation2") + xTmp + "/" + yTmp);
            }
            hStation[j] = !JGTConstants.isNovalue(hStation[j]) && !JGTConstants.isNovalue(hTmp) ? (hStation[j] + hTmp) / 2.0 : Double.NaN;
            return true;
        }
        return false;
    }

    public static double meanDoublematrixColumn(double[][] matrix, int column) {
        double mean = 0.0;
        int length = matrix.length;
        for (int i = 0; i < length; ++i) {
            mean += matrix[i][column];
        }
        return mean / (double)length;
    }

    public static double varianceDoublematrixColumn(double[][] matrix, int column, double mean) {
        double variance = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            variance += (matrix[i][column] - mean) * (matrix[i][column] - mean);
        }
        return variance / (double)matrix.length;
    }

    public static double sumDoublematrixColumns(int coolIndex, double[][] matrixToSum, double[][] resultMatrix, int firstRowIndex, int lastRowIndex, IJGTProgressMonitor pm) {
        double maximum = 0.0;
        if (matrixToSum.length != resultMatrix.length) {
            pm.errorMessage(msg.message("trentoP.error.matrix"));
            throw new ArithmeticException(msg.message("trentoP.error.matrix"));
        }
        if (firstRowIndex < 0 || lastRowIndex < firstRowIndex) {
            pm.errorMessage(msg.message("trentoP.error.nCol"));
            throw new ArithmeticException(msg.message("trentoP.error.nCol"));
        }
        for (int i = 0; i < matrixToSum.length; ++i) {
            resultMatrix[i][coolIndex] = 0.0;
            for (int j = firstRowIndex; j <= lastRowIndex; ++j) {
                double[] dArray = resultMatrix[i];
                int n = coolIndex;
                dArray[n] = dArray[n] + matrixToSum[i][j];
            }
            if (!(resultMatrix[i][coolIndex] >= maximum)) continue;
            maximum = resultMatrix[i][coolIndex];
        }
        return maximum;
    }

    public static void topologicalOutletdistance(RandomIter flowIter, RandomIter pitIter, WritableRandomIter h2cdIter, RegionMap region, IJGTProgressMonitor pm) {
        int activeCols = region.getCols();
        int activeRows = region.getRows();
        double dx = region.getXres();
        double dy = region.getYres();
        int[] flow = new int[2];
        int[] flow_p = new int[2];
        double oldir = 0.0;
        double[] grid = new double[11];
        double count = 0.0;
        grid[10] = 0.0;
        grid[9] = 0.0;
        grid[0] = 0.0;
        grid[1] = grid[5] = Math.abs(dx);
        grid[3] = grid[7] = Math.abs(dy);
        grid[6] = grid[8] = Math.sqrt(dx * dx + dy * dy);
        grid[4] = grid[8];
        grid[2] = grid[8];
        pm.beginTask("Calculating topological outlet distance...", activeRows);
        for (int r = 0; r < activeRows; ++r) {
            for (int c = 0; c < activeCols; ++c) {
                double dz;
                flow[0] = c;
                flow[1] = r;
                if (JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0))) {
                    h2cdIter.setSample(flow[0], flow[1], 0, Double.NaN);
                    continue;
                }
                if (!ModelsEngine.isSourcePixel(flowIter, flow[0], flow[1])) continue;
                count = 0.0;
                oldir = flowIter.getSampleDouble(flow[0], flow[1], 0);
                flow_p[0] = flow[0];
                flow_p[1] = flow[1];
                ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0));
                while (!JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0)) && !JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0)) && flowIter.getSampleDouble(flow[0], flow[1], 0) != 10.0 && h2cdIter.getSampleDouble(flow[0], flow[1], 0) <= 0.0) {
                    if (pitIter != null) {
                        dz = pitIter.getSampleDouble(flow_p[0], flow_p[1], 0) - pitIter.getSampleDouble(flow[0], flow[1], 0);
                        count += Math.sqrt(Math.pow(grid[(int)oldir], 2.0) + Math.pow(dz, 2.0));
                    } else {
                        count += grid[(int)oldir];
                    }
                    oldir = flowIter.getSampleDouble(flow[0], flow[1], 0);
                    flow_p[0] = flow[0];
                    flow_p[1] = flow[1];
                    ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0));
                }
                if (h2cdIter.getSampleDouble(flow[0], flow[1], 0) > 0.0) {
                    if (pitIter != null) {
                        dz = pitIter.getSampleDouble(flow_p[0], flow_p[1], 0) - pitIter.getSampleDouble(flow[0], flow[1], 0);
                        count += Math.sqrt(Math.pow(grid[(int)oldir], 2.0) + Math.pow(dz, 2.0)) + h2cdIter.getSampleDouble(flow[0], flow[1], 0);
                    } else {
                        count += grid[(int)oldir] + h2cdIter.getSampleDouble(flow[0], flow[1], 0);
                    }
                    h2cdIter.setSample(c, r, 0, count);
                } else if (flowIter.getSampleDouble(flow[0], flow[1], 0) > 9.0) {
                    h2cdIter.setSample(flow[0], flow[1], 0, 0);
                    if (pitIter != null) {
                        dz = pitIter.getSampleDouble(flow_p[0], flow_p[1], 0) - pitIter.getSampleDouble(flow[0], flow[1], 0);
                        count += Math.sqrt(Math.pow(grid[(int)oldir], 2.0) + Math.pow(dz, 2.0));
                    } else {
                        count += grid[(int)oldir];
                    }
                    h2cdIter.setSample(c, r, 0, count);
                }
                flow[0] = c;
                flow[1] = r;
                oldir = flowIter.getSampleDouble(flow[0], flow[1], 0);
                flow_p[0] = flow[0];
                flow_p[1] = flow[1];
                ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0));
                while (!JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0)) && !JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0)) && flowIter.getSampleDouble(flow[0], flow[1], 0) != 10.0 && h2cdIter.getSampleDouble(flow[0], flow[1], 0) <= 0.0) {
                    if (pitIter != null) {
                        dz = pitIter.getSampleDouble(flow_p[0], flow_p[1], 0) - pitIter.getSampleDouble(flow[0], flow[1], 0);
                        count -= Math.sqrt(Math.pow(grid[(int)oldir], 2.0) + Math.pow(dz, 2.0));
                    } else {
                        count -= grid[(int)oldir];
                    }
                    if (count < 0.0) {
                        h2cdIter.setSample(flow[0], flow[1], 0, 0);
                    } else {
                        h2cdIter.setSample(flow[0], flow[1], 0, count);
                    }
                    oldir = flowIter.getSampleDouble(flow[0], flow[1], 0);
                    flow_p[0] = flow[0];
                    flow_p[1] = flow[1];
                    ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0));
                }
            }
            pm.worked(1);
        }
        pm.done();
    }

    public static void outletdistance(RandomIter flowIter, WritableRandomIter h2cdIter, RegionMap region, IJGTProgressMonitor pm) {
        int cols = region.getCols();
        int rows = region.getRows();
        int[] flow = new int[2];
        double count = 0.0;
        pm.beginTask("Calculating outlet distance...", rows);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                flow[0] = c;
                flow[1] = r;
                if (JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0))) {
                    h2cdIter.setSample(flow[0], flow[1], 0, Double.NaN);
                    continue;
                }
                flow[0] = c;
                flow[1] = r;
                if (!ModelsEngine.isSourcePixel(flowIter, flow[0], flow[1])) continue;
                count = 0.0;
                ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0));
                while (!JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0)) && flowIter.getSampleDouble(flow[0], flow[1], 0) != 10.0 && h2cdIter.getSampleDouble(flow[0], flow[1], 0) <= 0.0) {
                    count += 1.0;
                    ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0));
                }
                if (h2cdIter.getSampleDouble(flow[0], flow[1], 0) > 0.0) {
                    h2cdIter.setSample(c, r, 0, count += 1.0 + h2cdIter.getSampleDouble(flow[0], flow[1], 0));
                } else if (flowIter.getSampleDouble(flow[0], flow[1], 0) > 9.0) {
                    h2cdIter.setSample(flow[0], flow[1], 0, 0);
                    h2cdIter.setSample(c, r, 0, count += 1.0);
                }
                flow[0] = c;
                flow[1] = r;
                ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0));
                while (!JGTConstants.isNovalue(flowIter.getSampleDouble(flow[0], flow[1], 0)) && flowIter.getSampleDouble(flow[0], flow[1], 0) != 10.0 && h2cdIter.getSampleDouble(flow[0], flow[1], 0) <= 0.0) {
                    h2cdIter.setSample(flow[0], flow[1], 0, count -= 1.0);
                    ModelsEngine.go_downstream(flow, flowIter.getSampleDouble(flow[0], flow[1], 0));
                }
            }
            pm.worked(1);
        }
        pm.done();
    }

    public static double approximate2Multiple(double valueToApproximate, double divisor) {
        return valueToApproximate - Math.abs(valueToApproximate % divisor);
    }
}

