/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.vectorwriter;

import java.io.File;
import java.io.IOException;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.jgrasstools.gears.io.shapefile.ShapefileFeatureWriter;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;

@Description(value="Vectors features writer to file module.")
@Documentation(value="VectorWriter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Writing")
@Label(value="Vector Writer")
@Name(value="vectorwriter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorWriter
extends JGTModel {
    @Description(value="The read feature collection.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The vector type to write (Supported is: shp).")
    @In
    public String pType = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The vector file to write.")
    @UI(value="infile")
    @In
    public String file = null;

    @Execute
    public void process() throws IOException {
        this.checkNull(this.file);
        File vectorFile = new File(this.file);
        if (this.inVector.size() == 0) {
            this.pm.message("Warning, not writing an empty vector to file: " + vectorFile.getName());
            return;
        }
        String name = vectorFile.getName();
        if (!name.toLowerCase().endsWith("shp") && !this.pType.equals("shp")) {
            throw new IOException("Format is currently not supported for file: " + name);
        }
        ShapefileFeatureWriter.writeShapefile(vectorFile.getAbsolutePath(), this.inVector);
    }

    public static void writeVector(String path, SimpleFeatureCollection featureCollection) throws IOException {
        VectorWriter writer = new VectorWriter();
        writer.file = path;
        writer.inVector = featureCollection;
        writer.process();
    }
}

