/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.vectorreader;

import java.io.File;
import java.io.IOException;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.jgrasstools.gears.io.shapefile.ShapefileFeatureReader;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;

@Description(value="Vectors features reader module.")
@Documentation(value="VectorReader.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Reading")
@Label(value="Vector Reader")
@Name(value="vectorreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorReader
extends JGTModel {
    @Description(value="The vector type to read (Supported is: shp).")
    @In
    public String pType = null;
    @Description(value="The vector file to read.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The read feature collection.")
    @Out
    public SimpleFeatureCollection outVector = null;

    @Execute
    public void process() throws IOException {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.file);
        File vectorFile = new File(this.file);
        String name = vectorFile.getName();
        if (!name.toLowerCase().endsWith("shp")) {
            throw new IOException("Format is currently not supported for file: " + name);
        }
        this.outVector = ShapefileFeatureReader.readShapefile(vectorFile.getAbsolutePath());
    }

    public static SimpleFeatureCollection readVector(String path) throws IOException {
        VectorReader reader = new VectorReader();
        reader.file = path;
        reader.process();
        return reader.outVector;
    }
}

