/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.timedependent;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Initialize;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.io.TableIterator;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

@Description(value="Utility class for reading data from a OMS formatted csv file. The file needs a metadata line containing the id of the station. The table is supposed to have a first column of timestamp and all olther columns of data related to the ids defined.")
@Documentation(value="TimeSeriesIteratorReader.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="HashMap Data Reader")
@Name(value="tsitreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class TimeSeriesIteratorReader
extends JGTModel {
    @Description(value="The csv file to read from.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The id metadata field.")
    @In
    public String idfield = "ID";
    @Description(value="The file novalue to be translated into the internal novalue. Can be a string also")
    @In
    public String fileNovalue = "-9999.0";
    @Description(value="The internal novalue to use (usually not changed).")
    @In
    public double novalue = Double.NaN;
    @Description(value="The number of rows to aggregate (default is 1, i.e. no aggregation).")
    @In
    public int pNum = 1;
    @Description(value="The aggregation type to use (0 = sum, 1 = avg).")
    @In
    public int pAggregation = 0;
    @Description(value="The time at which start to read (format: yyyy-MM-dd HH:mm ).")
    @In
    @Out
    public String tStart;
    @Description(value="The time at which end to read (format: yyyy-MM-dd HH:mm ).")
    @In
    @Out
    public String tEnd;
    @Description(value="The reading timestep in minutes.")
    @In
    @Out
    public int tTimestep;
    @Description(value="The current time read (format: yyyy-MM-dd HH:mm ).")
    @Out
    public String tCurrent;
    @Description(value="The previous time read (format: yyyy-MM-dd HH:mm ).")
    @Out
    public String tPrevious;
    @Description(value="The read map of ids and values.")
    @Out
    public HashMap<Integer, double[]> outData;
    private TableIterator<String[]> rowsIterator;
    private CSTable table;
    private DateTimeFormatter formatter = JGTConstants.utcDateFormatterYYYYMMDDHHMM;
    private DateTime expectedTimestamp = null;

    @Initialize
    public void initProcess() {
        this.doProcess = true;
    }

    private void ensureOpen() throws IOException {
        if (this.table == null) {
            this.table = DataIO.table((File)new File(this.file), null);
            this.rowsIterator = (TableIterator)this.table.rows().iterator();
            if (this.tStart == null) {
                String[] row;
                String secondTime = null;
                if (this.rowsIterator.hasNext()) {
                    row = (String[])this.rowsIterator.next();
                    this.tStart = row[1];
                }
                if (this.rowsIterator.hasNext()) {
                    row = (String[])this.rowsIterator.next();
                    secondTime = row[1];
                }
                this.tTimestep = this.formatter.parseDateTime(secondTime).getMinuteOfDay() - this.formatter.parseDateTime(this.tStart).getMinuteOfDay();
                this.rowsIterator.close();
                this.rowsIterator = (TableIterator)this.table.rows().iterator();
            }
        }
    }

    @Execute
    public void nextRecord() throws IOException {
        this.ensureOpen();
        if (this.tCurrent == null) {
            this.tPrevious = null;
            this.tCurrent = this.tStart.trim();
            this.expectedTimestamp = this.formatter.parseDateTime(this.tCurrent);
        } else {
            this.tPrevious = this.tCurrent;
            this.expectedTimestamp = this.expectedTimestamp.plusMinutes(this.tTimestep);
            this.tCurrent = this.expectedTimestamp.toString(this.formatter);
        }
        this.outData = new HashMap();
        int columnCount = this.table.getColumnCount();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        ArrayList<Integer> idCountList = new ArrayList<Integer>();
        int count = 0;
        Integer previousIdInteger = null;
        for (int i = 2; i <= columnCount; ++i) {
            String id = (String)this.table.getColumnInfo(i).get(this.idfield);
            try {
                Integer idInteger = Integer.valueOf(id);
                idList.add(idInteger);
                if (previousIdInteger == null) {
                    ++count;
                } else if (idInteger.intValue() == previousIdInteger.intValue()) {
                    ++count;
                } else {
                    idCountList.add(count);
                    count = 1;
                }
                if (i == columnCount) {
                    idCountList.add(count);
                }
                previousIdInteger = idInteger;
                continue;
            }
            catch (Exception e) {
                throw new ModelsIllegalargumentException("The id value doesn't seem to be an integer.", this.getClass().getSimpleName());
            }
        }
        if (this.rowsIterator.hasNext()) {
            String[] row = this.getExpectedRow(this.rowsIterator, this.expectedTimestamp);
            int idCountIndex = 0;
            for (int i = 2; i < row.length; ++i) {
                Integer id = (Integer)idList.get(i - 2);
                Integer idCount = (Integer)idCountList.get(idCountIndex);
                double[] values = this.outData.get(id);
                if (values == null) {
                    values = new double[idCount.intValue()];
                    this.outData.put(id, values);
                }
                int j = 0;
                while (j < idCount) {
                    String valueStr;
                    values[j] = row[i] == null || row[i].length() == 0 ? this.novalue : ((valueStr = row[i].trim()).equals(this.fileNovalue) ? this.novalue : Double.parseDouble(valueStr));
                    ++j;
                    ++i;
                }
                ++idCountIndex;
                --i;
            }
        } else {
            this.outData = null;
        }
        if (this.tEnd != null && this.tCurrent.equals(this.tEnd)) {
            this.doProcess = false;
        }
        if (!this.rowsIterator.hasNext()) {
            this.doProcess = false;
        }
    }

    private String[] getExpectedRow(TableIterator<String[]> tableRowIterator, DateTime expectedDT) throws IOException {
        while (tableRowIterator.hasNext()) {
            String[] row = (String[])tableRowIterator.next();
            DateTime currentTimestamp = this.formatter.parseDateTime(row[1]);
            if (currentTimestamp.equals((Object)expectedDT)) {
                if (this.pNum == 1) {
                    return row;
                }
                String[][] allRows = new String[this.pNum][];
                allRows[0] = row;
                int rowNum = 1;
                for (int i = 1; i < this.pNum; ++i) {
                    String[] nextRow;
                    if (!tableRowIterator.hasNext()) continue;
                    allRows[i] = nextRow = (String[])tableRowIterator.next();
                    ++rowNum;
                }
                String[] aggregatedRow = new String[row.length];
                aggregatedRow[0] = allRows[0][0];
                aggregatedRow[1] = allRows[0][1];
                block6: for (int col = 2; col < allRows[0].length; ++col) {
                    boolean hasOne = false;
                    switch (this.pAggregation) {
                        case 0: {
                            double sum = 0.0;
                            for (int j = 0; j < rowNum; ++j) {
                                String valueStr = allRows[j][col];
                                if (valueStr.equals(this.fileNovalue)) continue;
                                double value = Double.parseDouble(valueStr);
                                sum += value;
                                hasOne = true;
                            }
                            if (!hasOne) {
                                sum = Double.NaN;
                            }
                            aggregatedRow[col] = String.valueOf(sum);
                            continue block6;
                        }
                        case 1: {
                            double avg = 0.0;
                            for (int j = 0; j < rowNum; ++j) {
                                String valueStr = allRows[j][col];
                                if (valueStr.equals(this.fileNovalue)) continue;
                                double value = Double.parseDouble(valueStr);
                                avg += value;
                                hasOne = true;
                            }
                            avg = !hasOne ? Double.NaN : (avg /= (double)this.pNum);
                            aggregatedRow[col] = String.valueOf(avg);
                            continue block6;
                        }
                    }
                }
                return aggregatedRow;
            }
            if (currentTimestamp.isBefore((ReadableInstant)expectedDT) || !currentTimestamp.isAfter((ReadableInstant)expectedDT)) continue;
            throw new IOException("The data are not aligned with the simulation interval. Check your data file: " + this.file);
        }
        return null;
    }

    @Finalize
    public void close() throws IOException {
        this.rowsIterator.close();
    }
}

