/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.shapefile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Utility class for writing geotools featurecollections to shapefile.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Writing")
@Label(value="Vector Writer")
@Status(value=40)
@UI(value="hide")
@License(value="General Public License Version 3 (GPLv3)")
public class ShapefileFeatureWriter
extends JGTModel {
    @Description(value="The feature type. It's mandatory only if you want to write down an empty FeatureCollection")
    @In
    public SimpleFeatureType pType = null;
    @Description(value="The feature collection to write.")
    @In
    public SimpleFeatureCollection geodata = null;
    @Description(value="The shapefile to which to write to.")
    @UI(value="outfile")
    @In
    public String file = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    private boolean hasWritten = false;

    @Execute
    public void writeFeatureCollection() throws IOException {
        if (!this.concatOr(!this.hasWritten, this.doReset)) {
            return;
        }
        this.pm.beginTask("Writing features to shapefile...", -1);
        if (!this.file.endsWith(".shp")) {
            this.file = this.file + ".shp";
        }
        File shapeFile = new File(this.file);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put("url", shapeFile.toURI().toURL());
        if (this.geodata != null && this.geodata.size() != 0) {
            this.pType = (SimpleFeatureType)this.geodata.getSchema();
        }
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(this.pType);
        newDataStore.forceSchemaCRS(this.pType.getCoordinateReferenceSystem());
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        SimpleFeatureStore featureStore = (SimpleFeatureStore)newDataStore.getFeatureSource(typeName);
        featureStore.setTransaction((Transaction)transaction);
        try {
            if (this.geodata == null) {
                featureStore.addFeatures((FeatureCollection)FeatureCollections.newCollection());
            } else {
                featureStore.addFeatures((FeatureCollection)this.geodata);
            }
            transaction.commit();
        }
        catch (Exception problem) {
            transaction.rollback();
            throw new IOException(problem.getLocalizedMessage());
        }
        finally {
            transaction.close();
            this.pm.done();
        }
        this.hasWritten = true;
    }

    public static void writeShapefile(String path, SimpleFeatureCollection featureCollection) throws IOException {
        ShapefileFeatureWriter writer = new ShapefileFeatureWriter();
        writer.file = path;
        writer.geodata = featureCollection;
        writer.writeFeatureCollection();
    }

    public static void writeEmptyShapefile(String path, SimpleFeatureType schema) throws IOException {
        ShapefileFeatureWriter writer = new ShapefileFeatureWriter();
        writer.file = path;
        writer.pType = schema;
        writer.writeFeatureCollection();
    }
}

