/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.shapefile;

import java.io.File;
import java.io.IOException;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;

@Description(value="Utility class for reading shapefiles to geotools featurecollections.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Reading")
@Label(value="Vector Reader")
@Status(value=40)
@UI(value="hide")
@License(value="General Public License Version 3 (GPLv3)")
public class ShapefileFeatureReader
extends JGTModel {
    @Description(value="The shapefile.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The read feature collection.")
    @Out
    public SimpleFeatureCollection geodata = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void readFeatureCollection() throws IOException {
        if (!this.concatOr(this.geodata == null, this.doReset)) {
            return;
        }
        try {
            File shapeFile = new File(this.file);
            this.pm.beginTask("Reading features from shapefile: " + shapeFile.getName(), -1);
            IndexedShapefileDataStore store = new IndexedShapefileDataStore(shapeFile.toURI().toURL());
            SimpleFeatureSource featureSource = store.getFeatureSource();
            this.geodata = featureSource.getFeatures();
        }
        finally {
            this.pm.done();
        }
    }

    public static SimpleFeatureCollection readShapefile(String path) throws IOException {
        ShapefileFeatureReader reader = new ShapefileFeatureReader();
        reader.file = path;
        reader.readFeatureCollection();
        return reader.geodata;
    }
}

