/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy.modules;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jgrasstools.gears.io.grasslegacy.GrassLegacyWriter;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;
import org.jgrasstools.gears.io.rasterreader.RasterReader;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module for GRASS raster patching.")
@Documentation(value="GrassMosaicLegacy.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Mosaic, Raster")
@Name(value="grassmosaic")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class GrassMosaicLegacy
extends JGTModel {
    @Description(value="The list of files that have to be patched (used if inGeodata is null).")
    @In
    public List<File> inFiles;
    @Description(value="The output file resolution in meters.")
    @In
    public Double pRes = null;
    @Description(value="The optional requested boundary coordinates as array of [n, s, w, e].")
    @In
    public double[] pBounds = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The GRASS file path to which to write to.")
    @UI(value="outfile")
    @In
    public String outGrassFile = null;
    private Envelope2D requestedEnvelope;

    @Execute
    public void process() throws Exception {
        if (this.inFiles == null) {
            throw new ModelsIllegalargumentException("No input data have been provided.", this);
        }
        if (this.pRes == null) {
            throw new ModelsIllegalargumentException("The definition of the output resolution is mandatory.", this);
        }
        if (this.inFiles != null && this.inFiles.size() < 2) {
            throw new ModelsIllegalargumentException("The patching module needs at least two maps to be patched.", this);
        }
        if (this.pBounds != null) {
            DirectPosition2D first = new DirectPosition2D(this.pBounds[2], this.pBounds[1]);
            DirectPosition2D second = new DirectPosition2D(this.pBounds[3], this.pBounds[0]);
            this.requestedEnvelope = new Envelope2D(first, second);
        }
        double n = Double.MIN_VALUE;
        double s = Double.MAX_VALUE;
        double e = Double.MIN_VALUE;
        double w = Double.MAX_VALUE;
        CoordinateReferenceSystem crs = null;
        this.pm.beginTask("Calculating final bounds...", this.inFiles.size());
        for (File coverageFile : this.inFiles) {
            RasterReader reader = new RasterReader();
            reader.file = coverageFile.getAbsolutePath();
            reader.doEnvelope = true;
            reader.process();
            GeneralEnvelope gEnv = reader.originalEnvelope;
            ReferencedEnvelope worldEnv = new ReferencedEnvelope((Envelope)gEnv);
            if (crs == null) {
                crs = gEnv.getCoordinateReferenceSystem();
            }
            if (this.requestedEnvelope != null && !this.requestedEnvelope.intersects(gEnv.toRectangle2D())) {
                this.pm.worked(1);
                continue;
            }
            double minWX = worldEnv.getMinX();
            double minWY = worldEnv.getMinY();
            double maxWX = worldEnv.getMaxX();
            double maxWY = worldEnv.getMaxY();
            if (minWX < w) {
                w = minWX;
            }
            if (minWY < s) {
                s = minWY;
            }
            if (maxWX > e) {
                e = maxWX;
            }
            if (maxWY > n) {
                n = maxWY;
            }
            this.pm.worked(1);
        }
        this.pm.done();
        Window writeWindow = new Window(w, e, s, n, this.pRes, this.pRes);
        GridGeometry2D writeGridGeometry = CoverageUtilities.gridGeometryFromRegionValues(n, s, e, w, writeWindow.getCols(), writeWindow.getRows(), crs);
        int rows = writeWindow.getRows();
        int cols = writeWindow.getCols();
        long megabytes = (long)rows * (long)cols * 8L / 1024L / 1024L;
        this.pm.message("Will allocate " + (long)rows * (long)cols + " cells, equal to about " + megabytes);
        double[][] outputData = new double[rows][cols];
        for (int i = 0; i < outputData.length; ++i) {
            for (int j = 0; j < outputData[0].length; ++j) {
                outputData[i][j] = Double.NaN;
            }
        }
        this.pm.message("Memory allocated.");
        int index = 1;
        for (File coverageFile : this.inFiles) {
            GridCoverage2D coverage = RasterReader.readRaster(coverageFile.getAbsolutePath());
            Envelope2D env = coverage.getEnvelope2D();
            GridGeometry2D gridGeometry = coverage.getGridGeometry();
            if (this.requestedEnvelope != null && !this.requestedEnvelope.intersects((Rectangle2D)env)) continue;
            double[] value = new double[1];
            GridEnvelope2D gridRange2D = gridGeometry.getGridRange2D();
            int grX = gridRange2D.x;
            int grY = gridRange2D.y;
            int grW = gridRange2D.width;
            int grH = gridRange2D.height;
            int grXEnd = grX + grW;
            int grYEnd = grY + grH;
            this.pm.beginTask("Patch map " + index++, grW);
            for (int i = grX; i < grXEnd; ++i) {
                for (int j = grY; j < grYEnd; ++j) {
                    GridCoordinates2D gCoord = new GridCoordinates2D(i, j);
                    coverage.evaluate(gCoord, value);
                    DirectPosition directPosition = gridGeometry.gridToWorld(gCoord);
                    GridCoordinates2D gridCoord = writeGridGeometry.worldToGrid(directPosition);
                    if (Double.isNaN(value[0]) || !Double.isNaN(outputData[gridCoord.y][gridCoord.x])) continue;
                    outputData[gridCoord.y][gridCoord.x] = value[0];
                }
                this.pm.worked(1);
            }
            this.pm.done();
        }
        this.pm.message("Writing mosaic map.");
        GrassLegacyWriter writer = new GrassLegacyWriter();
        writer.geodata = outputData;
        writer.file = this.outGrassFile;
        writer.inWindow = writeWindow;
        writer.pm = this.pm;
        writer.writeRaster();
    }
}

