/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy.map;

import java.io.File;
import java.io.IOException;
import org.jgrasstools.gears.io.grasslegacy.io.MapIOFactory;
import org.jgrasstools.gears.io.grasslegacy.io.MapReader;
import org.jgrasstools.gears.io.grasslegacy.map.JGrassRasterData;
import org.jgrasstools.gears.io.grasslegacy.map.RasterData;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;

public class JGrassRasterMapReader {
    private MapReader reader = null;
    private IJGTProgressMonitor monitor = null;
    private String mapName = null;
    private String mapsetName = null;
    private String locationPath = null;
    private boolean hasMoreData = false;
    private String mapPath;
    private String fullMapPath = null;

    private JGrassRasterMapReader(BuilderFromPathAndNames builder) {
        this.monitor = builder.monitor;
        this.mapName = builder.mapName;
        this.mapsetName = builder.mapsetName;
        this.locationPath = builder.locationPath;
        this.reader = MapIOFactory.createGrassRasterMapReader(builder.maptype);
        this.reader.setParameter("novalue", new Double(builder.novalue));
        this.reader.setDataWindow(builder.readWindow);
        this.reader.setOutputDataObject(new double[0][0]);
        this.fullMapPath = this.locationPath + File.separator + this.mapsetName + File.separator + "cell" + File.separator + this.mapName;
    }

    private JGrassRasterMapReader(BuilderFromMapPath builder) {
        this.monitor = builder.monitor;
        this.mapPath = builder.mapPath;
        this.reader = MapIOFactory.createGrassRasterMapReader(builder.maptype);
        this.reader.setParameter("novalue", new Double(builder.novalue));
        this.reader.setDataWindow(builder.readWindow);
        this.reader.setOutputDataObject(new double[0][0]);
        this.fullMapPath = this.mapPath;
    }

    public boolean open() {
        boolean ok;
        if (this.mapPath != null) {
            ok = this.reader.open(this.mapPath);
        } else if (this.locationPath != null && this.mapsetName != null && this.mapName != null) {
            ok = this.reader.open(this.mapName, this.locationPath, this.mapsetName);
        } else {
            return false;
        }
        return ok;
    }

    public boolean hasMoreData() throws IOException {
        try {
            if (this.reader.hasMoreData(this.monitor)) {
                this.hasMoreData = true;
            }
            return this.hasMoreData;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public RasterData getNextData() {
        if (this.hasMoreData) {
            return new JGrassRasterData((double[][])this.reader.getNextData());
        }
        return null;
    }

    public double[] getRange() {
        return this.reader.getRange();
    }

    public MapReader getReader() {
        return this.reader;
    }

    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public String getFullMapPath() {
        return this.fullMapPath;
    }

    public static class BuilderFromPathAndNames {
        private Window readWindow = null;
        private String mapName = null;
        private String mapsetName = null;
        private String locationPath = null;
        private double novalue = -9999.0;
        private String maptype = "grassbinaryraster";
        private IJGTProgressMonitor monitor = new LogProgressMonitor();

        public BuilderFromPathAndNames(Window readWindow, String mapName, String mapsetName, String locationPath) {
            this.readWindow = readWindow;
            this.mapName = mapName;
            this.mapsetName = mapsetName;
            this.locationPath = locationPath;
        }

        public BuilderFromPathAndNames novalue(double novalue) {
            this.novalue = novalue;
            return this;
        }

        public BuilderFromPathAndNames maptype(String maptype) {
            this.maptype = maptype;
            return this;
        }

        public BuilderFromPathAndNames monitor(IJGTProgressMonitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public JGrassRasterMapReader build() {
            return new JGrassRasterMapReader(this);
        }
    }

    public static class BuilderFromMapPath {
        private final String mapPath;
        private final Window readWindow;
        private double novalue = -9999.0;
        private String maptype = "grassbinaryraster";
        private IJGTProgressMonitor monitor = new LogProgressMonitor();

        public BuilderFromMapPath(Window readWindow, String mapPath) {
            this.readWindow = readWindow;
            this.mapPath = mapPath;
        }

        public BuilderFromMapPath novalue(double novalue) {
            this.novalue = novalue;
            return this;
        }

        public BuilderFromMapPath maptype(String maptype) {
            this.maptype = maptype;
            return this;
        }

        public BuilderFromMapPath monitor(IJGTProgressMonitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public JGrassRasterMapReader build() {
            return new JGrassRasterMapReader(this);
        }
    }
}

