/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.jgrasstools.gears.io.grasslegacy.io.GrassRasterWriter;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;

@Description(value="Legacy class for writing grass rasters.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Grass, Raster, Writing")
@Label(value="Raster Writer")
@UI(value="hide")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class GrassLegacyWriter
extends JGTModel {
    @Description(value="The map that needs to be written.")
    @UI(value="infile")
    @In
    public double[][] geodata = null;
    @Description(value="The region for the map to be written.")
    @In
    public Window inWindow = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The file to the map to be written (the cell file).")
    @In
    public String file = null;
    private boolean hasWritten = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void writeRaster() throws Exception {
        if (!this.concatOr(!this.hasWritten, this.doReset)) {
            return;
        }
        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(new File(this.file));
        GrassRasterWriter writer = new GrassRasterWriter();
        try {
            writer.setOutputDataObject(new double[0][0]);
            writer.setDataWindow(this.inWindow);
            writer.open(mapEnvironment.getCELL().getAbsolutePath());
            writer.write(this.geodata);
        }
        finally {
            writer.close();
        }
        this.hasWritten = true;
    }
}

