/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.jgrasstools.gears.io.grasslegacy.GrassLegacyGridCoverage2D;
import org.jgrasstools.gears.io.grasslegacy.io.GrassRasterReader;
import org.jgrasstools.gears.io.grasslegacy.utils.GrassLegacyUtilities;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Legacy class for reading grass data the old way.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Grass, Raster, Reading")
@Label(value="Raster Reader")
@UI(value="hide")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class GrassLegacyReader
extends JGTModel {
    @Description(value="The file to the map to be read (the cell file).")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="Flag that defines if the map should be read as a whole (false) or on the active region (true and default).")
    @In
    public boolean doActive = true;
    @Description(value="The region to read.")
    @In
    public Window inWindow = null;
    @Description(value="The read output map as limited coverage version.")
    @Out
    public GridCoverage2D outGC = null;
    @Description(value="The read output map data.")
    @Out
    public double[][] geodata = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void readCoverage() throws Exception {
        if (!this.concatOr(this.geodata == null, this.doReset)) {
            return;
        }
        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(new File(this.file));
        JGrassRegion jGrassRegion = null;
        if (this.inWindow == null) {
            jGrassRegion = this.doActive ? mapEnvironment.getActiveRegion() : mapEnvironment.getFileRegion();
            this.inWindow = new Window(jGrassRegion.getWest(), jGrassRegion.getEast(), jGrassRegion.getSouth(), jGrassRegion.getNorth(), jGrassRegion.getWEResolution(), jGrassRegion.getNSResolution());
        }
        GrassRasterReader reader = new GrassRasterReader();
        try {
            reader.setReaderType(1);
            reader.setOutputDataObject(new double[0][0]);
            reader.setDataWindow(this.inWindow);
            reader.open(mapEnvironment.getCELL().getAbsolutePath());
            if (reader.hasMoreData(this.pm)) {
                this.geodata = (double[][])reader.getNextData();
            }
        }
        finally {
            reader.close();
        }
        CoordinateReferenceSystem crs = mapEnvironment.getCoordinateReferenceSystem();
        this.outGC = new GrassLegacyGridCoverage2D(this.inWindow, this.geodata, crs);
    }

    public double getValueAt(Coordinate coordinate) {
        if (this.geodata == null) {
            throw new IllegalArgumentException("The data have first to be read!");
        }
        int[] coordinateToNearestRowCol = GrassLegacyUtilities.coordinateToNearestRowCol(this.inWindow, coordinate);
        if (coordinateToNearestRowCol != null) {
            int row = coordinateToNearestRowCol[0];
            int col = coordinateToNearestRowCol[1];
            if (row > 0 && row < this.geodata.length && col > 0 && col < this.geodata[0].length) {
                return this.geodata[row][col];
            }
        }
        return Double.NaN;
    }

    public static double getValueAt(Window window, Coordinate coordinate, String filePath, IJGTProgressMonitor pm) throws Exception {
        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(new File(filePath));
        if (window == null) {
            JGrassRegion jgr = mapEnvironment.getActiveRegion();
            window = new Window(jgr.getWest(), jgr.getEast(), jgr.getSouth(), jgr.getNorth(), jgr.getWEResolution(), jgr.getNSResolution());
        }
        Window rectangleAroundPoint = GrassLegacyUtilities.getRectangleAroundPoint(window, coordinate.x, coordinate.y);
        GrassLegacyReader reader = new GrassLegacyReader();
        reader.file = filePath;
        reader.inWindow = rectangleAroundPoint;
        if (pm != null) {
            reader.pm = pm;
        }
        reader.readCoverage();
        double[][] data = reader.geodata;
        if (data.length != 1 || data[0].length != 1) {
            throw new IllegalAccessException("Wrong region extracted for picking a single point.");
        }
        return data[0][0];
    }
}

