/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.generic;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Role;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;

@Description(value="Utility class for reading data from csv file that have the form: id1 value1[] id2 value2[] ... idn valuen[].")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="HashMap Data Reader")
@UI(value="hide")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class Id2ValueArrayReader {
    @Description(value="The csv file to read from.")
    @UI(value="infile")
    @In
    public String file = null;
    @Role(value="Parameter ")
    @Description(value="The number of columns of the array.")
    @In
    public int pCols = -1;
    @Role(value="Parameter ")
    @Description(value="The csv separator.")
    @In
    public String pSeparator = ",";
    @Role(value="Parameter ")
    @Description(value="The file novalue.")
    @In
    public String fileNovalue = "-9999.0";
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The read map of ids and values arrays.")
    @Out
    public HashMap<Integer, double[]> data;
    private BufferedReader csvReader;

    private void ensureOpen() throws IOException {
        if (this.csvReader == null) {
            this.csvReader = new BufferedReader(new FileReader(this.file));
        }
    }

    @Execute
    public void readNextLine() throws IOException {
        this.ensureOpen();
        this.data = new HashMap();
        String line = null;
        line = this.csvReader.readLine();
        if (line != null) {
            String[] lineSplit = line.trim().split(this.pSeparator);
            for (int i = 0; i < lineSplit.length; ++i) {
                int id = (int)Double.parseDouble(lineSplit[i].trim());
                double[] values = new double[this.pCols];
                int j = i + 1;
                int k = 0;
                while (j < i + this.pCols + 1) {
                    double value = Double.parseDouble(lineSplit[j].trim());
                    if (this.fileNovalue != null && lineSplit[j].trim().equals(this.fileNovalue)) {
                        value = Double.NaN;
                    }
                    values[k] = value;
                    ++j;
                    ++k;
                }
                this.data.put(id, values);
                i += this.pCols;
            }
        }
    }

    @Finalize
    public void close() throws IOException {
        this.csvReader.close();
    }
}

