/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.exif;

import com.sun.media.imageio.plugins.tiff.EXIFGPSTagSet;
import com.sun.media.imageio.plugins.tiff.EXIFParentTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFImageReadParam;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.jgrasstools.gears.io.exif.ExifUtil;
import org.jgrasstools.gears.libs.exceptions.ModelsIOException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.w3c.dom.NodeList;

@Description(value="Utility class for writing exif tags in jpegs.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Jpeg, Exif, Reading")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class ExifGpsWriter
extends JGTModel {
    @Description(value="The jpeg file.")
    @In
    public String file = null;
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    @Description(value="The latitude to add to the exif tags.")
    @Out
    public Double pLat = null;
    @Description(value="The longitude to add to the exif tags.")
    @Out
    public Double pLon = null;
    @Description(value="The timestamp to add to the exif tags (format yyyy-MM-dd HH:mm:ss).")
    @Out
    public String tTimestamp = null;
    @Description(value="The altidude in meters to add to the exif tags.")
    @Out
    public Double pAltitude = null;
    @Description(value="Switch to define if latitude is northern or southern hemisphere (default is true, i.e northern).")
    @Out
    public boolean doNorth = true;
    @Description(value="Switch to define if longitude is eastern or western part (default is true, i.e eastern).")
    @Out
    public boolean doEast = true;
    private ImageReader jpegReader;
    private ImageWriter jpegWriter;
    private BufferedImage image;
    private File imageFile;
    private String[] latRef = new String[]{"", ""};
    private String[] longRef = new String[]{"", ""};
    private byte[] altRef = new byte[1];
    private long[][] latitude;
    private long[][] longitude;
    private long[][] altitude;
    private String[] imgDirectionRef = new String[]{"", ""};
    private long[][] imgDirection;
    private String[] datum = new String[]{"W", "G", "S", "-", "8", "4", ""};
    private String[] status = new String[]{"", ""};
    private long[][] timeStamp;
    private String[] dateStamp = new String[11];
    private DecimalFormat latFormatter = new DecimalFormat("0000.0000");
    private DecimalFormat lonFormatter = new DecimalFormat("00000.0000");

    @Execute
    public void writeGpsExif() throws IOException {
        this.checkNull(this.pLat, this.pLon, this.tTimestamp);
        String latStr = this.latFormatter.format(this.pLat * 100.0);
        this.latitude = this.getLatitude(latStr);
        String lonStr = this.lonFormatter.format(this.pLon * 100.0);
        this.longitude = this.getLongitude(lonStr);
        this.latRef[0] = this.doNorth ? "N" : "S";
        String string = this.longRef[0] = this.doEast ? "E" : "W";
        if (this.pAltitude != null) {
            double alt = this.pAltitude * 10.0;
            this.altitude = new long[][]{{(long)alt, 10L}};
            this.altRef[0] = 0;
        }
        String[] timeStampSplit = this.tTimestamp.trim().split("\\s+");
        String date = timeStampSplit[0].replaceAll("-", ":");
        this.dateStamp = this.getDate(date);
        String time = timeStampSplit[1].replaceAll(":", "");
        this.timeStamp = this.getTime(time);
        this.imageFile = new File(this.file);
        ImageInputStream is = ImageIO.createImageInputStream(this.imageFile);
        this.jpegReader = ExifUtil.findReader();
        if (this.jpegReader == null) {
            throw new ModelsIOException("Cannot find JPEG reader.", this);
        }
        this.jpegWriter = ExifUtil.findWriter();
        if (this.jpegWriter == null) {
            throw new ModelsIOException("Cannot find JPEG writer.", this);
        }
        this.jpegReader.setInput(is);
        this.image = this.jpegReader.read(0);
        this.writeExif();
    }

    private void writeExif() throws IOException {
        IIOMetadata metadata = this.jpegReader.getImageMetadata(0);
        String[] names = metadata.getMetadataFormatNames();
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(names[0]);
        NodeList nList = root.getElementsByTagName("unknown");
        IIOMetadataNode app1EXIFNode = (IIOMetadataNode)nList.item(0);
        ArrayList<IIOMetadata> md = this.readExif(app1EXIFNode);
        IIOMetadata exifMetadata = md.get(0);
        exifMetadata = this.insertGPSCoords(exifMetadata);
        IIOMetadataNode app1NodeNew = this.createNewExifNode(exifMetadata, null, null);
        app1EXIFNode.setUserObject(app1NodeNew.getUserObject());
        FileImageOutputStream out1 = new FileImageOutputStream(new File("GPS_" + this.imageFile.getName()));
        this.jpegWriter.setOutput(out1);
        metadata.setFromTree(names[0], root);
        IIOImage image = new IIOImage(this.jpegReader.readAsRenderedImage(0, this.jpegReader.getDefaultReadParam()), null, metadata);
        this.jpegWriter.write(this.jpegReader.getStreamMetadata(), image, this.jpegWriter.getDefaultWriteParam());
    }

    private ArrayList<IIOMetadata> readExif(IIOMetadataNode app1EXIFNode) {
        byte[] app1Params = (byte[])app1EXIFNode.getUserObject();
        MemoryCacheImageInputStream app1EXIFInput = new MemoryCacheImageInputStream(new ByteArrayInputStream(app1Params, 6, app1Params.length - 6));
        ImageReader tiffReader = null;
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("tiff");
        while (readers.hasNext() && !(tiffReader = readers.next()).getClass().getName().startsWith("com.sun.media")) {
        }
        if (tiffReader == null) {
            System.out.println("Cannot find core TIFF reader!");
        }
        ArrayList<IIOMetadata> out = new ArrayList<IIOMetadata>(1);
        tiffReader.setInput(app1EXIFInput);
        IIOMetadata tiffMetadata = null;
        try {
            tiffMetadata = tiffReader.getImageMetadata(0);
            TIFFImageReadParam rParam = (TIFFImageReadParam)tiffReader.getDefaultReadParam();
            rParam.setTIFFDecompressor(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        tiffReader.dispose();
        out.add(0, tiffMetadata);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIOMetadataNode createNewExifNode(IIOMetadata tiffMetadata, IIOMetadata thumbMeta, BufferedImage thumbnail) {
        IIOMetadataNode app1Node = null;
        ImageWriter tiffWriter = null;
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("tiff");
            while (writers.hasNext() && !(tiffWriter = writers.next()).getClass().getName().startsWith("com.sun.media")) {
            }
            if (tiffWriter == null) {
                System.out.println("Cannot find core TIFF writer!");
                System.exit(0);
            }
            ImageWriteParam writeParam = tiffWriter.getDefaultWriteParam();
            writeParam.setCompressionMode(2);
            writeParam.setCompressionType("EXIF JPEG");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MemoryCacheImageOutputStream app1EXIFOutput = new MemoryCacheImageOutputStream(baos);
            tiffWriter.setOutput(app1EXIFOutput);
            tiffWriter.prepareWriteEmpty(this.jpegReader.getStreamMetadata(), new ImageTypeSpecifier(this.image), this.image.getWidth(), this.image.getHeight(), tiffMetadata, null, writeParam);
            tiffWriter.endWriteEmpty();
            app1EXIFOutput.flush();
            byte[] app1Parameters = new byte[6 + baos.size()];
            app1Parameters[0] = 69;
            app1Parameters[1] = 120;
            app1Parameters[2] = 105;
            app1Parameters[3] = 102;
            app1Parameters[5] = 0;
            app1Parameters[4] = 0;
            System.arraycopy(baos.toByteArray(), 0, app1Parameters, 6, baos.size());
            app1Node = new IIOMetadataNode("unknown");
            app1Node.setAttribute("MarkerTag", new Integer(225).toString());
            app1Node.setUserObject(app1Parameters);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (tiffWriter != null) {
                tiffWriter.dispose();
            }
        }
        return app1Node;
    }

    private IIOMetadata insertGPSCoords(IIOMetadata exif) {
        IIOMetadata outExif = null;
        try {
            TIFFDirectory ifd = TIFFDirectory.createFromMetadata((IIOMetadata)exif);
            TIFFField gpsInfoPointer = null;
            if (ifd.containsTIFFField(34853)) {
                gpsInfoPointer = ifd.getTIFFField(34853);
                System.out.println("Already has GPS Metadata");
                return exif;
            }
            TIFFDirectory gpsData = this.createDirectory();
            EXIFParentTIFFTagSet parentSet = EXIFParentTIFFTagSet.getInstance();
            gpsInfoPointer = new TIFFField(parentSet.getTag(34853), 4, 1, (Object)gpsData);
            System.out.println("is pointer =" + gpsInfoPointer.getTag().isIFDPointer() + " data type is ok=" + gpsInfoPointer.getTag().isDataTypeOK(4));
            ifd.addTIFFField(gpsInfoPointer);
            outExif = ifd.getAsMetadata();
        }
        catch (IIOInvalidTreeException e) {
            e.printStackTrace();
        }
        return outExif;
    }

    private TIFFDirectory createDirectory() {
        EXIFGPSTagSet gpsTags = EXIFGPSTagSet.getInstance();
        ArrayList<EXIFGPSTagSet> tags = new ArrayList<EXIFGPSTagSet>();
        tags.add(gpsTags);
        TIFFIFD directory = new TIFFIFD(tags, EXIFParentTIFFTagSet.getInstance().getTag(34853));
        TIFFField field = new TIFFField(gpsTags.getTag(0), 1, 4, (Object)EXIFGPSTagSet.GPS_VERSION_2_2);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(1), 2, 2, (Object)this.latRef);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(2), 5, 3, (Object)this.latitude);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(3), 2, 2, (Object)this.longRef);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(4), 5, 3, (Object)this.longitude);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(7), 5, 3, (Object)this.timeStamp);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(9), 2, 2, (Object)this.status);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(29), 2, 11, (Object)this.dateStamp);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(18), 2, 6, (Object)this.datum);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(5), 1, 1, (Object)this.altRef);
        directory.addTIFFField(field);
        field = new TIFFField(gpsTags.getTag(6), 5, 1, (Object)this.altitude);
        directory.addTIFFField(field);
        this.imgDirectionRef[0] = "T";
        field = new TIFFField(gpsTags.getTag(16), 2, 2, (Object)this.imgDirectionRef);
        directory.addTIFFField(field);
        if (this.imgDirection == null) {
            this.imgDirection = new long[][]{{0L, 100L}};
        }
        field = new TIFFField(gpsTags.getTag(17), 5, 1, (Object)this.imgDirection);
        directory.addTIFFField(field);
        return directory;
    }

    private long[][] getLatitude(String lat) {
        float secs = Float.parseFloat("0" + lat.substring(4)) * 60.0f;
        long nom = (long)(secs * 1000.0f);
        long[][] latl = new long[][]{{Long.parseLong(lat.substring(0, 2)), 1L}, {Long.parseLong(lat.substring(2, 4)), 1L}, {nom, 1000L}};
        return latl;
    }

    private long[][] getLongitude(String longi) {
        float secs = Float.parseFloat("0" + longi.substring(5)) * 60.0f;
        long nom = (long)(secs * 1000.0f);
        long[][] longl = new long[][]{{Long.parseLong(longi.substring(0, 3)), 1L}, {Long.parseLong(longi.substring(3, 5)), 1L}, {nom, 1000L}};
        return longl;
    }

    private long[][] getTime(String time) {
        long[][] timel = new long[][]{{Long.parseLong(time.substring(0, 2)), 1L}, {Long.parseLong(time.substring(2, 4)), 1L}, {Long.parseLong(time.substring(4)), 1L}};
        return timel;
    }

    private String[] getDate(String date) {
        String dateStr = "20" + date.substring(4) + ":" + date.substring(2, 4) + ":" + date.substring(0, 2);
        String[] dateArray = new String[11];
        for (int i = 0; i < dateStr.length(); ++i) {
            dateArray[i] = dateStr.substring(i, i + 1);
        }
        dateArray[10] = "";
        return dateArray;
    }
}

