/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.eicalculator;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Role;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.jgrasstools.gears.io.eicalculator.EIAltimetry;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;

@Description(value="Utility class for writing altimetry data to csv files.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Writing")
@Label(value="List Data Writer")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class EIAltimetryWriter
extends JGTModel {
    @Description(value="The data to write.")
    @In
    public List<EIAltimetry> inAltimetry;
    @Description(value="The csv file to write to.")
    @UI(value="outfile")
    @In
    public String file = null;
    @Role(value="Parameter ")
    @Description(value="The csv separator.")
    @In
    public String pSeparator = ",";
    @Description(value="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    private BufferedWriter csvWriter;

    private void ensureOpen() throws IOException {
        if (this.csvWriter == null) {
            this.csvWriter = new BufferedWriter(new FileWriter(this.file));
        }
    }

    @Finalize
    public void close() throws IOException {
        this.csvWriter.close();
    }

    @Execute
    public void write() throws IOException {
        this.ensureOpen();
        this.csvWriter.write("# EIAltimetry writer output\n");
        for (EIAltimetry altimetry : this.inAltimetry) {
            StringBuilder sb = new StringBuilder();
            sb.append(altimetry.basinId);
            sb.append(this.pSeparator);
            sb.append(altimetry.altimetricBandId);
            sb.append(this.pSeparator);
            sb.append(altimetry.elevationValue);
            sb.append(this.pSeparator);
            sb.append(altimetry.bandRange);
            sb.append("\n");
            this.csvWriter.write(sb.toString());
        }
    }
}

