/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dxf;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfENTITY;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfFile;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class DxfPOINT
extends DxfENTITY {
    public DxfPOINT() {
        super("DEFAULT");
    }

    public static DxfGroup readEntity(RandomAccessFile raf, FeatureCollection<SimpleFeatureType, SimpleFeature> entities) throws IOException {
        DxfGroup group;
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(DxfFile.DXF_POINTSCHEMA);
        String layer = "";
        String ltype = "";
        Double elevation = new Double(0.0);
        Double thickness = new Double(0.0);
        Integer color = new Integer(256);
        String text = "";
        Double text_height = new Double(0.0);
        String text_style = "";
        while (null != (group = DxfGroup.readGroup(raf)) && group.getCode() != 0) {
            if (group.getCode() == 8) {
                layer = group.getValue();
                continue;
            }
            if (group.getCode() == 6) {
                ltype = group.getValue();
                continue;
            }
            if (group.getCode() == 38) {
                elevation = new Double(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 39) {
                thickness = new Double(group.getDoubleValue());
                continue;
            }
            if (group.getCode() == 62) {
                color = new Integer(group.getIntValue());
                continue;
            }
            if (group.getCode() == 10) {
                x = group.getDoubleValue();
                continue;
            }
            if (group.getCode() == 20) {
                y = group.getDoubleValue();
                continue;
            }
            if (group.getCode() != 30) continue;
            z = group.getDoubleValue();
        }
        if (!Double.isNaN(x) && !Double.isNaN(y)) {
            Object[] values = new Object[]{gF.createPoint(new Coordinate(x, y, z)), layer, ltype, elevation, thickness, color, text, text_height, text_style};
            builder.addAll(values);
            StringBuilder featureId = new StringBuilder();
            featureId.append(DxfFile.DXF_POINTSCHEMA.getTypeName());
            featureId.append(".");
            featureId.append(DxfFile.getNextFid());
            SimpleFeature feature = builder.buildFeature(featureId.toString());
            entities.add((Feature)feature);
        }
        return group;
    }
}

