/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dxf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DxfGroup {
    private static final DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat[] decimalFormats = new DecimalFormat[]{new DecimalFormat("#0", dfs), new DecimalFormat("#0.0", dfs), new DecimalFormat("#0.00", dfs), new DecimalFormat("#0.000", dfs), new DecimalFormat("#0.0000", dfs), new DecimalFormat("#0.00000", dfs), new DecimalFormat("#0.000000", dfs), new DecimalFormat("#0.0000000", dfs), new DecimalFormat("#0.00000000", dfs), new DecimalFormat("#0.000000000", dfs), new DecimalFormat("#0.0000000000", dfs), new DecimalFormat("#0.00000000000", dfs), new DecimalFormat("#0.000000000000", dfs)};
    private int code;
    private String value;
    private long address;

    public DxfGroup(int code, String value) {
        this.code = code;
        this.value = value;
    }

    public DxfGroup(String code, String value) throws NumberFormatException {
        this.code = Integer.parseInt(code);
        this.value = value;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getValue() {
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.value.trim());
    }

    public float getFloatValue() {
        return Float.parseFloat(this.value.trim());
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.value.trim());
    }

    public long getAddress() {
        return this.address;
    }

    private void setAddress(long address) {
        this.address = address;
    }

    public boolean equals(DxfGroup other) {
        return this.code == other.getCode() && this.value.equals(other.getValue());
    }

    public String toString() {
        String codeString = "    " + Integer.toString(this.code);
        int stringLength = codeString.length();
        codeString = codeString.substring(stringLength - (this.code < 1000 ? 3 : 4), stringLength);
        return codeString + "\r\n" + this.value + "\r\n";
    }

    public static String int34car(int code) {
        if (code < 10) {
            return "  " + Integer.toString(code);
        }
        if (code < 100) {
            return " " + Integer.toString(code);
        }
        return Integer.toString(code);
    }

    public static String int6car(int value) {
        String s = "     " + Integer.toString(value);
        return s.substring(s.length() - 6, s.length());
    }

    public static String toString(int code, String value) {
        return DxfGroup.int34car(code) + "\r\n" + value + "\r\n";
    }

    public static String toString(int code, int value) {
        return DxfGroup.int34car(code) + "\r\n" + DxfGroup.int6car(value) + "\r\n";
    }

    public static String toString(int code, float value, int decimalPartLength) {
        return DxfGroup.int34car(code) + "\r\n" + decimalFormats[decimalPartLength].format(value) + "\r\n";
    }

    public static String toString(int code, double value, int decimalPartLength) {
        return DxfGroup.int34car(code) + "\r\n" + decimalFormats[decimalPartLength].format(value) + "\r\n";
    }

    public static String toString(int code, Object value) {
        if (value instanceof String) {
            return DxfGroup.toString(code, (String)value);
        }
        if (value instanceof Integer) {
            return DxfGroup.toString(code, (Integer)value);
        }
        if (value instanceof Float) {
            return DxfGroup.toString(code, ((Float)value).floatValue(), 3);
        }
        if (value instanceof Double) {
            return DxfGroup.toString(code, (Double)value, 6);
        }
        return DxfGroup.toString(code, value.toString());
    }

    public static DxfGroup readGroup(RandomAccessFile raf) throws IOException {
        try {
            long pos = raf.getFilePointer();
            DxfGroup dxfGroup = new DxfGroup(Integer.parseInt(raf.readLine().trim()), raf.readLine());
            dxfGroup.setAddress(pos);
            return dxfGroup;
        }
        catch (IOException ioe) {
            raf.close();
            throw ioe;
        }
    }
}

