/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.jgrasstools.gears.io.dxfdwg.libs.GeometryTranslator;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgFile;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgArc;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgAttrib;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgCircle;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgLine;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgLwPolyline;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgMText;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgPoint;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline2D;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline3D;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgSolid;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgText;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class DwgReader {
    DwgFile file;
    FeatureIterator<SimpleFeature> enumeration;
    int chosenLayerType = -1;
    private SimpleFeatureCollection contourFeatures = FeatureCollections.newCollection();
    private SimpleFeatureCollection multiLineFeatures = FeatureCollections.newCollection();
    private SimpleFeatureCollection multiPointFeatures = FeatureCollections.newCollection();
    private SimpleFeatureCollection multiPolygonFeatures = FeatureCollections.newCollection();
    private SimpleFeatureCollection textFeatures = FeatureCollections.newCollection();
    private SimpleFeatureCollection attributesFeatures = FeatureCollections.newCollection();

    public DwgReader(DwgFile pFile, GeometryTranslator gTranslator) throws SchemaException {
        this.file = pFile;
        Vector dwgObjects = this.file.getDwgObjects();
        int cat = 0;
        int elenmentnum = dwgObjects.size();
        for (int i = 0; i < elenmentnum; ++i) {
            DwgObject text;
            SimpleFeature feature;
            DwgObject entity = (DwgObject)dwgObjects.get(i);
            String layerName = pFile.getLayerName(entity);
            if (entity instanceof DwgArc) {
                DwgArc arc = (DwgArc)entity;
                feature = gTranslator.convertDwgArc("lines", layerName, arc, cat);
                this.multiLineFeatures.add((Feature)feature);
            } else if (entity instanceof DwgCircle) {
                DwgCircle circle = (DwgCircle)entity;
                feature = gTranslator.convertDwgCircle("polygons", layerName, circle, cat);
                this.multiPolygonFeatures.add((Feature)feature);
            } else if (entity instanceof DwgLine) {
                DwgLine line = (DwgLine)entity;
                feature = gTranslator.convertDwgLine("lines", layerName, line, cat);
                this.multiLineFeatures.add((Feature)feature);
            } else if (entity instanceof DwgPoint) {
                DwgPoint point = (DwgPoint)entity;
                feature = gTranslator.convertDwgPoint("points", layerName, point, cat);
                this.multiPointFeatures.add((Feature)feature);
            } else if (entity instanceof DwgPolyline2D) {
                DwgPolyline2D polyline2d = (DwgPolyline2D)entity;
                feature = gTranslator.convertDwgPolyline2D("lines", layerName, polyline2d, cat);
                if (feature != null) {
                    this.multiLineFeatures.add((Feature)feature);
                }
            } else if (entity instanceof DwgPolyline3D) {
                DwgPolyline3D polyline3d = (DwgPolyline3D)entity;
                feature = gTranslator.convertDwgPolyline3D("lines", layerName, polyline3d, cat);
                if (feature != null) {
                    this.multiLineFeatures.add((Feature)feature);
                }
            } else if (entity instanceof DwgText) {
                text = (DwgText)entity;
                feature = gTranslator.convertDwgText("text", layerName, (DwgText)text, cat);
                this.textFeatures.add((Feature)feature);
            } else if (entity instanceof DwgAttrib) {
                DwgAttrib attribute = (DwgAttrib)entity;
                feature = gTranslator.convertDwgAttribute("text", layerName, attribute, cat);
                this.attributesFeatures.add((Feature)feature);
            } else if (entity instanceof DwgMText) {
                text = (DwgMText)entity;
                feature = gTranslator.convertDwgMText("text", layerName, (DwgMText)text, cat);
                this.textFeatures.add((Feature)feature);
            } else if (entity instanceof DwgSolid) {
                DwgSolid solid = (DwgSolid)entity;
                feature = gTranslator.convertDwgSolid("polygon", layerName, solid, cat);
                this.multiPolygonFeatures.add((Feature)feature);
            } else if (entity instanceof DwgLwPolyline) {
                DwgLwPolyline lwPolyline = (DwgLwPolyline)entity;
                feature = gTranslator.convertDwgLwPolyline("lines", layerName, lwPolyline, cat);
                this.multiLineFeatures.add((Feature)feature);
            }
            ++cat;
        }
    }

    public HashMap<String, FeatureCollection<SimpleFeatureType, SimpleFeature>> getFeatureCollectionsMap() throws IOException {
        HashMap<String, FeatureCollection<SimpleFeatureType, SimpleFeature>> map = new HashMap<String, FeatureCollection<SimpleFeatureType, SimpleFeature>>();
        if (this.textFeatures.size() > 0) {
            map.put("text", (FeatureCollection<SimpleFeatureType, SimpleFeature>)this.textFeatures);
        }
        if (this.attributesFeatures.size() > 0) {
            map.put("text", (FeatureCollection<SimpleFeatureType, SimpleFeature>)this.attributesFeatures);
        }
        if (this.multiLineFeatures.size() > 0) {
            map.put("lines", (FeatureCollection<SimpleFeatureType, SimpleFeature>)this.multiLineFeatures);
        }
        if (this.contourFeatures.size() > 0) {
            map.put("lines", (FeatureCollection<SimpleFeatureType, SimpleFeature>)this.contourFeatures);
        }
        if (this.multiPointFeatures.size() > 0) {
            map.put("points", (FeatureCollection<SimpleFeatureType, SimpleFeature>)this.multiPointFeatures);
        }
        if (this.multiPolygonFeatures.size() > 0) {
            map.put("polygons", (FeatureCollection<SimpleFeatureType, SimpleFeature>)this.multiPolygonFeatures);
        }
        return map;
    }

    public SimpleFeatureCollection getTextFeatures() {
        return this.textFeatures;
    }

    public SimpleFeatureCollection getAttributesFeatures() {
        return this.attributesFeatures;
    }

    public SimpleFeatureCollection getMultiLineFeatures() {
        return this.multiLineFeatures;
    }

    public SimpleFeatureCollection getContourFeatures() {
        return this.contourFeatures;
    }

    public SimpleFeatureCollection getMultiPointFeatures() {
        return this.multiPointFeatures;
    }

    public SimpleFeatureCollection getMultiPolygonFeatures() {
        return this.multiPolygonFeatures;
    }

    public synchronized void close() throws IOException {
        if (this.file != null) {
            this.file = null;
        }
        this.enumeration = null;
    }
}

