/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dbf;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.jgrasstools.gears.libs.modules.JGTModel;

@Description(value="Utility class for reading dbf tables.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Reading")
@Label(value="HashMap Data Reader")
@Status(value=10)
@Name(value="dbfreader")
@License(value="General Public License Version 3 (GPLv3)")
public class DbfTableReader
extends JGTModel {
    @Description(value="The dbf file.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The read dbf table.")
    @Out
    public HashMap<String, List<Object>> outTabledata = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void readTable() throws IOException {
        if (!this.concatOr(this.outTabledata == null, this.doReset)) {
            return;
        }
        FileInputStream fis = null;
        DbaseFileReader dbfReader = null;
        try {
            int i;
            fis = new FileInputStream(this.file);
            dbfReader = new DbaseFileReader((ReadableByteChannel)fis.getChannel(), false, Charset.defaultCharset());
            DbaseFileHeader header = dbfReader.getHeader();
            int numFields = header.getNumFields();
            this.outTabledata = new HashMap();
            for (i = 0; i < numFields; ++i) {
                String fieldName = header.getFieldName(i);
                this.outTabledata.put(fieldName, new ArrayList());
            }
            while (dbfReader.hasNext()) {
                dbfReader.read();
                for (i = 0; i < numFields; ++i) {
                    Object field = dbfReader.readField(i);
                    String fieldName = header.getFieldName(i);
                    List<Object> list = this.outTabledata.get(fieldName);
                    list.add(field);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            dbfReader.close();
            fis.close();
        }
    }

    public static HashMap<String, List<Object>> readDbf(String path) throws IOException {
        DbfTableReader reader = new DbfTableReader();
        reader.file = path;
        reader.readTable();
        return reader.outTabledata;
    }
}

