/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Status;
import org.jgrasstools.gears.libs.modules.ClassField;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;

public class JGrassGears {
    private static JGrassGears jgrassGears = null;
    private URL baseclassUrl;
    public final LinkedHashMap<String, Class<?>> moduleName2Class = new LinkedHashMap();
    public final LinkedHashMap<String, List<ClassField>> moduleName2Fields = new LinkedHashMap();
    public String[] allFields = null;
    public String[] allClasses = null;

    private JGrassGears(URL baseclassUrl) {
        this.baseclassUrl = baseclassUrl;
    }

    public static synchronized JGrassGears getInstance() {
        if (jgrassGears == null) {
            jgrassGears = new JGrassGears(null);
            jgrassGears.gatherInformations();
        }
        return jgrassGears;
    }

    public static JGrassGears getInstance(URL baseclassUrl) {
        jgrassGears = new JGrassGears(baseclassUrl);
        jgrassGears.gatherInformations();
        return jgrassGears;
    }

    private void gatherInformations() {
        try {
            if (this.baseclassUrl == null) {
                this.baseclassUrl = ClasspathUrlFinder.findClassBase(JGrassGears.class);
            }
            AnnotationDB db = new AnnotationDB();
            db.scanArchives(new URL[]{this.baseclassUrl});
            Map annotationIndex = db.getAnnotationIndex();
            Set simpleClasses = (Set)annotationIndex.get(Execute.class.getName());
            for (String className : simpleClasses) {
                if (!className.startsWith("org.jgrasstools.gears")) continue;
                int lastDot = className.lastIndexOf(46);
                String name = className.substring(lastDot + 1);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                    this.moduleName2Class.put(name, clazz);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            ArrayList<String> classNames = new ArrayList<String>();
            ArrayList<String> fieldNamesList = new ArrayList<String>();
            Set<Map.Entry<String, Class<?>>> moduleName2ClassEntries = this.moduleName2Class.entrySet();
            for (Map.Entry<String, Class<?>> moduleName2ClassEntry : moduleName2ClassEntries) {
                String moduleName = moduleName2ClassEntry.getKey();
                Class<?> moduleClass = moduleName2ClassEntry.getValue();
                Status annotation = moduleClass.getAnnotation(Status.class);
                if (annotation == null) {
                    System.out.println("Missing status: " + moduleClass.getCanonicalName());
                    continue;
                }
                String statusString = null;
                int status = annotation.value();
                switch (status) {
                    case 40: {
                        statusString = "CERTIFIED";
                        break;
                    }
                    case 10: {
                        statusString = "DRAFT";
                        break;
                    }
                    case 20: {
                        statusString = "TESTED";
                        break;
                    }
                    default: {
                        statusString = "UNKNOWN";
                    }
                }
                classNames.add(moduleName);
                ArrayList<ClassField> tmpfields = new ArrayList<ClassField>();
                Object annotatedObject = moduleClass.newInstance();
                ComponentAccess cA = new ComponentAccess(annotatedObject);
                Collection inputs = cA.inputs();
                for (Access access : inputs) {
                    Field field = access.getField();
                    String name = field.getName();
                    Description descriptionAnnot = field.getAnnotation(Description.class);
                    String description = name;
                    if (descriptionAnnot != null && (description = descriptionAnnot.value()) == null) {
                        description = name;
                    }
                    Class<?> fieldClass = field.getType();
                    ClassField cf = new ClassField();
                    cf.isIn = true;
                    cf.fieldName = name;
                    cf.fieldDescription = description;
                    cf.fieldClass = fieldClass;
                    cf.parentClass = moduleClass;
                    cf.parentClassStatus = statusString;
                    if (!fieldNamesList.contains(name)) {
                        fieldNamesList.add(name);
                    }
                    tmpfields.add(cf);
                }
                Collection outputs = cA.outputs();
                for (Access access : outputs) {
                    Field field = access.getField();
                    String name = field.getName();
                    Description descriptionAnnot = field.getAnnotation(Description.class);
                    String description = name;
                    if (descriptionAnnot != null && (description = descriptionAnnot.value()) == null) {
                        description = name;
                    }
                    Class<?> fieldClass = field.getType();
                    ClassField cf = new ClassField();
                    cf.isOut = true;
                    cf.fieldName = name;
                    cf.fieldDescription = description;
                    cf.fieldClass = fieldClass;
                    cf.parentClass = moduleClass;
                    cf.parentClassStatus = statusString;
                    if (!fieldNamesList.contains(name)) {
                        fieldNamesList.add(name);
                    }
                    tmpfields.add(cf);
                }
                this.moduleName2Fields.put(moduleName, tmpfields);
            }
            Collections.sort(fieldNamesList);
            this.allFields = fieldNamesList.toArray(new String[fieldNamesList.size()]);
            Collections.sort(classNames);
            this.allClasses = classNames.toArray(new String[classNames.size()]);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        Set<Map.Entry<String, Class<?>>> entrySet = JGrassGears.getInstance().moduleName2Class.entrySet();
        for (Map.Entry<String, Class<?>> entry : entrySet) {
            System.out.println(entry.getKey() + " - " + entry.getValue().getCanonicalName());
        }
        List<ClassField> list = JGrassGears.getInstance().moduleName2Fields.get("LineSmoother");
        for (ClassField classField : list) {
            System.out.println(classField);
        }
    }
}

