/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class IssuesCollectionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ISSUES_COLLECTION_ERROR_PREFIX = "Issues Collection Failed: ";
    private static final String MISSING_CONFIGURATION_ERROR = "Configuration file must contain: ";
    private int version;
    private Issues issues;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Issues getIssues() {
        return this.issues;
    }

    public void setIssues(Issues issues) {
        this.issues = issues;
    }

    public void validateConfig() throws IOException {
        if (this.issues == null) {
            throw new IOException("Issues Collection Failed: Configuration file must contain: issues");
        }
        if (this.issues.trackerName == null) {
            throw new IOException("Issues Collection Failed: Configuration file must contain: trackerName");
        }
        if (this.issues.regexp == null) {
            throw new IOException("Issues Collection Failed: Configuration file must contain: regexp");
        }
        if (this.issues.keyGroupIndex == 0) {
            throw new IOException("Issues Collection Failed: Configuration file must contain: keyGroupIndex");
        }
        if (this.issues.summaryGroupIndex == 0) {
            throw new IOException("Issues Collection Failed: Configuration file must contain: summaryGroupIndex");
        }
    }

    public static class Issues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String trackerName;
        private String regexp;
        private int keyGroupIndex;
        private int summaryGroupIndex;
        private String trackerUrl;
        private boolean aggregate;
        private String aggregationStatus;

        public String getTrackerName() {
            return this.trackerName;
        }

        public void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public void setRegexp(String regexp) {
            this.regexp = regexp;
        }

        public int getKeyGroupIndex() {
            return this.keyGroupIndex;
        }

        public void setKeyGroupIndex(int keyGroupIndex) {
            this.keyGroupIndex = keyGroupIndex;
        }

        public int getSummaryGroupIndex() {
            return this.summaryGroupIndex;
        }

        public void setSummaryGroupIndex(int summaryGroupIndex) {
            this.summaryGroupIndex = summaryGroupIndex;
        }

        public String getTrackerUrl() {
            return this.trackerUrl;
        }

        public void setTrackerUrl(String trackerUrl) {
            this.trackerUrl = StringUtils.stripEnd((String)trackerUrl, (String)"/");
        }

        public boolean isAggregate() {
            return this.aggregate;
        }

        public void setAggregate(boolean aggregate) {
            this.aggregate = aggregate;
        }

        public String getAggregationStatus() {
            return this.aggregationStatus;
        }

        public void setAggregationStatus(String aggregationStatus) {
            this.aggregationStatus = aggregationStatus;
        }
    }
}

