/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalTooltipRotatingExpander;", "", "verticalSpace", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "horizontalSpace", "(Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;)V", "findValidCandidate", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "candidates", "", "restrictions", "fixOverlapping", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "tooltips", "getCandidates", "positionedTooltip", "intersectsAny", "", "rect", "Companion", "TooltipRotationHelper", "plot-builder"})
public final class VerticalTooltipRotatingExpander {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleSpan verticalSpace;
    @NotNull
    private final DoubleSpan horizontalSpace;
    @NotNull
    private static final DoubleSpan STEM_TO_LEFT_SIDE_ANGLE_RANGE = new DoubleSpan(-0.7853981633974483, 0.7853981633974483);
    @NotNull
    private static final DoubleSpan STEM_TO_BOTTOM_SIDE_ANGLE_RANGE = new DoubleSpan(0.7853981633974483, 2.356194490192345);
    @NotNull
    private static final DoubleSpan STEM_TO_RIGHT_SIDE_ANGLE_RANGE = new DoubleSpan(2.356194490192345, 3.9269908169872414);
    @NotNull
    private static final DoubleSpan STEM_TO_TOP_SIDE_ANGLE_RANGE = new DoubleSpan(3.9269908169872414, 5.497787143782138);
    private static final int SECTOR_COUNT = 36;
    private static final double SECTOR_ANGLE = 0.17453292519943295;
    @NotNull
    private static final DoubleVector POINT_RESTRICTION_SIZE = new DoubleVector(1.0, 1.0);

    public VerticalTooltipRotatingExpander(@NotNull DoubleSpan verticalSpace, @NotNull DoubleSpan horizontalSpace) {
        Intrinsics.checkNotNullParameter((Object)verticalSpace, (String)"verticalSpace");
        Intrinsics.checkNotNullParameter((Object)horizontalSpace, (String)"horizontalSpace");
        this.verticalSpace = verticalSpace;
        this.horizontalSpace = horizontalSpace;
    }

    @NotNull
    public final List<LayoutManager.PositionedTooltip> fixOverlapping(@NotNull List<LayoutManager.PositionedTooltip> tooltips, @NotNull List<DoubleRectangle> restrictions) {
        Intrinsics.checkNotNullParameter(tooltips, (String)"tooltips");
        Intrinsics.checkNotNullParameter(restrictions, (String)"restrictions");
        ArrayList<Pair> expandedPositions = new ArrayList<Pair>();
        int n = tooltips.size();
        for (int i = 0; i < n; ++i) {
            LayoutManager.PositionedTooltip tooltip = tooltips.get(i);
            if (this.intersectsAny(tooltip.rect$plot_builder(), restrictions)) {
                ArrayList<DoubleRectangle> restrictionsWithStems = new ArrayList<DoubleRectangle>((Collection)restrictions);
                restrictionsWithStems.add(new DoubleRectangle(tooltip.getStemCoord(), POINT_RESTRICTION_SIZE));
                DoubleRectangle newPlacement = this.findValidCandidate(this.getCandidates(tooltip), (List<DoubleRectangle>)restrictionsWithStems);
                if (newPlacement == null) {
                    expandedPositions.add(new Pair((Object)i, (Object)tooltip.getTooltipCoord()));
                    continue;
                }
                expandedPositions.add(new Pair((Object)i, (Object)newPlacement.getOrigin()));
                continue;
            }
            expandedPositions.add(new Pair((Object)i, (Object)tooltip.getTooltipCoord()));
        }
        ArrayList<LayoutManager.PositionedTooltip> separatedTooltips = new ArrayList<LayoutManager.PositionedTooltip>();
        for (Pair expandedPosition : expandedPositions) {
            LayoutManager.PositionedTooltip positionedTooltip = tooltips.get(((Number)expandedPosition.getFirst()).intValue());
            separatedTooltips.add(positionedTooltip.moveTo$plot_builder((DoubleVector)expandedPosition.getSecond()));
        }
        return separatedTooltips;
    }

    private final List<DoubleRectangle> getCandidates(LayoutManager.PositionedTooltip positionedTooltip) {
        TooltipRotationHelper tooltipRotationHelper = new TooltipRotationHelper(positionedTooltip);
        ArrayList<DoubleRectangle> candidates = new ArrayList<DoubleRectangle>();
        candidates.add(tooltipRotationHelper.rotate(1.5707963267948966));
        candidates.add(tooltipRotationHelper.rotate(4.71238898038469));
        candidates.add(tooltipRotationHelper.rotate(0.0));
        candidates.add(tooltipRotationHelper.rotate(Math.PI));
        double alpha = 1.5707963267948966;
        int i = 0;
        while (i < 36) {
            if (alpha > Math.PI) {
                alpha -= Math.PI;
            }
            candidates.add(tooltipRotationHelper.rotate(alpha));
            ++i;
            alpha += 0.17453292519943295;
        }
        return candidates;
    }

    private final boolean intersectsAny(DoubleRectangle rect2, List<DoubleRectangle> restrictions) {
        for (DoubleRectangle restriction : restrictions) {
            if (!rect2.intersects(restriction)) continue;
            return true;
        }
        return false;
    }

    private final DoubleRectangle findValidCandidate(List<DoubleRectangle> candidates, List<DoubleRectangle> restrictions) {
        for (DoubleRectangle candidate : candidates) {
            if (this.intersectsAny(candidate, restrictions) || !this.verticalSpace.contains(DoubleSpan.Companion.withLowerEnd(candidate.getOrigin().getY(), candidate.getDimension().getY())) || !this.horizontalSpace.contains(DoubleSpan.Companion.withLowerEnd(candidate.getOrigin().getX(), candidate.getDimension().getX()))) continue;
            return candidate;
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalTooltipRotatingExpander$Companion;", "", "()V", "POINT_RESTRICTION_SIZE", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "SECTOR_ANGLE", "", "SECTOR_COUNT", "", "STEM_TO_BOTTOM_SIDE_ANGLE_RANGE", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "STEM_TO_LEFT_SIDE_ANGLE_RANGE", "STEM_TO_RIGHT_SIDE_ANGLE_RANGE", "STEM_TO_TOP_SIDE_ANGLE_RANGE", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalTooltipRotatingExpander$TooltipRotationHelper;", "", "positionedTooltip", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;)V", "myAttachToTooltipsBottomOffset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "myAttachToTooltipsLeftOffset", "myAttachToTooltipsRightOffset", "myAttachToTooltipsTopOffset", "myTargetCoord", "myTooltipSize", "rotate", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "alpha", "", "plot-builder"})
    public static final class TooltipRotationHelper {
        @NotNull
        private final DoubleVector myAttachToTooltipsTopOffset;
        @NotNull
        private final DoubleVector myAttachToTooltipsBottomOffset;
        @NotNull
        private final DoubleVector myAttachToTooltipsLeftOffset;
        @NotNull
        private final DoubleVector myAttachToTooltipsRightOffset;
        @NotNull
        private final DoubleVector myTooltipSize;
        @NotNull
        private final DoubleVector myTargetCoord;

        public TooltipRotationHelper(@NotNull LayoutManager.PositionedTooltip positionedTooltip) {
            Intrinsics.checkNotNullParameter((Object)positionedTooltip, (String)"positionedTooltip");
            this.myTooltipSize = positionedTooltip.getTooltipSize$plot_builder();
            this.myTargetCoord = positionedTooltip.getStemCoord();
            double middleX = this.myTooltipSize.getX() / (double)2;
            double middleY = this.myTooltipSize.getY() / (double)2;
            this.myAttachToTooltipsTopOffset = new DoubleVector(-middleX, 0.0);
            this.myAttachToTooltipsBottomOffset = new DoubleVector(-middleX, -this.myTooltipSize.getY());
            this.myAttachToTooltipsLeftOffset = new DoubleVector(0.0, middleY);
            this.myAttachToTooltipsRightOffset = new DoubleVector(-this.myTooltipSize.getX(), middleY);
        }

        @NotNull
        public final DoubleRectangle rotate(double alpha) {
            DoubleVector doubleVector;
            double r = TipLayoutHint.StemLength.NORMAL.getValue();
            DoubleVector newAttachmentCoord = new DoubleVector(r * Math.cos(alpha), r * Math.sin(alpha)).add(this.myTargetCoord);
            if (STEM_TO_BOTTOM_SIDE_ANGLE_RANGE.contains(alpha)) {
                doubleVector = newAttachmentCoord.add(this.myAttachToTooltipsBottomOffset);
            } else if (STEM_TO_TOP_SIDE_ANGLE_RANGE.contains(alpha)) {
                doubleVector = newAttachmentCoord.add(this.myAttachToTooltipsTopOffset);
            } else if (STEM_TO_LEFT_SIDE_ANGLE_RANGE.contains(alpha)) {
                doubleVector = newAttachmentCoord.add(this.myAttachToTooltipsLeftOffset);
            } else if (STEM_TO_RIGHT_SIDE_ANGLE_RANGE.contains(alpha)) {
                doubleVector = newAttachmentCoord.add(this.myAttachToTooltipsRightOffset);
            } else {
                throw new IllegalStateException();
            }
            DoubleVector newTooltipCoord = doubleVector;
            return new DoubleRectangle(newTooltipCoord, this.myTooltipSize);
        }
    }
}

