/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.layout;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.VerticalAlignmentResolver;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver;", "", "myVerticalSpace", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "(Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;)V", "resolve", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$VerticalAlignment;", "topPlacementRange", "bottomPlacementRange", "preferredPlacement", "cursorRange", "Companion", "Matcher", "plot-builder"})
public final class VerticalAlignmentResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleSpan myVerticalSpace;
    @NotNull
    private static final List<Pair<Matcher, LayoutManager.VerticalAlignment>> PLACEMENT_MATCHERS;

    public VerticalAlignmentResolver(@NotNull DoubleSpan myVerticalSpace) {
        Intrinsics.checkNotNullParameter((Object)myVerticalSpace, (String)"myVerticalSpace");
        this.myVerticalSpace = myVerticalSpace;
    }

    @NotNull
    public final LayoutManager.VerticalAlignment resolve(@NotNull DoubleSpan topPlacementRange, @NotNull DoubleSpan bottomPlacementRange, @NotNull LayoutManager.VerticalAlignment preferredPlacement, @NotNull DoubleSpan cursorRange) {
        Intrinsics.checkNotNullParameter((Object)topPlacementRange, (String)"topPlacementRange");
        Intrinsics.checkNotNullParameter((Object)bottomPlacementRange, (String)"bottomPlacementRange");
        Intrinsics.checkNotNullParameter((Object)((Object)preferredPlacement), (String)"preferredPlacement");
        Intrinsics.checkNotNullParameter((Object)cursorRange, (String)"cursorRange");
        Matcher currentState = new Matcher().topCursorOk(!topPlacementRange.connected(cursorRange)).topSpaceOk(this.myVerticalSpace.contains(topPlacementRange)).bottomCursorOk(!bottomPlacementRange.connected(cursorRange)).bottomSpaceOk(this.myVerticalSpace.contains(bottomPlacementRange)).preferredAlignment(preferredPlacement);
        for (Pair<Matcher, LayoutManager.VerticalAlignment> matcher : PLACEMENT_MATCHERS) {
            if (!((Matcher)matcher.getFirst()).match(currentState)) continue;
            return (LayoutManager.VerticalAlignment)((Object)matcher.getSecond());
        }
        throw new IllegalStateException("Some matcher should match");
    }

    static {
        Object[] objectArray = new Pair[]{VerticalAlignmentResolver.Companion.rule(new Matcher().preferredAlignment(LayoutManager.VerticalAlignment.TOP).topSpaceOk(true).topCursorOk(true), LayoutManager.VerticalAlignment.TOP), VerticalAlignmentResolver.Companion.rule(new Matcher().preferredAlignment(LayoutManager.VerticalAlignment.BOTTOM).bottomSpaceOk(true).bottomCursorOk(true), LayoutManager.VerticalAlignment.BOTTOM), VerticalAlignmentResolver.Companion.rule(new Matcher().preferredAlignment(LayoutManager.VerticalAlignment.TOP).topSpaceOk(true).topCursorOk(false).bottomSpaceOk(true).bottomCursorOk(true), LayoutManager.VerticalAlignment.BOTTOM), VerticalAlignmentResolver.Companion.rule(new Matcher().preferredAlignment(LayoutManager.VerticalAlignment.BOTTOM).bottomSpaceOk(true).bottomCursorOk(false).topSpaceOk(true).topCursorOk(true), LayoutManager.VerticalAlignment.TOP), VerticalAlignmentResolver.Companion.rule(new Matcher().topSpaceOk(false), LayoutManager.VerticalAlignment.BOTTOM), VerticalAlignmentResolver.Companion.rule(new Matcher().bottomSpaceOk(false), LayoutManager.VerticalAlignment.TOP), VerticalAlignmentResolver.Companion.rule(new Matcher(), LayoutManager.VerticalAlignment.TOP)};
        PLACEMENT_MATCHERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0007H\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver$Companion;", "", "()V", "PLACEMENT_MATCHERS", "", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver$Matcher;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$VerticalAlignment;", "rule", "condition", "result", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        private final Pair<Matcher, LayoutManager.VerticalAlignment> rule(Matcher condition, LayoutManager.VerticalAlignment result) {
            return new Pair((Object)condition, (Object)result);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\fJ*\u0010\u000e\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\u0015\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0016\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\fR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver$Matcher;", "", "()V", "myBottomCursorOk", "", "Ljava/lang/Boolean;", "myBottomSpaceOk", "myPreferredAlignment", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$VerticalAlignment;", "myTopCursorOk", "myTopSpaceOk", "bottomCursorOk", "(Ljava/lang/Boolean;)Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver$Matcher;", "bottomSpaceOk", "match", "T", "propertyGetter", "Lkotlin/Function1;", "actual", "other", "preferredAlignment", "topCursorOk", "topSpaceOk", "Companion", "plot-builder"})
    public static final class Matcher {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private Boolean myTopSpaceOk;
        @Nullable
        private Boolean myTopCursorOk;
        @Nullable
        private Boolean myBottomSpaceOk;
        @Nullable
        private Boolean myBottomCursorOk;
        @Nullable
        private LayoutManager.VerticalAlignment myPreferredAlignment;

        public final boolean match(@NotNull Matcher other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.match(match.1.INSTANCE, other) && this.match(match.2.INSTANCE, other) && this.match(match.3.INSTANCE, other) && this.match(match.4.INSTANCE, other) && this.match(match.5.INSTANCE, other);
        }

        @NotNull
        public final Matcher topSpaceOk(@Nullable Boolean topSpaceOk) {
            this.myTopSpaceOk = topSpaceOk;
            return this;
        }

        @NotNull
        public final Matcher topCursorOk(@Nullable Boolean topCursorOk) {
            this.myTopCursorOk = topCursorOk;
            return this;
        }

        @NotNull
        public final Matcher bottomSpaceOk(@Nullable Boolean bottomSpaceOk) {
            this.myBottomSpaceOk = bottomSpaceOk;
            return this;
        }

        @NotNull
        public final Matcher bottomCursorOk(@Nullable Boolean bottomCursorOk) {
            this.myBottomCursorOk = bottomCursorOk;
            return this;
        }

        @NotNull
        public final Matcher preferredAlignment(@NotNull LayoutManager.VerticalAlignment preferredAlignment) {
            Intrinsics.checkNotNullParameter((Object)((Object)preferredAlignment), (String)"preferredAlignment");
            this.myPreferredAlignment = preferredAlignment;
            return this;
        }

        private final <T> boolean match(Function1<? super Matcher, ? extends T> propertyGetter, Matcher actual) {
            Object object = propertyGetter.invoke((Object)this);
            if (object == null) {
                return true;
            }
            Object expected = object;
            return Intrinsics.areEqual((Object)expected, (Object)propertyGetter.invoke((Object)actual));
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver$Matcher$Companion;", "", "()V", "getBottomCursorOk", "", "matcher", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver$Matcher;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver$Matcher;)Ljava/lang/Boolean;", "getBottomSpaceOk", "getPreferredAlignment", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$VerticalAlignment;", "getTopCursorOk", "getTopSpaceOk", "plot-builder"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Boolean getTopSpaceOk(@NotNull Matcher matcher) {
                Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                return matcher.myTopSpaceOk;
            }

            @Nullable
            public final Boolean getTopCursorOk(@NotNull Matcher matcher) {
                Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                return matcher.myTopCursorOk;
            }

            @Nullable
            public final Boolean getBottomSpaceOk(@NotNull Matcher matcher) {
                Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                return matcher.myBottomSpaceOk;
            }

            @Nullable
            public final Boolean getBottomCursorOk(@NotNull Matcher matcher) {
                Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                return matcher.myBottomCursorOk;
            }

            @Nullable
            public final LayoutManager.VerticalAlignment getPreferredAlignment(@NotNull Matcher matcher) {
                Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
                return matcher.myPreferredAlignment;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

