/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.data;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.tooltip.MappedDataAccess;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TooltipLineSpec;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.TooltipFormatting;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.data.ValueSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0003J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/data/DataFrameField;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/data/ValueSource;", "name", "", "format", "(Ljava/lang/String;Ljava/lang/String;)V", "isAxis", "", "()Z", "isSide", "myDataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "myFormatter", "Lkotlin/Function1;", "", "myVariable", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "copy", "getAnnotationText", "index", "", "getDataPoint", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TooltipLineSpec$DataPoint;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "getVariableName", "initDataContext", "", "data", "mappedDataAccess", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/MappedDataAccess;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nDataFrameField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameField.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/data/DataFrameField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class DataFrameField
implements ValueSource {
    @NotNull
    private final String name;
    @Nullable
    private final String format;
    private DataFrame myDataFrame;
    private DataFrame.Variable myVariable;
    private Function1<Object, String> myFormatter;
    private final boolean isSide;
    private final boolean isAxis;

    public DataFrameField(@NotNull String name, @Nullable String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.format = format;
    }

    public /* synthetic */ DataFrameField(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Override
    public boolean isSide() {
        return this.isSide;
    }

    @Override
    public boolean isAxis() {
        return this.isAxis;
    }

    @Override
    public void initDataContext(@NotNull DataFrame data, @NotNull MappedDataAccess mappedDataAccess) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)mappedDataAccess, (String)"mappedDataAccess");
        if (!(this.myDataFrame == null)) {
            boolean bl = false;
            String string = "Data context can be initialized only once";
            throw new IllegalArgumentException(string.toString());
        }
        this.myDataFrame = data;
        DataFrame dataFrame = this.myDataFrame;
        if (dataFrame == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDataFrame");
            dataFrame = null;
        }
        this.myVariable = DataFrameUtil.INSTANCE.findVariableOrFail(dataFrame, this.name);
        if (this.format == null) {
            DataFrame.Variable variable = this.myVariable;
            if (variable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myVariable");
                variable = null;
            }
            function1 = TooltipFormatting.INSTANCE.createFormatter(variable);
        } else {
            function1 = (Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default((StringFormat.Companion)StringFormat.Companion, (String)this.format, null, (String)this.name, (int)2, null)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((StringFormat)this.receiver).format(p0);
                }
            };
        }
        this.myFormatter = function1;
    }

    @Override
    @Nullable
    public TooltipLineSpec.DataPoint getDataPoint(int index, @NotNull PlotContext ctx) {
        DataFrame.Variable variable;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        DataFrame dataFrame = this.myDataFrame;
        if (dataFrame == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDataFrame");
            dataFrame = null;
        }
        if ((variable = this.myVariable) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myVariable");
            variable = null;
        }
        Object e = dataFrame.get(variable).get(index);
        if (e == null) {
            return null;
        }
        Object originalValue = e;
        Function1<Object, String> function1 = this.myFormatter;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myFormatter");
            function1 = null;
        }
        return new TooltipLineSpec.DataPoint(this.name, (String)function1.invoke(originalValue), null, false, false);
    }

    @Override
    @NotNull
    public DataFrameField copy() {
        return new DataFrameField(this.name, this.format);
    }

    @NotNull
    public final String getVariableName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getAnnotationText(int index) {
        DataFrame.Variable variable;
        DataFrame dataFrame = this.myDataFrame;
        if (dataFrame == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDataFrame");
            dataFrame = null;
        }
        if ((variable = this.myVariable) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myVariable");
            variable = null;
        }
        Object e = dataFrame.get(variable).get(index);
        if (e == null) {
            return null;
        }
        Object originalValue = e;
        Function1<Object, String> function1 = this.myFormatter;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myFormatter");
            function1 = null;
        }
        return (String)function1.invoke(originalValue);
    }
}

