/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.intern.observable.property.WritableProperty;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.component.RetainableComponents;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.component.TooltipBox;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.spec.TooltipSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathData;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformable;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 22\u00020\u0001:\u000523456B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0014J(\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J\u0081\u0001\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020\r2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020#0(2\b\b\u0002\u00100\u001a\u00020#\u00a2\u0006\u0002\u00101R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "()V", "contentRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getContentRect", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "myContentBox", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$ContentBox;", "myDebugRectangles", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/RetainableComponents;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Companion$RectangleComponent;", "myHorizontalContentPadding", "", "myPointerBox", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerBox;", "myVerticalContentPadding", "myYPositionsBetweenLines", "", "pointerDirection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerDirection;", "getPointerDirection$plot_builder", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerDirection;", "buildComponent", "", "setPosition", "tooltipCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "pointerCoord", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Orientation;", "rotate", "", "update", "fillColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "textColor", "borderColor", "strokeWidth", "lines", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec$Line;", "title", "", "textClassName", "tooltipMinWidth", "borderRadius", "markerColors", "pointMarkerStrokeColor", "(Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/commons/values/Color;DLjava/util/List;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Double;DLjava/util/List;Lorg/jetbrains/letsPlot/commons/values/Color;)V", "Companion", "ContentBox", "Orientation", "PointerBox", "PointerDirection", "plot-builder"})
public final class TooltipBox
extends SvgComponent {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final PointerBox myPointerBox = new PointerBox();
    @NotNull
    private final ContentBox myContentBox = new ContentBox();
    private double myHorizontalContentPadding = 6.0;
    private double myVerticalContentPadding = 6.0;
    @NotNull
    private final List<Double> myYPositionsBetweenLines = new ArrayList();
    @NotNull
    private final RetainableComponents<Companion.RectangleComponent> myDebugRectangles = new RetainableComponents(myDebugRectangles.1.INSTANCE, (SvgNode)this.getRootGroup());
    private static final boolean DEBUG_DRAWING = false;
    @NotNull
    private static final List<DoubleVector> TRIANGLE_POINTS;

    @NotNull
    public final DoubleRectangle getContentRect() {
        return DoubleRectangle.Companion.span(DoubleVector.Companion.getZERO(), this.myContentBox.getDimension());
    }

    @Nullable
    public final PointerDirection getPointerDirection$plot_builder() {
        return this.myPointerBox.getPointerDirection();
    }

    protected void buildComponent() {
        this.add(this.myPointerBox);
        this.add(this.myContentBox);
    }

    public final void update(@NotNull Color fillColor, @Nullable Color textColor, @NotNull Color borderColor, double strokeWidth, @NotNull List<TooltipSpec.Line> lines, @Nullable String title, @NotNull String textClassName, boolean rotate, @Nullable Double tooltipMinWidth, double borderRadius, @NotNull List<Color> markerColors, @NotNull Color pointMarkerStrokeColor) {
        Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
        Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)textClassName, (String)"textClassName");
        Intrinsics.checkNotNullParameter(markerColors, (String)"markerColors");
        Intrinsics.checkNotNullParameter((Object)pointMarkerStrokeColor, (String)"pointMarkerStrokeColor");
        int totalLines = lines.size() + (title != null ? 1 : 0);
        this.myHorizontalContentPadding = totalLines > 1 ? 10.0 : 6.0;
        this.myVerticalContentPadding = totalLines > 1 ? 10.0 : 6.0;
        this.myYPositionsBetweenLines.clear();
        this.myContentBox.update(lines, title, textColor, tooltipMinWidth, rotate, markerColors, textClassName);
        this.myPointerBox.updateStyle(fillColor, borderColor, strokeWidth, borderRadius, pointMarkerStrokeColor);
    }

    public static /* synthetic */ void update$default(TooltipBox tooltipBox, Color color, Color color2, Color color3, double d, List list, String string, String string2, boolean bl, Double d2, double d3, List list2, Color color4, int n, Object object) {
        if ((n & 0x100) != 0) {
            d2 = null;
        }
        if ((n & 0x800) != 0) {
            color4 = color3;
        }
        tooltipBox.update(color, color2, color3, d, list, string, string2, bl, d2, d3, list2, color4);
    }

    public final void setPosition(@NotNull DoubleVector tooltipCoord, @NotNull DoubleVector pointerCoord, @NotNull Orientation orientation, boolean rotate) {
        Intrinsics.checkNotNullParameter((Object)tooltipCoord, (String)"tooltipCoord");
        Intrinsics.checkNotNullParameter((Object)pointerCoord, (String)"pointerCoord");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        double rotationAngle = rotate ? 15.0 : 0.0;
        this.rotate(rotationAngle);
        DoubleVector p = pointerCoord.subtract(tooltipCoord).rotate(MathKt.toRadians((double)(-rotationAngle)));
        this.myPointerBox.update(p, orientation, rotate);
        this.moveTo(tooltipCoord);
    }

    public static /* synthetic */ void setPosition$default(TooltipBox tooltipBox, DoubleVector doubleVector, DoubleVector doubleVector2, Orientation orientation, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        tooltipBox.setPosition(doubleVector, doubleVector2, orientation, bl);
    }

    static {
        Companion $this$TRIANGLE_POINTS_u24lambda_u240 = Companion = new Companion(null);
        boolean bl = false;
        double size = 8.0;
        double height = size + 1.0;
        Object[] objectArray = new DoubleVector[]{new DoubleVector(0.0, 0.0), new DoubleVector(size / (double)2, height), new DoubleVector(-size / (double)2, height)};
        TRIANGLE_POINTS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u0006*\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J?\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0006*\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\u0010\u001a\u00020\f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u0012\u00a2\u0006\u0002\b\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Companion;", "", "()V", "DEBUG_DRAWING", "", "TRIANGLE_POINTS", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "wrap", "", "value", "maxLength", "", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/String;", "chunkedBy", "delimiter", "maxSize", "size", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "RectangleComponent", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nTooltipBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipBox.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,760:1\n1360#2:761\n1446#2,5:762\n1549#2:767\n1620#2,3:768\n1855#2,2:771\n*S KotlinDebug\n*F\n+ 1 TooltipBox.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Companion\n*L\n716#1:761\n716#1:762,5\n727#1:767\n727#1:768,3\n734#1:771,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String wrap(String value, Integer maxLength) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = MultilineLabel.Companion.splitLines(value);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String line2 = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = maxLength != null ? Companion.chunkedBy(line2, " ", maxLength) : CollectionsKt.listOf((Object)line2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> chunkedBy(String $this$chunkedBy, String delimiter, int maxLength) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{delimiter};
            object = this.chunkedBy(StringsKt.split$default((CharSequence)$this$chunkedBy, (String[])object, (boolean)false, (int)0, (int)6, null), maxLength + delimiter.length(), (Function1<? super String, Integer>)((Function1)new Function1<String, Integer>(delimiter){
                final /* synthetic */ String $delimiter;
                {
                    this.$delimiter = $delimiter;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull String $this$chunkedBy) {
                    Intrinsics.checkNotNullParameter((Object)$this$chunkedBy, (String)"$this$chunkedBy");
                    return $this$chunkedBy.length() + this.$delimiter.length();
                }
            }));
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CollectionsKt.joinToString$default((Iterable)((Iterable)it), (CharSequence)delimiter, null, null, (int)0, null, null, (int)62, null));
            }
            return (List)destination$iv$iv;
        }

        private final List<List<String>> chunkedBy(List<String> $this$chunkedBy, int maxSize, Function1<? super String, Integer> size) {
            List result = new ArrayList();
            List subList = null;
            subList = new ArrayList();
            int subListSize = 0;
            Iterable $this$forEach$iv = $this$chunkedBy;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String item = (String)element$iv;
                boolean bl = false;
                int itemSize = ((Number)size.invoke((Object)item)).intValue();
                if (subListSize + itemSize > maxSize && !((Collection)subList).isEmpty()) {
                    result.add(subList);
                    subList = new ArrayList();
                    subListSize = 0;
                }
                subList.add(item);
                subListSize += itemSize;
            }
            if (!((Collection)subList).isEmpty()) {
                ((Collection)result).add(subList);
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J.\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Companion$RectangleComponent;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "()V", "myRect", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathElement;", "buildComponent", "", "update", "x", "", "y", "w", "h", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "plot-builder"})
        public static final class RectangleComponent
        extends SvgComponent {
            @NotNull
            private final SvgPathElement myRect = new SvgPathElement();

            public RectangleComponent() {
                this.myRect.strokeWidth().set((Object)1.0);
                this.myRect.fillOpacity().set((Object)0.0);
            }

            protected void buildComponent() {
                this.add((SvgNode)this.myRect);
            }

            public final void update(double x, double y, double w, double h, @NotNull Color color) {
                SvgPathDataBuilder svgPathDataBuilder;
                Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                SvgPathDataBuilder $this$update_u24lambda_u240 = svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
                boolean bl = false;
                SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$update_u24lambda_u240, (double)x, (double)y, (boolean)false, (int)4, null);
                SvgPathDataBuilder.horizontalLineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u240, (double)w, (boolean)false, (int)2, null);
                SvgPathDataBuilder.verticalLineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u240, (double)h, (boolean)false, (int)2, null);
                SvgPathDataBuilder.horizontalLineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u240, (double)x, (boolean)false, (int)2, null);
                SvgPathDataBuilder.verticalLineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u240, (double)y, (boolean)false, (int)2, null);
                SvgPathData pathData = svgPathDataBuilder.build();
                this.myRect.d().set((Object)pathData);
                this.myRect.strokeColor().set((Object)color);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0016\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0011J%\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0002\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001fH\u0002J\u0016\u0010(\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u0002J?\u0010)\u001a\u00020\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\n2\b\u0010,\u001a\u0004\u0018\u00010\u00142\b\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u00101J\"\u00102\u001a\u00020\u00062\b\u00103\u001a\u0004\u0018\u00010%2\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020#H\u0002JU\u00106\u001a\u00020\u00112\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\n2\b\u00107\u001a\u0004\u0018\u00010\u001f2\b\u0010,\u001a\u0004\u0018\u00010\u00142\b\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010.\u001a\u00020/2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u00100\u001a\u00020\u001f\u00a2\u0006\u0002\u00108R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$ContentBox;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox;)V", "colorBarIndent", "", "dimension", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getDimension", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "myColorBars", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathElement;", "myContent", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "myLinesContainer", "myTitleContainer", "buildComponent", "", "calculateColorBarIndent", "markerColors", "Lorg/jetbrains/letsPlot/commons/values/Color;", "colorBarsWidth", "barsNum", "", "drawDebugRect", "drawLineSeparators", "yTitleLinePosition", "yPositionsBetweenLines", "(Ljava/lang/Double;Ljava/util/List;)V", "estimateLineHeight", "line", "", "className", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Double;", "getBBox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "textLabel", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel;", "initTitleComponent", "titleLine", "layoutColorBars", "layoutLines", "lines", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec$Line;", "valueTextColor", "tooltipMinWidth", "rotate", "", "textClassName", "(Ljava/util/List;Lorg/jetbrains/letsPlot/commons/values/Color;Ljava/lang/Double;ZLjava/lang/String;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "layoutTitle", "titleComponent", "totalTooltipWidth", "titleBBox", "update", "title", "(Ljava/util/List;Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/values/Color;Ljava/lang/Double;ZLjava/util/List;Ljava/lang/String;)V", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nTooltipBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipBox.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$ContentBox\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,760:1\n1#2:761\n1#2:785\n1#2:793\n1#2:795\n1#2:801\n1855#3,2:762\n1855#3,2:764\n766#3:766\n857#3,2:767\n1855#3,2:769\n1549#3:771\n1620#3,3:772\n1603#3,9:775\n1855#3:784\n1856#3:786\n1612#3:787\n1549#3:788\n1620#3,3:789\n2634#3:792\n2634#3:794\n1549#3:796\n1620#3,3:797\n2634#3:800\n1549#3:802\n1620#3,3:803\n1549#3:806\n1620#3,3:807\n1549#3:810\n1620#3,3:811\n1549#3:814\n1620#3,3:815\n1789#3,3:818\n1549#3:821\n1620#3,3:822\n1855#3,2:825\n*S KotlinDebug\n*F\n+ 1 TooltipBox.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$ContentBox\n*L\n454#1:785\n496#1:793\n503#1:795\n518#1:801\n301#1:762,2\n401#1:764,2\n413#1:766\n413#1:767,2\n414#1:769,2\n453#1:771\n453#1:772,3\n454#1:775,9\n454#1:784\n454#1:786\n454#1:787\n489#1:788\n489#1:789,3\n496#1:792\n503#1:794\n510#1:796\n510#1:797,3\n518#1:800\n524#1:802\n524#1:803,3\n532#1:806\n532#1:807,3\n551#1:810\n551#1:811,3\n560#1:814\n560#1:815,3\n585#1:818,3\n657#1:821\n657#1:822,3\n665#1:825,2\n*E\n"})
    private final class ContentBox
    extends SvgComponent {
        @NotNull
        private final SvgSvgElement myTitleContainer;
        @NotNull
        private final SvgSvgElement myLinesContainer;
        @NotNull
        private final SvgSvgElement myContent;
        @NotNull
        private final List<SvgPathElement> myColorBars;
        private double colorBarIndent;

        /*
         * WARNING - void declaration
         */
        public ContentBox() {
            void $this$myContent_u24lambda_u242;
            SvgSvgElement $this$myLinesContainer_u24lambda_u241;
            SvgSvgElement $this$myTitleContainer_u24lambda_u240;
            SvgSvgElement svgSvgElement = new SvgSvgElement();
            Object object = svgSvgElement;
            ContentBox contentBox = this;
            boolean bl = false;
            $this$myTitleContainer_u24lambda_u240.x().set((Object)0.0);
            $this$myTitleContainer_u24lambda_u240.y().set((Object)0.0);
            $this$myTitleContainer_u24lambda_u240.width().set((Object)0.0);
            $this$myTitleContainer_u24lambda_u240.height().set((Object)0.0);
            contentBox.myTitleContainer = svgSvgElement;
            $this$myTitleContainer_u24lambda_u240 = svgSvgElement = new SvgSvgElement();
            contentBox = this;
            boolean bl2 = false;
            $this$myLinesContainer_u24lambda_u241.x().set((Object)0.0);
            $this$myLinesContainer_u24lambda_u241.y().set((Object)0.0);
            $this$myLinesContainer_u24lambda_u241.width().set((Object)0.0);
            $this$myLinesContainer_u24lambda_u241.height().set((Object)0.0);
            contentBox.myLinesContainer = svgSvgElement;
            $this$myLinesContainer_u24lambda_u241 = svgSvgElement = new SvgSvgElement();
            contentBox = this;
            boolean bl3 = false;
            $this$myContent_u24lambda_u242.x().set((Object)0.0);
            $this$myContent_u24lambda_u242.y().set((Object)0.0);
            $this$myContent_u24lambda_u242.width().set((Object)0.0);
            $this$myContent_u24lambda_u242.height().set((Object)0.0);
            contentBox.myContent = svgSvgElement;
            int n = 3;
            contentBox = this;
            object = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                Object object2 = object;
                boolean bl4 = false;
                ((ArrayList)object2).add(new SvgPathElement());
            }
            contentBox.myColorBars = (List)object;
        }

        @NotNull
        public final DoubleVector getDimension() {
            SvgSvgElement $this$_get_dimension__u24lambda_u244 = this.myContent;
            boolean bl = false;
            Object object = $this$_get_dimension__u24lambda_u244.width().get();
            Intrinsics.checkNotNull((Object)object);
            double d = ((Number)object).doubleValue();
            Object object2 = $this$_get_dimension__u24lambda_u244.height().get();
            Intrinsics.checkNotNull((Object)object2);
            return new DoubleVector(d, ((Number)object2).doubleValue());
        }

        protected void buildComponent() {
            this.add((SvgNode)this.myContent);
            this.myContent.children().add((Object)this.myTitleContainer);
            this.myContent.children().add((Object)this.myLinesContainer);
            Iterable $this$forEach$iv = this.myColorBars;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgPathElement it = (SvgPathElement)element$iv;
                boolean bl = false;
                this.add((SvgNode)it);
            }
        }

        public final void update(@NotNull List<TooltipSpec.Line> lines, @Nullable String title, @Nullable Color valueTextColor, @Nullable Double tooltipMinWidth, boolean rotate, @NotNull List<Color> markerColors, @NotNull String textClassName) {
            DoubleRectangle doubleRectangle;
            MultilineLabel titleComponent;
            MultilineLabel multilineLabel;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(markerColors, (String)"markerColors");
            Intrinsics.checkNotNullParameter((Object)textClassName, (String)"textClassName");
            this.myLinesContainer.children().clear();
            this.myTitleContainer.children().clear();
            this.calculateColorBarIndent(markerColors);
            String string = title;
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                multilineLabel = this.initTitleComponent(p0);
            } else {
                multilineLabel = titleComponent = null;
            }
            if ((doubleRectangle = this.getBBox(titleComponent)) == null) {
                doubleRectangle = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
            }
            DoubleRectangle rawTitleBBox = doubleRectangle;
            Object[] bl = new Double[]{tooltipMinWidth, rawTitleBBox.getWidth()};
            Double minWidthWithTitle = CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])bl));
            DoubleVector textSize = this.layoutLines(lines, valueTextColor, minWidthWithTitle, rotate, textClassName);
            double totalTooltipWidth = textSize.getX() + this.colorBarIndent + TooltipBox.this.myHorizontalContentPadding * (double)2;
            DoubleVector titleTextSize = this.layoutTitle(titleComponent, totalTooltipWidth, rawTitleBBox);
            SvgSvgElement svgSvgElement = this.myTitleContainer;
            TooltipBox tooltipBox = TooltipBox.this;
            SvgSvgElement $this$update_u24lambda_u246 = svgSvgElement;
            boolean bl2 = false;
            if (titleComponent != null) {
                $this$update_u24lambda_u246.x().set((Object)0.0);
                $this$update_u24lambda_u246.y().set((Object)tooltipBox.myVerticalContentPadding);
                $this$update_u24lambda_u246.width().set((Object)totalTooltipWidth);
                $this$update_u24lambda_u246.height().set((Object)titleTextSize.getY());
            }
            svgSvgElement = this.myLinesContainer;
            tooltipBox = TooltipBox.this;
            SvgSvgElement $this$update_u24lambda_u247 = svgSvgElement;
            boolean bl3 = false;
            $this$update_u24lambda_u247.x().set((Object)(tooltipBox.myHorizontalContentPadding + this.colorBarIndent));
            $this$update_u24lambda_u247.y().set((Object)(titleTextSize.getY() + tooltipBox.myVerticalContentPadding));
            $this$update_u24lambda_u247.width().set((Object)(totalTooltipWidth - tooltipBox.myHorizontalContentPadding));
            $this$update_u24lambda_u247.height().set((Object)(textSize.getY() + titleTextSize.getY() + tooltipBox.myVerticalContentPadding));
            svgSvgElement = this.myContent;
            tooltipBox = TooltipBox.this;
            SvgSvgElement $this$update_u24lambda_u248 = svgSvgElement;
            boolean bl4 = false;
            $this$update_u24lambda_u248.width().set((Object)totalTooltipWidth);
            $this$update_u24lambda_u248.height().set((Object)(textSize.getY() + titleTextSize.getY() + tooltipBox.myVerticalContentPadding * (double)2));
            this.layoutColorBars(markerColors);
            this.drawLineSeparators(titleComponent != null ? Double.valueOf(titleTextSize.getY() - TooltipBox.this.myVerticalContentPadding / (double)2) : null, TooltipBox.this.myYPositionsBetweenLines);
        }

        private final List<Double> colorBarsWidth(int barsNum) {
            Double d = 4.0;
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            Double d2 = barsNum > 0 ? d : null;
            double middleBarWidth = d2 != null ? d2 : 0.0;
            Double d3 = 1.5;
            double it2 = ((Number)d3).doubleValue();
            boolean bl2 = false;
            Double d4 = barsNum > 1 ? d3 : null;
            double strokeBarWidth = d4 != null ? d4 : 0.0;
            Object[] objectArray = new Double[]{strokeBarWidth, middleBarWidth, strokeBarWidth};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        /*
         * WARNING - void declaration
         */
        private final void calculateColorBarIndent(List<Color> markerColors) {
            void colorBarNums;
            int n = Math.min(this.myColorBars.size(), markerColors.size());
            TooltipBox tooltipBox = TooltipBox.this;
            int n2 = n;
            ContentBox contentBox = this;
            boolean bl = false;
            double width = CollectionsKt.sumOfDouble((Iterable)this.colorBarsWidth((int)colorBarNums));
            boolean bl2 = false;
            double d = !(width == 0.0) ? width + tooltipBox.myHorizontalContentPadding : 0.0;
            contentBox.colorBarIndent = d;
        }

        /*
         * WARNING - void declaration
         */
        private final void layoutColorBars(List<Color> markerColors) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object element$iv2;
            void $this$forEach$iv2;
            Color fillColor = (Color)CollectionsKt.firstOrNull(markerColors);
            Color strokeColor = markerColors.size() > 1 ? markerColors.get(1) : null;
            Object object = new Color[]{strokeColor, fillColor, strokeColor};
            object = CollectionsKt.zip((Iterable)this.myColorBars, (Iterable)CollectionsKt.listOf((Object[])object));
            boolean $i$f$forEach22 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair pair = (Pair)element$iv2;
                boolean bl = false;
                SvgPathElement bar2 = (SvgPathElement)pair.component1();
                Color color = (Color)pair.component2();
                if (color == null) {
                    bar2.fillOpacity().set((Object)0.0);
                    continue;
                }
                bar2.fillOpacity().set((Object)1.0);
                bar2.fillColor().set((Object)color);
            }
            double x = 0.0;
            x = TooltipBox.this.getContentRect().getLeft() + TooltipBox.this.myHorizontalContentPadding;
            Iterable $i$f$forEach22 = CollectionsKt.zip((Iterable)this.myColorBars, (Iterable)this.colorBarsWidth(markerColors.size()));
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair pair = (Pair)element$iv$iv;
                boolean bl = false;
                SvgPathElement bar3 = (SvgPathElement)pair.component1();
                Object object2 = bar3.fillOpacity().get();
                Intrinsics.checkNotNull((Object)object2);
                if (!(((Number)object2).doubleValue() > 0.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                void $this$layoutColorBars_u24lambda_u2416_u24lambda_u2415;
                SvgPathDataBuilder svgPathDataBuilder;
                Pair pair = (Pair)element$iv3;
                boolean bl = false;
                SvgPathElement bar4 = (SvgPathElement)pair.component1();
                double width = ((Number)pair.component2()).doubleValue();
                SvgPathDataBuilder svgPathDataBuilder2 = svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
                Property property = bar4.d();
                boolean bl2 = false;
                Object object3 = this.myLinesContainer.y().get();
                Intrinsics.checkNotNull((Object)object3);
                double y = ((Number)object3).doubleValue();
                Object object4 = this.myLinesContainer.height().get();
                Intrinsics.checkNotNull((Object)object4);
                double bottom = ((Number)object4).doubleValue();
                SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$layoutColorBars_u24lambda_u2416_u24lambda_u2415, (double)x, (double)y, (boolean)false, (int)4, null);
                SvgPathDataBuilder.horizontalLineTo$default((SvgPathDataBuilder)$this$layoutColorBars_u24lambda_u2416_u24lambda_u2415, (double)(x + width), (boolean)false, (int)2, null);
                SvgPathDataBuilder.verticalLineTo$default((SvgPathDataBuilder)$this$layoutColorBars_u24lambda_u2416_u24lambda_u2415, (double)bottom, (boolean)false, (int)2, null);
                SvgPathDataBuilder.horizontalLineTo$default((SvgPathDataBuilder)$this$layoutColorBars_u24lambda_u2416_u24lambda_u2415, (double)x, (boolean)false, (int)2, null);
                SvgPathDataBuilder.verticalLineTo$default((SvgPathDataBuilder)$this$layoutColorBars_u24lambda_u2416_u24lambda_u2415, (double)y, (boolean)false, (int)2, null);
                property.set((Object)svgPathDataBuilder.build());
                x += width;
            }
        }

        private final DoubleRectangle getBBox(MultilineLabel textLabel) {
            if (textLabel == null || StringsKt.isBlank((CharSequence)textLabel.getText())) {
                return null;
            }
            return textLabel.getRootGroup().getBBox();
        }

        private final MultilineLabel initTitleComponent(String titleLine) {
            MultilineLabel titleComponent = new MultilineLabel(Companion.wrap(titleLine, null));
            titleComponent.addClassName("tooltip-title");
            titleComponent.setHorizontalAnchor(Text.HorizontalAnchor.MIDDLE);
            Double d = this.estimateLineHeight(titleLine, "tooltip-title");
            double lineHeight = d != null ? d : 0.0;
            titleComponent.setLineHeight(lineHeight + 3.0);
            this.myTitleContainer.children().add((Object)titleComponent.getRootGroup());
            return titleComponent;
        }

        /*
         * WARNING - void declaration
         */
        private final Double estimateLineHeight(String line2, String className) {
            Double d;
            String[] stringArray;
            List list;
            if (line2 != null && (list = StringsKt.split$default((CharSequence)line2, (String[])(stringArray = new String[]{"\n"}), (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list;
                boolean $i$f$map22 = false;
                void var7_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MultilineLabel multilineLabel;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    MultilineLabel $this$estimateLineHeight_u24lambda_u2418_u24lambda_u2417 = multilineLabel = new MultilineLabel((String)it);
                    boolean bl2 = false;
                    $this$estimateLineHeight_u24lambda_u2418_u24lambda_u2417.addClassName(className);
                    collection.add(multilineLabel);
                }
                Iterable $i$f$map22 = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Double it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    MultilineLabel lineTextLabel = (MultilineLabel)element$iv$iv;
                    boolean bl3 = false;
                    ObservableList $this$estimateLineHeight_u24lambda_u2420_u24lambda_u2419 = this.myLinesContainer.children();
                    boolean bl4 = false;
                    $this$estimateLineHeight_u24lambda_u2420_u24lambda_u2419.add((Object)lineTextLabel.getRootGroup());
                    DoubleRectangle doubleRectangle = this.getBBox(lineTextLabel);
                    Double height = doubleRectangle != null ? Double.valueOf(doubleRectangle.getHeight()) : null;
                    $this$estimateLineHeight_u24lambda_u2420_u24lambda_u2419.remove((Object)lineTextLabel.getRootGroup());
                    if (height == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                d = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
            } else {
                d = null;
            }
            return d;
        }

        private final DoubleVector layoutTitle(MultilineLabel titleComponent, double totalTooltipWidth, DoubleRectangle titleBBox) {
            if (titleComponent == null) {
                return DoubleVector.Companion.getZERO();
            }
            titleComponent.setX(totalTooltipWidth / (double)2);
            titleComponent.setY(-titleBBox.getTop());
            return new DoubleVector(totalTooltipWidth, TooltipBox.this.myVerticalContentPadding + titleBBox.getHeight());
        }

        /*
         * WARNING - void declaration
         */
        private final DoubleVector layoutLines(List<TooltipSpec.Line> lines, Color valueTextColor, Double tooltipMinWidth, boolean rotate, String textClassName) {
            void $this$fold$iv;
            void initial$iv;
            DoubleVector $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$mapTo$iv$iv3;
            double $i$a$-onEach-TooltipBox$ContentBox$layoutLines$42;
            DoubleRectangle labelBbox;
            void $this$mapTo$iv$iv4;
            MultilineLabel valueComponent;
            Iterable $this$mapTo$iv$iv5;
            Object[] objectArray;
            Pair line2;
            Collection collection;
            Iterable $this$mapTo$iv$iv6;
            void $this$map$iv;
            Iterable iterable = lines;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv6) {
                MultilineLabel multilineLabel;
                TooltipSpec.Line line3 = (TooltipSpec.Line)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                if (line2.getLabel() != null) {
                    String it;
                    boolean bl2 = false;
                    multilineLabel = new MultilineLabel(Companion.wrap(it, null));
                } else {
                    multilineLabel = null;
                }
                MultilineLabel multilineLabel2 = new MultilineLabel(Companion.wrap(line2.getValue(), 30));
                MultilineLabel multilineLabel3 = multilineLabel;
                collection.add(new Pair((Object)multilineLabel3, (Object)multilineLabel2));
            }
            List components = (List)destination$iv$iv;
            Iterable $this$onEach$iv = components;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2416$iv = $this$mapTo$iv$iv6 = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                line2 = (Pair)element$iv;
                boolean bl3 = false;
                MultilineLabel labelComponent = (MultilineLabel)line2.component1();
                if (labelComponent == null) continue;
                labelComponent.addClassName("tooltip-label");
                this.myLinesContainer.children().add((Object)labelComponent.getRootGroup());
            }
            $this$onEach$iv = components;
            $i$f$onEach = false;
            $this$onEach_u24lambda_u2416$iv = $this$mapTo$iv$iv6 = $this$onEach$iv;
            bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                Unit unit;
                line2 = (Pair)element$iv;
                boolean bl4 = false;
                MultilineLabel valueComponent2 = (MultilineLabel)line2.component2();
                valueComponent2.addClassName(textClassName);
                if (valueTextColor != null) {
                    objectArray = valueTextColor;
                    WritableProperty writableProperty = valueComponent2.textColor();
                    Object[] p0 = objectArray;
                    boolean bl5 = false;
                    writableProperty.set((Object)p0);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.myLinesContainer.children().add((Object)valueComponent2.getRootGroup());
            }
            Iterable $this$map$iv2 = lines;
            boolean $i$f$map2 = false;
            $this$onEach_u24lambda_u2416$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                void line4;
                TooltipSpec.Line bl4 = (TooltipSpec.Line)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl6 = false;
                objectArray = new Double[]{this.estimateLineHeight(line4.getLabel(), "tooltip-label"), this.estimateLineHeight(line4.getValue(), textClassName)};
                Double d = CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
                collection.add(d != null ? d : 0.0);
            }
            List lineHeights = (List)destination$iv$iv2;
            Iterable $this$onEach$iv2 = CollectionsKt.zip((Iterable)lineHeights, (Iterable)components);
            boolean $i$f$onEach2 = false;
            Iterable $this$onEach_u24lambda_u2416$iv2 = $this$mapTo$iv$iv5 = $this$onEach$iv2;
            $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv2) {
                Unit unit;
                Pair line4 = (Pair)element$iv;
                boolean $i$a$-onEach-TooltipBox$ContentBox$layoutLines$42 = false;
                double height = ((Number)line4.component1()).doubleValue();
                Pair component = (Pair)line4.component2();
                MultilineLabel labelComponent = (MultilineLabel)component.component1();
                valueComponent = (MultilineLabel)component.component2();
                MultilineLabel multilineLabel = labelComponent;
                if (multilineLabel != null) {
                    multilineLabel.setLineHeight(height + 3.0);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                valueComponent.setLineHeight(height + 3.0);
            }
            Iterable $this$map$iv3 = components;
            boolean $i$f$map3 = false;
            $this$onEach_u24lambda_u2416$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo222 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                Pair $i$a$-onEach-TooltipBox$ContentBox$layoutLines$42 = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl7 = false;
                MultilineLabel label = (MultilineLabel)$i$a$-onEach-TooltipBox$ContentBox$layoutLines$42.component1();
                MultilineLabel value = (MultilineLabel)$i$a$-onEach-TooltipBox$ContentBox$layoutLines$42.component2();
                collection.add(TuplesKt.to((Object)this.getBBox(label), (Object)this.getBBox(value)));
            }
            List rawBBoxes = (List)destination$iv$iv3;
            Iterator iterator = ((Iterable)rawBBoxes).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Pair $i$f$mapTo222 = (Pair)iterator.next();
            boolean bl8 = false;
            DoubleRectangle doubleRectangle = labelBbox = (DoubleRectangle)$i$f$mapTo222.component1();
            double d = $i$a$-onEach-TooltipBox$ContentBox$layoutLines$42 = doubleRectangle != null ? doubleRectangle.getWidth() : 0.0;
            while (iterator.hasNext()) {
                DoubleRectangle labelBbox2;
                labelBbox = (Pair)iterator.next();
                $i$a$-maxOf-TooltipBox$ContentBox$layoutLines$maxLabelWidth$1 = false;
                DoubleRectangle doubleRectangle2 = labelBbox2 = (DoubleRectangle)labelBbox.component1();
                double labelComponent = doubleRectangle2 != null ? doubleRectangle2.getWidth() : 0.0;
                $i$a$-onEach-TooltipBox$ContentBox$layoutLines$42 = Math.max($i$a$-onEach-TooltipBox$ContentBox$layoutLines$42, labelComponent);
            }
            double maxLabelWidth = $i$a$-onEach-TooltipBox$ContentBox$layoutLines$42;
            Double d2 = CollectionsKt.maxOrNull((Iterable)lineHeights);
            double defaultLineHeight = d2 != null ? d2 : 0.0;
            Iterable $this$map$iv4 = CollectionsKt.zip((Iterable)lines, (Iterable)components);
            boolean $i$f$map4 = false;
            Iterable $i$a$-onEach-TooltipBox$ContentBox$layoutLines$42 = $this$map$iv4;
            Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                double d3;
                valueComponent = (Pair)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl9 = false;
                TooltipSpec.Line line5 = (TooltipSpec.Line)valueComponent.component1();
                Pair component = (Pair)valueComponent.component2();
                if (line5.getLabel() == null) {
                    d3 = 0.0;
                } else {
                    String string = line5.getLabel();
                    Intrinsics.checkNotNull((Object)string);
                    d3 = ((CharSequence)string).length() == 0 && ((MultilineLabel)component.getSecond()).linesCount() == 1 ? maxLabelWidth : maxLabelWidth + 8.0;
                }
                collection.add(d3);
            }
            List labelWidths = (List)destination$iv$iv4;
            Iterable $this$map$iv5 = rawBBoxes;
            boolean $i$f$map5 = false;
            destination$iv$iv4 = $this$map$iv5;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo322 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair bl9 = (Pair)item$iv$iv;
                collection = destination$iv$iv5;
                boolean bl10 = false;
                DoubleRectangle valueBBox = (DoubleRectangle)bl9.component2();
                DoubleRectangle doubleRectangle3 = valueBBox;
                collection.add(doubleRectangle3 != null && (doubleRectangle3 = doubleRectangle3.getDimension()) != null ? doubleRectangle3.getX() : 0.0);
            }
            List valueWidths = (List)destination$iv$iv5;
            List lineWidths = CollectionsKt.zip((Iterable)labelWidths, (Iterable)valueWidths);
            Iterator $i$f$mapTo322 = ((Iterable)lineWidths).iterator();
            if (!$i$f$mapTo322.hasNext()) {
                throw new NoSuchElementException();
            }
            Pair item$iv$iv = (Pair)$i$f$mapTo322.next();
            boolean $i$a$-maxOf-TooltipBox$ContentBox$layoutLines$maxLineWidth$22 = false;
            double labelWidth = ((Number)item$iv$iv.component1()).doubleValue();
            double valueWidth = ((Number)item$iv$iv.component2()).doubleValue();
            Double d4 = tooltipMinWidth;
            double d5 = Math.max(d4 != null ? d4 : 0.0, labelWidth + valueWidth);
            while ($i$f$mapTo322.hasNext()) {
                Pair pair = (Pair)$i$f$mapTo322.next();
                $i$a$-maxOf-TooltipBox$ContentBox$layoutLines$maxLineWidth$1 = false;
                double labelWidth2 = ((Number)pair.component1()).doubleValue();
                double valueWidth2 = ((Number)pair.component2()).doubleValue();
                Double d6 = tooltipMinWidth;
                labelWidth = Math.max(d6 != null ? d6 : 0.0, labelWidth2 + valueWidth2);
                d5 = Math.max(d5, labelWidth);
            }
            double maxLineWidth = d5;
            Iterable $this$map$iv6 = CollectionsKt.zip((Iterable)rawBBoxes, (Iterable)lineWidths);
            boolean $i$f$map222 = false;
            Iterable $i$a$-maxOf-TooltipBox$ContentBox$layoutLines$maxLineWidth$22 = $this$map$iv6;
            Object destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                double d7;
                double d8;
                double d9;
                double d10;
                Pair pair = (Pair)item$iv$iv2;
                collection = destination$iv$iv6;
                boolean bl11 = false;
                Pair bBoxes = (Pair)pair.component1();
                Pair width = (Pair)pair.component2();
                DoubleRectangle labelBBox = (DoubleRectangle)bBoxes.component1();
                DoubleRectangle valueBBox = (DoubleRectangle)bBoxes.component2();
                double labelWidth3 = ((Number)width.component1()).doubleValue();
                double valueWidth3 = ((Number)width.component2()).doubleValue();
                double d11 = labelWidth3;
                if (labelBBox != null) {
                    void $this$layoutLines_u24lambda_u2435_u24lambda_u2433;
                    d10 = d11;
                    boolean bl12 = false;
                    d9 = $this$layoutLines_u24lambda_u2435_u24lambda_u2433.getHeight() + $this$layoutLines_u24lambda_u2435_u24lambda_u2433.getTop();
                    d11 = d10;
                    d8 = d9;
                } else {
                    d8 = 0.0;
                }
                double d12 = d8;
                double d13 = d11;
                DoubleVector labelDimension = new DoubleVector(d13, d12);
                double d14 = valueWidth3;
                if (valueBBox != null) {
                    void $this$layoutLines_u24lambda_u2435_u24lambda_u2434;
                    d10 = d14;
                    boolean bl13 = false;
                    d9 = $this$layoutLines_u24lambda_u2435_u24lambda_u2434.getHeight() + $this$layoutLines_u24lambda_u2435_u24lambda_u2434.getTop();
                    d14 = d10;
                    d7 = d9;
                } else {
                    d7 = labelBBox == null ? defaultLineHeight : 0.0;
                }
                double d15 = d7;
                double d16 = d14;
                DoubleVector valueDimension = new DoubleVector(d16, d15);
                DoubleRectangle doubleRectangle4 = labelBBox;
                if (doubleRectangle4 == null || (doubleRectangle4 = doubleRectangle4.getOrigin()) == null) {
                    doubleRectangle4 = DoubleVector.Companion.getZERO();
                }
                DoubleRectangle doubleRectangle5 = new DoubleRectangle((DoubleVector)doubleRectangle4, labelDimension);
                DoubleRectangle doubleRectangle6 = valueBBox;
                if (doubleRectangle6 == null || (doubleRectangle6 = doubleRectangle6.getOrigin()) == null) {
                    doubleRectangle6 = DoubleVector.Companion.getZERO();
                }
                collection.add(new Pair((Object)doubleRectangle5, (Object)new DoubleRectangle((DoubleVector)doubleRectangle6, valueDimension)));
            }
            List lineBBoxes = (List)destination$iv$iv6;
            Iterable $i$f$map222 = CollectionsKt.zip((Iterable)components, (Iterable)lineBBoxes);
            $this$mapTo$iv$iv = DoubleVector.Companion.getZERO();
            destination$iv$iv6 = TooltipBox.this;
            boolean $i$f$fold = false;
            DoubleVector accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                Unit unit;
                Pair pair = (Pair)element$iv;
                void textDimension = accumulator$iv;
                boolean bl14 = false;
                Pair lineInfo = (Pair)pair.component1();
                Pair bBoxes = (Pair)pair.component2();
                MultilineLabel labelComponent = (MultilineLabel)lineInfo.component1();
                MultilineLabel valueComponent3 = (MultilineLabel)lineInfo.component2();
                DoubleRectangle labelBBox = (DoubleRectangle)bBoxes.component1();
                DoubleRectangle valueBBox = (DoubleRectangle)bBoxes.component2();
                double yPosition = textDimension.getY() - Math.min(valueBBox.getTop(), labelBBox.getTop());
                valueComponent3.setY(yPosition);
                MultilineLabel multilineLabel = labelComponent;
                if (multilineLabel != null) {
                    multilineLabel.setY(yPosition);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (labelComponent != null && labelBBox.getDimension().getX() > 0.0) {
                    labelComponent.setX(-labelBBox.getLeft());
                    if (valueComponent3.linesCount() > 1) {
                        valueComponent3.setX(maxLabelWidth + 8.0);
                        valueComponent3.setHorizontalAnchor(Text.HorizontalAnchor.LEFT);
                    } else {
                        valueComponent3.setX(maxLineWidth);
                        valueComponent3.setHorizontalAnchor(Text.HorizontalAnchor.RIGHT);
                    }
                } else if (valueBBox.getDimension().getX() == maxLineWidth && valueComponent3.linesCount() == 1) {
                    valueComponent3.setX(-valueBBox.getLeft());
                } else {
                    valueComponent3.setX(maxLineWidth / (double)2);
                    valueComponent3.setHorizontalAnchor(Text.HorizontalAnchor.MIDDLE);
                }
                double y = yPosition + Math.max(valueBBox.getHeight(), labelBBox.getHeight());
                ((TooltipBox)((Object)destination$iv$iv6)).myYPositionsBetweenLines.add(y + 3.0);
                accumulator$iv = new DoubleVector(maxLineWidth, y + 6.0);
            }
            DoubleVector doubleVector = accumulator$iv.subtract(new DoubleVector(0.0, 6.0));
            TooltipBox tooltipBox = TooltipBox.this;
            DoubleVector it = doubleVector;
            boolean bl15 = false;
            CollectionsKt.removeLastOrNull((List)tooltipBox.myYPositionsBetweenLines);
            DoubleVector textSize = doubleVector;
            return textSize;
        }

        /*
         * WARNING - void declaration
         */
        private final void drawLineSeparators(Double yTitleLinePosition, List<Double> yPositionsBetweenLines) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable pathData;
            TooltipBox $this$drawLineSeparators_u24lambda_u2438;
            TooltipBox tooltipBox;
            if (yTitleLinePosition != null) {
                tooltipBox = new SvgPathDataBuilder(false, 1, null);
                TooltipBox tooltipBox2 = TooltipBox.this;
                $this$drawLineSeparators_u24lambda_u2438 = tooltipBox;
                boolean bl = false;
                SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$drawLineSeparators_u24lambda_u2438, (double)tooltipBox2.myHorizontalContentPadding, (double)yTitleLinePosition, (boolean)false, (int)4, null);
                Object object = this.myTitleContainer.width().get();
                Intrinsics.checkNotNull((Object)object);
                SvgPathDataBuilder.horizontalLineTo$default((SvgPathDataBuilder)$this$drawLineSeparators_u24lambda_u2438, (double)(((Number)object).doubleValue() - tooltipBox2.myHorizontalContentPadding), (boolean)false, (int)2, null);
                pathData = tooltipBox.build();
                ContentBox.drawLineSeparators$drawLineSeparator(new SvgPathElement((SvgPathData)pathData), this.myTitleContainer);
            }
            pathData = yPositionsBetweenLines;
            tooltipBox = TooltipBox.this;
            boolean $i$f$map = false;
            $this$drawLineSeparators_u24lambda_u2438 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void y;
                SvgPathDataBuilder svgPathDataBuilder;
                double d = ((Number)item$iv$iv).doubleValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SvgPathDataBuilder $this$drawLineSeparators_u24lambda_u2441_u24lambda_u2440 = svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
                boolean bl2 = false;
                SvgSvgElement $this$drawLineSeparators_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439 = this.myContent;
                boolean bl3 = false;
                double padding = 2.0;
                Object object = $this$drawLineSeparators_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.x().get();
                Intrinsics.checkNotNull((Object)object);
                SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$drawLineSeparators_u24lambda_u2441_u24lambda_u2440, (double)(((Number)object).doubleValue() + padding), (double)y, (boolean)false, (int)4, null);
                Object object2 = $this$drawLineSeparators_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.width().get();
                Intrinsics.checkNotNull((Object)object2);
                SvgPathDataBuilder.horizontalLineTo$default((SvgPathDataBuilder)$this$drawLineSeparators_u24lambda_u2441_u24lambda_u2440, (double)(((Number)object2).doubleValue() - tooltipBox.myHorizontalContentPadding * (double)2 - this.colorBarIndent - padding), (boolean)false, (int)2, null);
                collection.add(svgPathDataBuilder.build());
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgPathData pathData2 = (SvgPathData)element$iv;
                boolean bl = false;
                ContentBox.drawLineSeparators$drawLineSeparator(new SvgPathElement(pathData2), this.myLinesContainer);
            }
        }

        public final void drawDebugRect() {
            List rectangles = TooltipBox.this.myDebugRectangles.provide(3);
            ContentBox.drawDebugRect$drawRect((Companion.RectangleComponent)((Object)rectangles.get(0)), this.myContent, Color.Companion.getRED());
            ContentBox.drawDebugRect$drawRect((Companion.RectangleComponent)((Object)rectangles.get(1)), this.myTitleContainer, Color.Companion.getDARK_GREEN());
            ContentBox.drawDebugRect$drawRect((Companion.RectangleComponent)((Object)rectangles.get(2)), this.myLinesContainer, Color.Companion.getORANGE());
        }

        private static final void drawLineSeparators$drawLineSeparator(SvgPathElement path, SvgSvgElement toSvgElem) {
            path.strokeWidth().set((Object)0.7);
            path.strokeOpacity().set((Object)1.0);
            path.strokeColor().set((Object)Color.Companion.getVERY_LIGHT_GRAY());
            toSvgElem.children().add((Object)path);
        }

        private static final void drawDebugRect$drawRect(Companion.RectangleComponent rectComponent, SvgSvgElement svgElem, Color color) {
            Object object = svgElem.x().get();
            Intrinsics.checkNotNull((Object)object);
            double d = ((Number)object).doubleValue();
            Object object2 = svgElem.y().get();
            Intrinsics.checkNotNull((Object)object2);
            double d2 = ((Number)object2).doubleValue();
            Object object3 = svgElem.width().get();
            Intrinsics.checkNotNull((Object)object3);
            double d3 = ((Number)object3).doubleValue();
            Object object4 = svgElem.height().get();
            Intrinsics.checkNotNull((Object)object4);
            rectComponent.update(d, d2, d3, ((Number)object4).doubleValue(), color);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Orientation;", "", "(Ljava/lang/String;I)V", "VERTICAL", "HORIZONTAL", "plot-builder"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation VERTICAL = new Orientation();
        public static final /* enum */ Orientation HORIZONTAL = new Orientation();
        private static final /* synthetic */ Orientation[] $VALUES;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String value) {
            return Enum.valueOf(Orientation.class, value);
        }

        static {
            $VALUES = orientationArray = new Orientation[]{Orientation.VERTICAL, Orientation.HORIZONTAL};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ.\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerBox;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox;)V", "myBorderRadius", "", "myHighlightPoint", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathElement;", "myPointerPath", "pointerDirection", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerDirection;", "getPointerDirection", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerDirection;", "setPointerDirection", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerDirection;)V", "buildComponent", "", "calculatePointerFootingIndent", "sideLength", "trianglePointer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;", "pointerCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "update", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$Orientation;", "usePointMarker", "", "updateStyle", "fillColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "borderColor", "strokeWidth", "borderRadius", "pointMarkerStrokeColor", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nTooltipBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipBox.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,760:1\n1549#2:761\n1620#2,3:762\n1855#2,2:765\n*S KotlinDebug\n*F\n+ 1 TooltipBox.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerBox\n*L\n265#1:761\n265#1:762,3\n267#1:765,2\n*E\n"})
    private final class PointerBox
    extends SvgComponent {
        @NotNull
        private final SvgPathElement myPointerPath = new SvgPathElement();
        @Nullable
        private PointerDirection pointerDirection;
        private double myBorderRadius;
        @NotNull
        private final SvgPathElement myHighlightPoint = new SvgPathElement();

        @Nullable
        public final PointerDirection getPointerDirection() {
            return this.pointerDirection;
        }

        public final void setPointerDirection(@Nullable PointerDirection pointerDirection) {
            this.pointerDirection = pointerDirection;
        }

        protected void buildComponent() {
            this.add((SvgNode)this.myPointerPath);
            this.add((SvgNode)this.myHighlightPoint);
        }

        public final void updateStyle(@NotNull Color fillColor, @NotNull Color borderColor, double strokeWidth, double borderRadius, @NotNull Color pointMarkerStrokeColor) {
            SvgPathElement svgPathElement;
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
            Intrinsics.checkNotNullParameter((Object)pointMarkerStrokeColor, (String)"pointMarkerStrokeColor");
            this.myBorderRadius = borderRadius;
            SvgPathElement $this$updateStyle_u24lambda_u240 = svgPathElement = this.myPointerPath;
            boolean bl = false;
            $this$updateStyle_u24lambda_u240.strokeColor().set((Object)borderColor);
            $this$updateStyle_u24lambda_u240.strokeWidth().set((Object)strokeWidth);
            $this$updateStyle_u24lambda_u240.fillColor().set((Object)fillColor);
            SvgPathElement $this$updateStyle_u24lambda_u241 = svgPathElement = this.myHighlightPoint;
            boolean bl2 = false;
            Color fill2 = Intrinsics.areEqual((Object)fillColor, (Object)pointMarkerStrokeColor) ? borderColor : fillColor;
            $this$updateStyle_u24lambda_u241.fillColor().set((Object)fill2);
            $this$updateStyle_u24lambda_u241.strokeWidth().set((Object)1.0);
            $this$updateStyle_u24lambda_u241.strokeColor().set((Object)pointMarkerStrokeColor);
        }

        /*
         * WARNING - void declaration
         */
        public final void update(@NotNull DoubleVector pointerCoord, @NotNull Orientation orientation, boolean usePointMarker) {
            void $this$update_u24lambda_u243;
            PointerDirection pointerDirection;
            Intrinsics.checkNotNullParameter((Object)pointerCoord, (String)"pointerCoord");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            if (usePointMarker) {
                pointerDirection = null;
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
                    case 1: {
                        if (pointerCoord.getX() < TooltipBox.this.getContentRect().getLeft()) {
                            pointerDirection = PointerDirection.LEFT;
                            break;
                        }
                        if (pointerCoord.getX() > TooltipBox.this.getContentRect().getRight()) {
                            pointerDirection = PointerDirection.RIGHT;
                            break;
                        }
                        pointerDirection = null;
                        break;
                    }
                    case 2: {
                        if (pointerCoord.getY() > TooltipBox.this.getContentRect().getBottom()) {
                            pointerDirection = PointerDirection.DOWN;
                            break;
                        }
                        if (pointerCoord.getY() < TooltipBox.this.getContentRect().getTop()) {
                            pointerDirection = PointerDirection.UP;
                            break;
                        }
                        pointerDirection = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this.pointerDirection = pointerDirection;
            double vertFootingIndent = -this.calculatePointerFootingIndent(TooltipBox.this.getContentRect().getHeight());
            double horFootingIndent = this.calculatePointerFootingIndent(TooltipBox.this.getContentRect().getWidth());
            SvgPathDataBuilder svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            TooltipBox tooltipBox = TooltipBox.this;
            SvgPathDataBuilder svgPathDataBuilder2 = svgPathDataBuilder;
            Property property = this.myPointerPath.d();
            boolean bl = false;
            DoubleRectangle $this$update_u24lambda_u243_u24lambda_u242 = tooltipBox.getContentRect();
            boolean bl2 = false;
            SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)($this$update_u24lambda_u243_u24lambda_u242.getRight() - this.myBorderRadius), (double)$this$update_u24lambda_u243_u24lambda_u242.getBottom(), (boolean)false, (int)4, null);
            PointerBox.update$lambda$3$lambda$2$corner((SvgPathDataBuilder)$this$update_u24lambda_u243, new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getRight() - this.myBorderRadius, $this$update_u24lambda_u243_u24lambda_u242.getBottom()), new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getRight(), $this$update_u24lambda_u243_u24lambda_u242.getBottom()), new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getRight(), $this$update_u24lambda_u243_u24lambda_u242.getBottom() - this.myBorderRadius));
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)$this$update_u24lambda_u243_u24lambda_u242.getRight(), (double)($this$update_u24lambda_u243_u24lambda_u242.getBottom() + vertFootingIndent), (boolean)false, (int)4, null);
            PointerBox.update$lambda$3$lambda$2$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u243, pointerCoord, this.pointerDirection == PointerDirection.RIGHT);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)$this$update_u24lambda_u243_u24lambda_u242.getRight(), (double)($this$update_u24lambda_u243_u24lambda_u242.getTop() - vertFootingIndent), (boolean)false, (int)4, null);
            PointerBox.update$lambda$3$lambda$2$corner((SvgPathDataBuilder)$this$update_u24lambda_u243, new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getRight(), $this$update_u24lambda_u243_u24lambda_u242.getTop() + this.myBorderRadius), new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getRight(), $this$update_u24lambda_u243_u24lambda_u242.getTop()), new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getRight() - this.myBorderRadius, $this$update_u24lambda_u243_u24lambda_u242.getTop()));
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)($this$update_u24lambda_u243_u24lambda_u242.getRight() - horFootingIndent), (double)$this$update_u24lambda_u243_u24lambda_u242.getTop(), (boolean)false, (int)4, null);
            PointerBox.update$lambda$3$lambda$2$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u243, pointerCoord, this.pointerDirection == PointerDirection.UP);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)($this$update_u24lambda_u243_u24lambda_u242.getLeft() + horFootingIndent), (double)$this$update_u24lambda_u243_u24lambda_u242.getTop(), (boolean)false, (int)4, null);
            PointerBox.update$lambda$3$lambda$2$corner((SvgPathDataBuilder)$this$update_u24lambda_u243, new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getLeft() + this.myBorderRadius, $this$update_u24lambda_u243_u24lambda_u242.getTop()), new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getLeft(), $this$update_u24lambda_u243_u24lambda_u242.getTop()), new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getLeft(), $this$update_u24lambda_u243_u24lambda_u242.getTop() + this.myBorderRadius));
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)$this$update_u24lambda_u243_u24lambda_u242.getLeft(), (double)($this$update_u24lambda_u243_u24lambda_u242.getTop() - vertFootingIndent), (boolean)false, (int)4, null);
            PointerBox.update$lambda$3$lambda$2$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u243, pointerCoord, this.pointerDirection == PointerDirection.LEFT);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)$this$update_u24lambda_u243_u24lambda_u242.getLeft(), (double)($this$update_u24lambda_u243_u24lambda_u242.getBottom() + vertFootingIndent), (boolean)false, (int)4, null);
            PointerBox.update$lambda$3$lambda$2$corner((SvgPathDataBuilder)$this$update_u24lambda_u243, new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getLeft(), $this$update_u24lambda_u243_u24lambda_u242.getBottom() - this.myBorderRadius), new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getLeft(), $this$update_u24lambda_u243_u24lambda_u242.getBottom()), new DoubleVector($this$update_u24lambda_u243_u24lambda_u242.getLeft() + this.myBorderRadius, $this$update_u24lambda_u243_u24lambda_u242.getBottom()));
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)($this$update_u24lambda_u243_u24lambda_u242.getLeft() + horFootingIndent), (double)$this$update_u24lambda_u243_u24lambda_u242.getBottom(), (boolean)false, (int)4, null);
            PointerBox.update$lambda$3$lambda$2$lineToIf((SvgPathDataBuilder)$this$update_u24lambda_u243, pointerCoord, this.pointerDirection == PointerDirection.DOWN);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)($this$update_u24lambda_u243_u24lambda_u242.getRight() - horFootingIndent), (double)$this$update_u24lambda_u243_u24lambda_u242.getBottom(), (boolean)false, (int)4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$update_u24lambda_u243, (double)($this$update_u24lambda_u243_u24lambda_u242.getRight() - this.myBorderRadius), (double)$this$update_u24lambda_u243_u24lambda_u242.getBottom(), (boolean)false, (int)4, null);
            property.set((Object)svgPathDataBuilder.build());
            if (usePointMarker) {
                this.myHighlightPoint.d().set((Object)this.trianglePointer(pointerCoord).build());
                SvgUtils.INSTANCE.transformRotate((SvgTransformable)this.myHighlightPoint, -30.0, pointerCoord.getX(), pointerCoord.getY());
                this.myHighlightPoint.visibility().set((Object)SvgGraphicsElement.Visibility.VISIBLE);
            } else {
                this.myHighlightPoint.visibility().set((Object)SvgGraphicsElement.Visibility.HIDDEN);
            }
        }

        private final double calculatePointerFootingIndent(double sideLength) {
            double footingLength = Math.min(sideLength * 0.4, 12.0);
            return (sideLength - footingLength) / (double)2;
        }

        /*
         * WARNING - void declaration
         */
        private final SvgPathDataBuilder trianglePointer(DoubleVector pointerCoord) {
            void $this$mapTo$iv$iv;
            SvgPathDataBuilder svgPathDataBuilder;
            SvgPathDataBuilder $this$trianglePointer_u24lambda_u245 = svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            boolean bl = false;
            Iterable $this$map$iv = TRIANGLE_POINTS;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DoubleVector doubleVector = (DoubleVector)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.add(pointerCoord));
            }
            List xy2 = (List)destination$iv$iv;
            $this$trianglePointer_u24lambda_u245.moveTo((DoubleVector)xy2.get(0));
            Iterable $this$forEach$iv = xy2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleVector p0 = (DoubleVector)element$iv;
                boolean bl3 = false;
                $this$trianglePointer_u24lambda_u245.lineTo(p0);
            }
            $this$trianglePointer_u24lambda_u245.closePath();
            return svgPathDataBuilder;
        }

        private static final void update$lambda$3$lambda$2$lineToIf(SvgPathDataBuilder $this_apply, DoubleVector p, boolean isTrue) {
            if (isTrue) {
                $this_apply.lineTo(p);
            }
        }

        private static final void update$lambda$3$lambda$2$corner(SvgPathDataBuilder $this_apply, DoubleVector controlStart, DoubleVector controlEnd, DoubleVector to) {
            $this_apply.lineTo(controlStart);
            if (!Intrinsics.areEqual((Object)controlStart, (Object)to)) {
                $this_apply.curveTo(controlStart, controlEnd, to);
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Orientation.values().length];
                try {
                    nArray[Orientation.HORIZONTAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.VERTICAL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/component/TooltipBox$PointerDirection;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "UP", "DOWN", "plot-builder"})
    public static final class PointerDirection
    extends Enum<PointerDirection> {
        public static final /* enum */ PointerDirection LEFT = new PointerDirection();
        public static final /* enum */ PointerDirection RIGHT = new PointerDirection();
        public static final /* enum */ PointerDirection UP = new PointerDirection();
        public static final /* enum */ PointerDirection DOWN = new PointerDirection();
        private static final /* synthetic */ PointerDirection[] $VALUES;

        public static PointerDirection[] values() {
            return (PointerDirection[])$VALUES.clone();
        }

        public static PointerDirection valueOf(String value) {
            return Enum.valueOf(PointerDirection.class, value);
        }

        static {
            $VALUES = pointerDirectionArray = new PointerDirection[]{PointerDirection.LEFT, PointerDirection.RIGHT, PointerDirection.UP, PointerDirection.DOWN};
        }
    }
}

