/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.HSV;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.GuideMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.mapper.ColorMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.mapper.GuideMappers;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.MapperProviderBase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b&\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\nH\u0004J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0004\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/HSVColorMapperProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/MapperProviderBase;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "naValue", "(Lorg/jetbrains/letsPlot/commons/values/Color;)V", "createContinuousMapper", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/GuideMapper;", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "hsvIntervals", "", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/values/HSV;", "createDiscreteMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "transformedDomain", "", "fromHSV", "toHSV", "Companion", "plot-builder"})
public abstract class HSVColorMapperProvider
extends MapperProviderBase<Color> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public HSVColorMapperProvider(@NotNull Color naValue) {
        Intrinsics.checkNotNullParameter((Object)naValue, (String)"naValue");
        super(naValue);
    }

    @NotNull
    protected final ScaleMapper<Color> createDiscreteMapper(@NotNull List<Double> transformedDomain, @NotNull HSV fromHSV, @NotNull HSV toHSV) {
        double step;
        double hueDiff;
        Intrinsics.checkNotNullParameter(transformedDomain, (String)"transformedDomain");
        Intrinsics.checkNotNullParameter((Object)fromHSV, (String)"fromHSV");
        Intrinsics.checkNotNullParameter((Object)toHSV, (String)"toHSV");
        DoubleSpan mapperDomain = SeriesUtil.ensureApplicableRange$default((SeriesUtil)SeriesUtil.INSTANCE, (DoubleSpan)SeriesUtil.INSTANCE.range((Iterable)transformedDomain), null, (int)2, null);
        int n = transformedDomain.size();
        double newFromHue = fromHSV.getH();
        double newToHue = toHSV.getH();
        if (n > 1 && (hueDiff = Math.abs(toHSV.getH() % (double)360 - fromHSV.getH() % (double)360)) < Math.abs(step = (toHSV.getH() - fromHSV.getH()) / (double)n) / (double)2) {
            newFromHue = fromHSV.getH() + step / (double)2;
            newToHue = toHSV.getH() - step / (double)2;
        }
        Function1<Double, Color> gradient = ColorMapper.INSTANCE.gradientHSV(mapperDomain, new HSV(newFromHue, fromHSV.getS(), fromHSV.getV()), new HSV(newToHue, toHSV.getS(), toHSV.getV()), false, (Color)this.getNaValue(), 1.0);
        return GuideMappers.INSTANCE.asNotContinuous(ScaleMapper.Companion.wrap(gradient));
    }

    @NotNull
    protected final GuideMapper<Color> createContinuousMapper(@NotNull DoubleSpan domain, @NotNull List<Pair<HSV, HSV>> hsvIntervals) {
        Function1<Double, Color> function1;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter(hsvIntervals, (String)"hsvIntervals");
        switch (hsvIntervals.size()) {
            case 0: {
                throw new IllegalArgumentException("Empty HSV intervals.");
            }
            case 1: {
                function1 = ColorMapper.INSTANCE.gradientHSV(domain, (HSV)hsvIntervals.get(0).getFirst(), (HSV)hsvIntervals.get(0).getSecond(), false, (Color)this.getNaValue(), 1.0);
                break;
            }
            default: {
                function1 = HSVColorMapperProvider.Companion.createCompositeColorMapper(domain, hsvIntervals, false, (Color)this.getNaValue());
            }
        }
        Function1<Double, Color> gradientMapper = function1;
        return GuideMappers.INSTANCE.asContinuous(ScaleMapper.Companion.wrap((Function1)gradientMapper));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JZ\u0010\u0003\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u00070\u00050\u00042\u0006\u0010\n\u001a\u00020\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002JH\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J0\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\n\u001a\u00020\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00050\u0004H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/HSVColorMapperProvider$Companion;", "", "()V", "createColorMappersPerSubDomain", "", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "Lkotlin/Function1;", "", "Lorg/jetbrains/letsPlot/commons/values/Color;", "domain", "hsvIntervals", "Lorg/jetbrains/letsPlot/commons/values/HSV;", "autoHueDirection", "", "naColor", "createCompositeColorMapper", "splitContinuousDomain", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nHSVColorMapperProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSVColorMapperProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/scale/provider/HSVColorMapperProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1549#2:142\n1620#2,3:143\n1549#2:146\n1620#2,3:147\n*S KotlinDebug\n*F\n+ 1 HSVColorMapperProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/scale/provider/HSVColorMapperProvider$Companion\n*L\n100#1:142\n100#1:143,3\n123#1:146\n123#1:147,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<Double, Color> createCompositeColorMapper(DoubleSpan domain, List<Pair<HSV, HSV>> hsvIntervals, boolean autoHueDirection, Color naColor) {
            List<Pair<DoubleSpan, Function1<Double, Color>>> colorMappersPerSubDomain = this.createColorMappersPerSubDomain(domain, hsvIntervals, autoHueDirection, naColor);
            return (Function1)new Function1<Double, Color>(naColor, colorMappersPerSubDomain){
                final /* synthetic */ Color $naColor;
                final /* synthetic */ List<Pair<DoubleSpan, Function1<Double, Color>>> $colorMappersPerSubDomain;
                {
                    this.$naColor = $naColor;
                    this.$colorMappersPerSubDomain = $colorMappersPerSubDomain;
                    super(1);
                }

                @NotNull
                public final Color invoke(@Nullable Double v) {
                    Color color;
                    if (v == null) {
                        color = this.$naColor;
                    } else {
                        Object v1;
                        block4: {
                            Iterable iterable = this.$colorMappersPerSubDomain;
                            for (T t : iterable) {
                                Pair it = (Pair)t;
                                boolean bl = false;
                                if (!((DoubleSpan)it.getFirst()).contains(v.doubleValue())) continue;
                                v1 = t;
                                break block4;
                            }
                            v1 = null;
                        }
                        Pair pair = v1;
                        Object mapper = pair != null ? (Function1)pair.getSecond() : null;
                        color = mapper;
                        if (color == null || (color = (Color)color.invoke((Object)v)) == null) {
                            color = this.$naColor;
                        }
                    }
                    return color;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<DoubleSpan, Function1<Double, Color>>> createColorMappersPerSubDomain(DoubleSpan domain, List<Pair<HSV, HSV>> hsvIntervals, boolean autoHueDirection, Color naColor) {
            void $this$mapTo$iv$iv;
            List<DoubleSpan> subDomains = this.splitContinuousDomain(domain, hsvIntervals);
            Iterable $this$map$iv = CollectionsKt.zip((Iterable)subDomains, (Iterable)hsvIntervals);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DoubleSpan domain2 = (DoubleSpan)it.getFirst();
                Pair hsvInterval = (Pair)it.getSecond();
                collection.add(new Pair((Object)domain2, ColorMapper.INSTANCE.gradientHSV(domain2, (HSV)hsvInterval.getFirst(), (HSV)hsvInterval.getSecond(), autoHueDirection, naColor, 1.0)));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DoubleSpan> splitContinuousDomain(DoubleSpan domain, List<Pair<HSV, HSV>> hsvIntervals) {
            Object object;
            void $this$mapTo$iv$iv;
            double domainSize = domain.getUpperEnd() - domain.getLowerEnd();
            Iterable $this$map$iv = hsvIntervals;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Math.abs(((HSV)it.getFirst()).getH() - ((HSV)it.getSecond()).getH()));
            }
            List hueIntervalSizeList = (List)destination$iv$iv;
            double hueIntervalsTotalSize = CollectionsKt.sumOfDouble((Iterable)hueIntervalSizeList);
            double domainToHueIntevalRatio = domainSize / hueIntervalsTotalSize;
            ArrayList<DoubleSpan> subDomains = new ArrayList<DoubleSpan>();
            double lowerEnd = domain.getLowerEnd();
            object = hueIntervalSizeList.iterator();
            while (object.hasNext()) {
                double hueIntervalSize = ((Number)object.next()).doubleValue();
                double upperEnd = lowerEnd + hueIntervalSize * domainToHueIntevalRatio;
                subDomains.add(new DoubleSpan(lowerEnd, upperEnd));
                lowerEnd = upperEnd;
            }
            return subDomains;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

