/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale.provider;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.colormap.ColorMaps;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.MapperUtil;
import org.jetbrains.letsPlot.core.plot.builder.scale.GuideMapper;
import org.jetbrains.letsPlot.core.plot.builder.scale.mapper.GuideMappers;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.ColorGradientnMapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.provider.MapperProviderBase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B?\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColormapMapperProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/provider/MapperProviderBase;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "cmapName", "", "alpha", "", "begin", "end", "direction", "naValue", "(Ljava/lang/String;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lorg/jetbrains/letsPlot/commons/values/Color;)V", "Ljava/lang/Double;", "colors", "", "n", "", "(Ljava/lang/Integer;)Ljava/util/List;", "createContinuousMapper", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/GuideMapper;", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "trans", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "createDiscreteMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nColormapMapperProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColormapMapperProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/scale/provider/ColormapMapperProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class ColormapMapperProvider
extends MapperProviderBase<Color> {
    @Nullable
    private final Double direction;
    @NotNull
    private final String cmapName;
    private final double alpha;
    private final double begin;
    private final double end;

    public ColormapMapperProvider(@Nullable String cmapName, @Nullable Double alpha, @Nullable Double begin, @Nullable Double end, @Nullable Double direction, @NotNull Color naValue) {
        Intrinsics.checkNotNullParameter((Object)naValue, (String)"naValue");
        super(naValue);
        this.direction = direction;
        String string = cmapName;
        if (string == null) {
            string = "viridis";
        }
        this.cmapName = string;
        Double d = alpha;
        this.alpha = d != null ? d : 1.0;
        Double d2 = begin;
        this.begin = d2 != null ? d2 : 0.0;
        Double d3 = end;
        this.end = d3 != null ? d3 : 1.0;
        DoubleSpan r01 = new DoubleSpan(0.0, 1.0);
        if (!r01.contains(this.alpha)) {
            boolean $i$a$-require-ColormapMapperProvider$42 = false;
            String $i$a$-require-ColormapMapperProvider$42 = "'alpha' should be in range [0..1]";
            throw new IllegalArgumentException($i$a$-require-ColormapMapperProvider$42.toString());
        }
        if (!r01.contains(this.begin)) {
            boolean $i$a$-require-ColormapMapperProvider$52 = false;
            String $i$a$-require-ColormapMapperProvider$52 = "'begin' should be in range [0..1]";
            throw new IllegalArgumentException($i$a$-require-ColormapMapperProvider$52.toString());
        }
        if (!r01.contains(this.end)) {
            boolean bl = false;
            String string2 = "'end' should be in range [0..1]";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Override
    @NotNull
    public ScaleMapper<Color> createDiscreteMapper(@NotNull DiscreteTransform discreteTransform) {
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        int n = discreteTransform.getEffectiveDomain().size();
        List<Color> colors = this.colors(n);
        return GuideMappers.INSTANCE.discreteToDiscrete(discreteTransform, colors, this.getNaValue());
    }

    @Override
    @NotNull
    public GuideMapper<Color> createContinuousMapper(@NotNull DoubleSpan domain, @NotNull ContinuousTransform trans) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        List<Color> colors = this.colors(null);
        DoubleSpan domain2 = MapperUtil.INSTANCE.rangeWithLimitsAfterTransform(domain, trans);
        Function1<Double, Color> gradient = ColorGradientnMapperProvider.Companion.createGradient$plot_builder(domain2, colors, (Color)this.getNaValue(), this.alpha);
        return GuideMappers.INSTANCE.asContinuous(ScaleMapper.Companion.wrap(gradient));
    }

    private final List<Color> colors(Integer n) {
        List list;
        boolean bl;
        boolean bl2;
        List colors = ColorMaps.INSTANCE.getColors(this.cmapName, this.alpha, new DoubleSpan(this.begin, this.end), n);
        Double d = this.direction;
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl3 = false;
            bl2 = this.direction < 0.0;
        } else {
            bl2 = bl = false;
        }
        if (bl) {
            list = CollectionsKt.reversed((Iterable)colors);
        } else if (!bl) {
            list = colors;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    static /* synthetic */ List colors$default(ColormapMapperProvider colormapMapperProvider, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return colormapMapperProvider.colors(n);
    }
}

