/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale.mapper;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.commons.values.HSV;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\rJ\u001c\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u000fJF\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/mapper/ColorMapper;", "", "()V", "DEF_GRADIENT_HIGH", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getDEF_GRADIENT_HIGH", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "DEF_GRADIENT_LOW", "getDEF_GRADIENT_LOW", "NA_VALUE", "getNA_VALUE", "gradient", "Lkotlin/Function1;", "", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "low", "high", "naColor", "alpha", "gradientDefault", "gradientHSV", "lowHSV", "Lorg/jetbrains/letsPlot/commons/values/HSV;", "highHSV", "autoHueDirection", "", "plot-builder"})
public final class ColorMapper {
    @NotNull
    public static final ColorMapper INSTANCE = new ColorMapper();
    @NotNull
    private static final Color NA_VALUE = Color.Companion.getGRAY();
    @NotNull
    private static final Color DEF_GRADIENT_LOW = Color.Companion.parseHex("#132B43");
    @NotNull
    private static final Color DEF_GRADIENT_HIGH = Color.Companion.parseHex("#56B1F7");

    private ColorMapper() {
    }

    @NotNull
    public final Color getNA_VALUE() {
        return NA_VALUE;
    }

    @NotNull
    public final Color getDEF_GRADIENT_LOW() {
        return DEF_GRADIENT_LOW;
    }

    @NotNull
    public final Color getDEF_GRADIENT_HIGH() {
        return DEF_GRADIENT_HIGH;
    }

    @NotNull
    public final Function1<Double, Color> gradientDefault(@NotNull DoubleSpan domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return this.gradient(domain, DEF_GRADIENT_LOW, DEF_GRADIENT_HIGH, NA_VALUE, 1.0);
    }

    @NotNull
    public final Function1<Double, Color> gradient(@NotNull DoubleSpan domain, @NotNull Color low, @NotNull Color high, @NotNull Color naColor, double alpha) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)naColor, (String)"naColor");
        return this.gradientHSV(domain, Colors.INSTANCE.hsvFromRgb(low), Colors.INSTANCE.hsvFromRgb(high), true, naColor, alpha);
    }

    public static /* synthetic */ Function1 gradient$default(ColorMapper colorMapper, DoubleSpan doubleSpan, Color color, Color color2, Color color3, double d, int n, Object object) {
        if ((n & 0x10) != 0) {
            d = 1.0;
        }
        return colorMapper.gradient(doubleSpan, color, color2, color3, d);
    }

    @NotNull
    public final Function1<Double, Color> gradientHSV(@NotNull DoubleSpan domain, @NotNull HSV lowHSV, @NotNull HSV highHSV, boolean autoHueDirection, @NotNull Color naColor, double alpha) {
        double dH;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)lowHSV, (String)"lowHSV");
        Intrinsics.checkNotNullParameter((Object)highHSV, (String)"highHSV");
        Intrinsics.checkNotNullParameter((Object)naColor, (String)"naColor");
        double lowHue = lowHSV.getH();
        double highHue = highHSV.getH();
        double lowS = lowHSV.getS();
        double highS = highHSV.getS();
        if (lowS < 1.0E-4) {
            lowHue = highHue;
        }
        if (highS < 1.0E-4) {
            highHue = lowHue;
        }
        if (autoHueDirection && (dH = Math.abs(highHue - lowHue)) > 180.0) {
            if (highHue >= lowHue) {
                lowHue += 360.0;
            } else {
                highHue += 360.0;
            }
        }
        ScaleMapper mapperH = Mappers.INSTANCE.linear(domain, lowHue, highHue, null);
        ScaleMapper mapperS = Mappers.INSTANCE.linear(domain, lowS, highS, null);
        ScaleMapper mapperV = Mappers.INSTANCE.linear(domain, lowHSV.getV(), highHSV.getV(), null);
        return (Function1)new Function1<Double, Color>(domain, naColor, (ScaleMapper<Double>)mapperH, (ScaleMapper<Double>)mapperS, (ScaleMapper<Double>)mapperV, alpha){
            final /* synthetic */ DoubleSpan $domain;
            final /* synthetic */ Color $naColor;
            final /* synthetic */ ScaleMapper<Double> $mapperH;
            final /* synthetic */ ScaleMapper<Double> $mapperS;
            final /* synthetic */ ScaleMapper<Double> $mapperV;
            final /* synthetic */ double $alpha;
            {
                this.$domain = $domain;
                this.$naColor = $naColor;
                this.$mapperH = $mapperH;
                this.$mapperS = $mapperS;
                this.$mapperV = $mapperV;
                this.$alpha = $alpha;
                super(1);
            }

            @NotNull
            public final Color invoke(@Nullable Double input) {
                Color color;
                if (input == null || !this.$domain.contains(input.doubleValue())) {
                    color = this.$naColor;
                } else {
                    Object object = this.$mapperH.invoke(input);
                    Intrinsics.checkNotNull((Object)object);
                    double hue = ((Number)object).doubleValue() % (double)360;
                    double H = hue >= 0.0 ? hue : (double)360 + hue;
                    Object object2 = this.$mapperS.invoke(input);
                    Intrinsics.checkNotNull((Object)object2);
                    double S = ((Number)object2).doubleValue();
                    Object object3 = this.$mapperV.invoke(input);
                    Intrinsics.checkNotNull((Object)object3);
                    double V = ((Number)object3).doubleValue();
                    color = Colors.INSTANCE.rgbFromHsv(H, S, V, this.$alpha);
                }
                return color;
            }
        };
    }

    public static /* synthetic */ Function1 gradientHSV$default(ColorMapper colorMapper, DoubleSpan doubleSpan, HSV hSV, HSV hSV2, boolean bl, Color color, double d, int n, Object object) {
        if ((n & 0x20) != 0) {
            d = 1.0;
        }
        return colorMapper.gradientHSV(doubleSpan, hSV, hSV2, bl, color, d);
    }
}

