/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.Scales;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Transforms;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;
import org.jetbrains.letsPlot.core.plot.builder.scale.MapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.ScaleProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.WithGuideBreaks;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u00015B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u000fJ\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u0014J\u0006\u0010$\u001a\u00020%J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u0016J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010(\u001a\u00020\u0018J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010(\u001a\u00020\u0018J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010,\u001a\u0004\u0018\u00010\u001bJ\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0012J\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u000fJ\u0014\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00102\u001a\u00020\u001bJ\u0014\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u0002J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProviderBuilder;", "T", "", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aes;)V", "_mapperProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/MapperProvider;", "axisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "getAxisPosition", "()Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "setAxisPosition", "(Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;)V", "myAdditiveExpand", "", "Ljava/lang/Double;", "myBreaks", "", "myBreaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "myContinuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "myDiscreteDomain", "", "myDiscreteDomainReverse", "myLabelFormat", "", "myLabels", "myLimits", "myMultiplicativeExpand", "myName", "additiveExpand", "v", "breaks", "breaksGenerator", "build", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProvider;", "continuousTransform", "discreteDomain", "b", "discreteDomainReverse", "guide_NI", "labelFormat", "format", "labels", "limits", "minorBreaks_NI", "minorBreaks", "multiplicativeExpand", "name", "oob_NI", "rescaler_NI", "MyScaleProvider", "plot-builder"})
public final class ScaleProviderBuilder<T> {
    @NotNull
    private final Aes<T> aes;
    @Nullable
    private MapperProvider<T> _mapperProvider;
    @Nullable
    private String myName;
    @Nullable
    private List<? extends Object> myBreaks;
    @Nullable
    private List<String> myLabels;
    @Nullable
    private String myLabelFormat;
    @Nullable
    private Double myMultiplicativeExpand;
    @Nullable
    private Double myAdditiveExpand;
    @Nullable
    private List<? extends Object> myLimits;
    @NotNull
    private ContinuousTransform myContinuousTransform;
    @Nullable
    private BreaksGenerator myBreaksGenerator;
    private boolean myDiscreteDomain;
    private boolean myDiscreteDomainReverse;
    @NotNull
    private AxisPosition axisPosition;

    public ScaleProviderBuilder(@NotNull Aes<T> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        this.aes = aes;
        this.myContinuousTransform = Transforms.INSTANCE.getIDENTITY();
        Aes<T> aes2 = this.aes;
        this.axisPosition = Intrinsics.areEqual(aes2, (Object)Aes.Companion.getX()) ? AxisPosition.BOTTOM : (Intrinsics.areEqual(aes2, (Object)Aes.Companion.getY()) ? AxisPosition.LEFT : AxisPosition.BOTTOM);
    }

    @NotNull
    public final AxisPosition getAxisPosition() {
        return this.axisPosition;
    }

    public final void setAxisPosition(@NotNull AxisPosition axisPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)axisPosition), (String)"<set-?>");
        this.axisPosition = axisPosition;
    }

    @NotNull
    public final ScaleProviderBuilder<T> name(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.myName = name;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> breaks(@NotNull List<? extends Object> breaks) {
        Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
        this.myBreaks = breaks;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> minorBreaks_NI(@NotNull List<Double> minorBreaks) {
        Intrinsics.checkNotNullParameter(minorBreaks, (String)"minorBreaks");
        throw new IllegalStateException("Not implemented");
    }

    @NotNull
    public final ScaleProviderBuilder<T> labels(@NotNull List<String> labels) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        this.myLabels = new ArrayList(labels);
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> labelFormat(@Nullable String format) {
        this.myLabelFormat = format;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> multiplicativeExpand(double v) {
        this.myMultiplicativeExpand = v;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> additiveExpand(double v) {
        this.myAdditiveExpand = v;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> limits(@NotNull List<?> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        this.myLimits = v;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> rescaler_NI(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        throw new IllegalStateException("Not implemented");
    }

    @NotNull
    public final ScaleProviderBuilder<T> oob_NI(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        throw new IllegalStateException("Not implemented");
    }

    @NotNull
    public final ScaleProviderBuilder<T> continuousTransform(@NotNull ContinuousTransform v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.myContinuousTransform = v;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> breaksGenerator(@NotNull BreaksGenerator v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.myBreaksGenerator = v;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> guide_NI(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        throw new IllegalStateException("Not implemented");
    }

    @NotNull
    public final ScaleProviderBuilder<T> discreteDomain(boolean b) {
        this.myDiscreteDomain = b;
        return this;
    }

    @NotNull
    public final ScaleProviderBuilder<T> discreteDomainReverse(boolean b) {
        this.myDiscreteDomainReverse = b;
        return this;
    }

    @NotNull
    public final ScaleProvider build() {
        return new MyScaleProvider(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J0\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00142\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u000102H\u0016J\u0018\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020*H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001e\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010&\u001a\u0004\u0018\u00010#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProviderBuilder$MyScaleProvider;", "T", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProvider;", "b", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProviderBuilder;", "(Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProviderBuilder;)V", "axisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "getAxisPosition", "()Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "breaks", "", "", "getBreaks", "()Ljava/util/List;", "continuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "getContinuousTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "discreteDomain", "", "getDiscreteDomain", "()Z", "discreteDomainReverse", "getDiscreteDomainReverse", "limits", "getLimits", "myAdditiveExpand", "", "Ljava/lang/Double;", "myAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "myBreaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "myLabelFormat", "", "myLabels", "myMultiplicativeExpand", "myName", "absentMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "var", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "completeScale", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "scale", "createScale", "defaultName", "continuousRange", "guideBreaks", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/WithGuideBreaks;", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "scaleName", "variable", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nScaleProviderBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleProviderBuilder.kt\norg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProviderBuilder$MyScaleProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1#2:242\n*E\n"})
    private static final class MyScaleProvider<T>
    implements ScaleProvider {
        @Nullable
        private final String myName;
        @Nullable
        private final List<String> myLabels;
        @Nullable
        private final String myLabelFormat;
        @Nullable
        private final Double myMultiplicativeExpand;
        @Nullable
        private final Double myAdditiveExpand;
        @Nullable
        private final BreaksGenerator myBreaksGenerator;
        @NotNull
        private final Aes<T> myAes;
        private final boolean discreteDomain;
        private final boolean discreteDomainReverse;
        @Nullable
        private final List<Object> breaks;
        @Nullable
        private final List<Object> limits;
        @NotNull
        private final ContinuousTransform continuousTransform;
        @NotNull
        private final AxisPosition axisPosition;

        public MyScaleProvider(@NotNull ScaleProviderBuilder<T> b) {
            AxisPosition axisPosition;
            ArrayList arrayList;
            ArrayList arrayList2;
            ArrayList arrayList3;
            List it;
            MyScaleProvider myScaleProvider;
            Intrinsics.checkNotNullParameter(b, (String)"b");
            this.myName = ((ScaleProviderBuilder)b).myName;
            MyScaleProvider myScaleProvider2 = this;
            List list = ((ScaleProviderBuilder)b).myLabels;
            if (list != null) {
                List list2 = list;
                myScaleProvider = myScaleProvider2;
                boolean bl = false;
                arrayList3 = new ArrayList(it);
                myScaleProvider2 = myScaleProvider;
            } else {
                arrayList3 = null;
            }
            myScaleProvider2.myLabels = arrayList3;
            this.myLabelFormat = ((ScaleProviderBuilder)b).myLabelFormat;
            this.myMultiplicativeExpand = ((ScaleProviderBuilder)b).myMultiplicativeExpand;
            this.myAdditiveExpand = ((ScaleProviderBuilder)b).myAdditiveExpand;
            this.myBreaksGenerator = ((ScaleProviderBuilder)b).myBreaksGenerator;
            this.myAes = ((ScaleProviderBuilder)b).aes;
            this.discreteDomain = ((ScaleProviderBuilder)b).myDiscreteDomain;
            this.discreteDomainReverse = ((ScaleProviderBuilder)b).myDiscreteDomainReverse;
            MyScaleProvider myScaleProvider3 = this;
            List list3 = ((ScaleProviderBuilder)b).myBreaks;
            if (list3 != null) {
                it = list3;
                myScaleProvider = myScaleProvider3;
                boolean bl = false;
                arrayList2 = new ArrayList(it);
                myScaleProvider3 = myScaleProvider;
            } else {
                arrayList2 = null;
            }
            myScaleProvider3.breaks = arrayList2;
            MyScaleProvider myScaleProvider4 = this;
            List list4 = ((ScaleProviderBuilder)b).myLimits;
            if (list4 != null) {
                it = list4;
                myScaleProvider = myScaleProvider4;
                boolean bl = false;
                arrayList = new ArrayList(it);
                myScaleProvider4 = myScaleProvider;
            } else {
                arrayList = null;
            }
            myScaleProvider4.limits = arrayList;
            this.continuousTransform = ((ScaleProviderBuilder)b).myContinuousTransform;
            MyScaleProvider myScaleProvider5 = this;
            Aes aes = ((ScaleProviderBuilder)b).aes;
            if (Intrinsics.areEqual((Object)aes, (Object)Aes.Companion.getX())) {
                if (!b.getAxisPosition().isHorizontal()) {
                    myScaleProvider = myScaleProvider5;
                    boolean $i$a$-require-ScaleProviderBuilder$MyScaleProvider$axisPosition$32 = false;
                    MyScaleProvider myScaleProvider6 = myScaleProvider;
                    String $i$a$-require-ScaleProviderBuilder$MyScaleProvider$axisPosition$32 = "Illegal X-axis position: " + (Object)((Object)b.getAxisPosition());
                    throw new IllegalArgumentException($i$a$-require-ScaleProviderBuilder$MyScaleProvider$axisPosition$32.toString());
                }
                axisPosition = b.getAxisPosition();
            } else if (Intrinsics.areEqual((Object)aes, (Object)Aes.Companion.getY())) {
                if (!b.getAxisPosition().isVertical()) {
                    myScaleProvider = myScaleProvider5;
                    boolean bl = false;
                    MyScaleProvider myScaleProvider7 = myScaleProvider;
                    String string = "Illegal Y-axis position: " + (Object)((Object)b.getAxisPosition());
                    throw new IllegalArgumentException(string.toString());
                }
                axisPosition = b.getAxisPosition();
            } else {
                axisPosition = b.getAxisPosition();
            }
            myScaleProvider5.axisPosition = axisPosition;
        }

        @Override
        public boolean getDiscreteDomain() {
            return this.discreteDomain;
        }

        @Override
        public boolean getDiscreteDomainReverse() {
            return this.discreteDomainReverse;
        }

        @Override
        @Nullable
        public List<Object> getBreaks() {
            return this.breaks;
        }

        @Override
        @Nullable
        public List<Object> getLimits() {
            return this.limits;
        }

        @Override
        @NotNull
        public ContinuousTransform getContinuousTransform() {
            return this.continuousTransform;
        }

        @Override
        @NotNull
        public AxisPosition getAxisPosition() {
            return this.axisPosition;
        }

        private final String scaleName(DataFrame.Variable variable) {
            String string = this.myName;
            if (string == null) {
                string = variable.getLabel();
            }
            return string;
        }

        @Override
        @NotNull
        public Scale createScale(@NotNull String defaultName, @NotNull DiscreteTransform discreteTransform) {
            Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
            Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
            String string = this.myName;
            if (string == null) {
                string = defaultName;
            }
            Scale scale = Scales.INSTANCE.discreteDomain(string, discreteTransform);
            return this.completeScale(scale);
        }

        @Override
        @NotNull
        public Scale createScale(@NotNull String defaultName, @NotNull ContinuousTransform continuousTransform, boolean continuousRange, @Nullable WithGuideBreaks<Object> guideBreaks) {
            Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
            Intrinsics.checkNotNullParameter((Object)continuousTransform, (String)"continuousTransform");
            String string = this.myName;
            if (string == null) {
                string = defaultName;
            }
            String name = string;
            Scale scale = null;
            scale = Scales.INSTANCE.continuousDomain(name, continuousRange || this.myAes.isNumeric());
            WithGuideBreaks<Object> withGuideBreaks = guideBreaks;
            if (withGuideBreaks != null) {
                WithGuideBreaks<Object> it = withGuideBreaks;
                boolean bl = false;
                scale = scale.with().breaks(it.getBreaks()).labelFormatter(it.getFormatter()).build();
            }
            scale = scale.with().continuousTransform(continuousTransform).build();
            if (this.myBreaksGenerator != null) {
                scale = scale.with().breaksGenerator(this.myBreaksGenerator).build();
            }
            return this.completeScale(scale);
        }

        private final Scale completeScale(Scale scale) {
            Scale.Builder with = scale.with();
            if (this.getBreaks() != null) {
                with.breaks(this.getBreaks());
            }
            if (this.myLabels != null) {
                with.labels(this.myLabels);
            }
            if (this.myLabelFormat != null) {
                with.labelFormatter((Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default((StringFormat.Companion)StringFormat.Companion, (String)this.myLabelFormat, null, null, (int)6, null)){

                    @NotNull
                    public final String invoke(@NotNull Object p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((StringFormat)this.receiver).format(p0);
                    }
                });
            }
            if (this.myMultiplicativeExpand != null) {
                with.multiplicativeExpand(this.myMultiplicativeExpand.doubleValue());
            }
            if (this.myAdditiveExpand != null) {
                with.additiveExpand(this.myAdditiveExpand.doubleValue());
            }
            return with.build();
        }

        private final ScaleMapper<T> absentMapper(DataFrame.Variable var) {
            return new ScaleMapper<T>(var){
                final /* synthetic */ DataFrame.Variable $var;
                {
                    this.$var = $var;
                }

                @Nullable
                public T invoke(@Nullable Double v) {
                    throw new IllegalStateException("Mapper for empty data series '" + this.$var.getName() + "' was invoked with arg " + v);
                }
            };
        }
    }
}

