/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.sampling.method;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.util.SamplingUtil;
import org.jetbrains.letsPlot.core.plot.builder.sampling.PointSampling;
import org.jetbrains.letsPlot.core.plot.builder.sampling.method.SamplingBase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/RandomSampling;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/SamplingBase;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/PointSampling;", "sampleSize", "", "mySeed", "", "(ILjava/lang/Long;)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "Ljava/lang/Long;", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "population", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nRandomSampling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomSampling.kt\norg/jetbrains/letsPlot/core/plot/builder/sampling/method/RandomSampling\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class RandomSampling
extends SamplingBase
implements PointSampling {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Long mySeed;
    @NotNull
    public static final String ALIAS = "random";

    public RandomSampling(int sampleSize, @Nullable Long mySeed) {
        super(sampleSize);
        this.mySeed = mySeed;
    }

    @Override
    @NotNull
    public String getExpressionText() {
        return "sampling_random(n=" + this.getSampleSize() + (this.mySeed != null ? ", seed=" + this.mySeed : "") + ')';
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame population) {
        Long l;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)population, (String)"population");
                if (!this.isApplicable(population)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                l = this.mySeed;
                if (l == null) break block4;
                long it = ((Number)l).longValue();
                boolean bl = false;
                Random random = RandomKt.Random((long)it);
                l = random;
                if (random != null) break block5;
            }
            l = (Random)Random.Default;
        }
        Long rand = l;
        return SamplingUtil.INSTANCE.sampleWithoutReplacement(this.getSampleSize(), (Random)rand, population);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/RandomSampling$Companion;", "", "()V", "ALIAS", "", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

