/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.presentation;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.unsupported.UnsupportedKt;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;
import org.jetbrains.letsPlot.core.plot.builder.presentation.TextWidthEstimator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/presentation/PlotLabelSpec;", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "(Lorg/jetbrains/letsPlot/commons/values/Font;)V", "getFont", "()Lorg/jetbrains/letsPlot/commons/values/Font;", "dimensions", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "labelText", "", "height", "", "monospacedWidth", "labelLength", "", "width", "Companion", "plot-builder"})
public final class PlotLabelSpec
implements LabelSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Font font;
    private static final double FONT_SIZE_TO_GLYPH_WIDTH_RATIO = 0.67;
    private static final double FONT_SIZE_TO_GLYPH_WIDTH_RATIO_MONOSPACED = 0.6;
    private static final double FONT_WEIGHT_BOLD_TO_NORMAL_WIDTH_RATIO = 1.075;
    private static final double LABEL_PADDING = 0.0;
    private static final double FONT_WIDTH_SCALE_FACTOR = 0.85026;
    @NotNull
    private static final LabelSpec DUMMY = new LabelSpec(){

        @NotNull
        public Font getFont() {
            UnsupportedKt.UNSUPPORTED((String)"Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        @NotNull
        public DoubleVector dimensions(@NotNull String labelText) {
            Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
            UnsupportedKt.UNSUPPORTED((String)"Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        public double width(@NotNull String labelText) {
            Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
            UnsupportedKt.UNSUPPORTED((String)"Dummy Label Spec");
            throw new KotlinNothingValueException();
        }

        public double height() {
            UnsupportedKt.UNSUPPORTED((String)"Dummy Label Spec");
            throw new KotlinNothingValueException();
        }
    };

    public PlotLabelSpec(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.font = font;
    }

    @Override
    @NotNull
    public Font getFont() {
        return this.font;
    }

    @Override
    @NotNull
    public DoubleVector dimensions(@NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        return new DoubleVector(this.width(labelText), this.height());
    }

    @Override
    public double width(@NotNull String labelText) {
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        double it = this.getFont().isMonospased() ? this.monospacedWidth(labelText.length()) : 0.85026 * TextWidthEstimator.INSTANCE.textWidth(labelText, this.getFont());
        boolean bl = false;
        return it * this.getFont().getFamily().getWidthFactor();
    }

    private final double monospacedWidth(int labelLength) {
        double ratio = 0.6;
        double width = (double)labelLength * (double)this.getFont().getSize() * ratio + 0.0;
        return this.getFont().isBold() ? width * 1.075 : width;
    }

    @Override
    public double height() {
        return (double)this.getFont().getSize() + 0.0;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/presentation/PlotLabelSpec$Companion;", "", "()V", "DUMMY", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "getDUMMY", "()Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "FONT_SIZE_TO_GLYPH_WIDTH_RATIO", "", "FONT_SIZE_TO_GLYPH_WIDTH_RATIO_MONOSPACED", "FONT_WEIGHT_BOLD_TO_NORMAL_WIDTH_RATIO", "FONT_WIDTH_SCALE_FACTOR", "LABEL_PADDING", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LabelSpec getDUMMY() {
            return DUMMY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

