/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfoQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.TileLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.GeomAreaInsets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/tile/TopDownTileLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;)V", "insideOut", "", "getInsideOut", "()Z", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "preferredSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nTopDownTileLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopDownTileLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/tile/TopDownTileLayout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1549#2:138\n1620#2,3:139\n1789#2,3:142\n*S KotlinDebug\n*F\n+ 1 TopDownTileLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/tile/TopDownTileLayout\n*L\n50#1:138\n50#1:139,3\n54#1:142,3\n*E\n"})
public final class TopDownTileLayout
implements TileLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AxisLayoutQuad axisLayoutQuad;
    @NotNull
    private final DoubleSpan hDomain;
    @NotNull
    private final DoubleSpan vDomain;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    private final boolean insideOut;

    public TopDownTileLayout(@NotNull AxisLayoutQuad axisLayoutQuad, @NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull GeomMarginsLayout marginsLayout) {
        Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        this.axisLayoutQuad = axisLayoutQuad;
        this.hDomain = hDomain;
        this.vDomain = vDomain;
        this.marginsLayout = marginsLayout;
    }

    @Override
    public boolean getInsideOut() {
        return this.insideOut;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TileLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        GeomAreaInsets geomAreaInsets = TopDownTileLayout.Companion.computeAxisInfos(this.axisLayoutQuad, preferredSize, this.hDomain, this.vDomain, this.marginsLayout, coordProvider);
        DoubleRectangle geomBoundsAfterLayout = TileLayoutUtil.INSTANCE.geomOuterBounds(geomAreaInsets, preferredSize, this.hDomain, this.vDomain, this.marginsLayout, coordProvider);
        AxisLayoutInfoQuad axisInfos = geomAreaInsets.getAxisInfoQuad();
        AxisLayoutInfo l = axisInfos.component1();
        AxisLayoutInfo r = axisInfos.component2();
        AxisLayoutInfo t = axisInfos.component3();
        AxisLayoutInfo b = axisInfos.component4();
        Object object = new AxisLayoutInfo[]{l, r, t, b};
        object = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AxisLayoutInfo axisLayoutInfo = (AxisLayoutInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.axisBoundsAbsolute(geomBoundsAfterLayout));
        }
        List axisBounds = (List)destination$iv$iv;
        Iterable $this$fold$iv = axisBounds;
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = geomBoundsAfterLayout;
        for (Object element$iv : $this$fold$iv) {
            void e;
            Object item$iv$iv;
            item$iv$iv = (DoubleRectangle)element$iv;
            DoubleRectangle a = accumulator$iv;
            boolean bl = false;
            accumulator$iv = a.union((DoubleRectangle)e);
        }
        DoubleRectangle geomWithAxisBounds = accumulator$iv;
        DoubleRectangle geomInnerBounds = this.marginsLayout.toInnerBounds(geomBoundsAfterLayout);
        AxisLayoutInfoQuad axisInfosNew = axisInfos.withHAxisLength(geomInnerBounds.getWidth()).withVAxisLength(geomInnerBounds.getHeight());
        return new TileLayoutInfo(DoubleVector.Companion.getZERO(), geomWithAxisBounds, geomBoundsAfterLayout, geomInnerBounds, axisInfosNew, true, true, null, null, 0, 384, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/tile/TopDownTileLayout$Companion;", "", "()V", "computeAxisInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/GeomAreaInsets;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        private final GeomAreaInsets computeAxisInfos(AxisLayoutQuad axisLayoutQuad, DoubleVector plotSize, DoubleSpan hDomain, DoubleSpan vDomain, GeomMarginsLayout marginsLayout, CoordProvider coordProvider) {
            GeomAreaInsets geomAreaInsets;
            DoubleRectangle plottingArea;
            double hAxisLength;
            GeomAreaInsets insetsInitial = GeomAreaInsets.Companion.init(axisLayoutQuad);
            DoubleVector it = TileLayoutUtil.INSTANCE.geomOuterBounds(insetsInitial, plotSize, hDomain, vDomain, marginsLayout, coordProvider).getDimension();
            boolean bl = false;
            double geomHeightEstim = marginsLayout.toInnerSize(it).getY();
            GeomAreaInsets insetsVAxis = insetsInitial.layoutVAxis(vDomain, geomHeightEstim);
            GeomAreaInsets insetsHVAxis = insetsVAxis.layoutHAxis(hDomain, hAxisLength = marginsLayout.toInnerBounds(plottingArea = TileLayoutUtil.INSTANCE.geomOuterBounds(insetsVAxis, plotSize, hDomain, vDomain, marginsLayout, coordProvider)).getWidth());
            if (insetsHVAxis.getTop() + insetsHVAxis.getBottom() > insetsInitial.getTop() + insetsInitial.getBottom()) {
                DoubleVector it2 = TileLayoutUtil.INSTANCE.geomOuterBounds(insetsHVAxis, plotSize, hDomain, vDomain, marginsLayout, coordProvider).getDimension();
                boolean bl2 = false;
                double geomHeight = marginsLayout.toInnerSize(it2).getY();
                geomAreaInsets = insetsHVAxis.layoutVAxis(vDomain, geomHeight);
            } else {
                geomAreaInsets = insetsHVAxis;
            }
            GeomAreaInsets insetsFinal = geomAreaInsets;
            return insetsFinal;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

