/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.tile;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.GeomAreaInsets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/tile/TileLayoutUtil;", "", "()V", "geomOuterBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomInsets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/GeomAreaInsets;", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "liveMapGeomBounds", "plot-builder"})
public final class TileLayoutUtil {
    @NotNull
    public static final TileLayoutUtil INSTANCE = new TileLayoutUtil();

    private TileLayoutUtil() {
    }

    @NotNull
    public final DoubleRectangle liveMapGeomBounds(@NotNull DoubleVector plotSize) {
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        return new DoubleRectangle(DoubleVector.Companion.getZERO(), plotSize);
    }

    @NotNull
    public final DoubleRectangle geomOuterBounds(@NotNull GeomAreaInsets geomInsets, @NotNull DoubleVector plotSize, @NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull GeomMarginsLayout marginsLayout, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)geomInsets, (String)"geomInsets");
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        DoubleRectangle plottingArea = geomInsets.subtractFrom(new DoubleRectangle(DoubleVector.Companion.getZERO(), plotSize));
        DoubleVector geomInnerSize = marginsLayout.toInnerSize(plottingArea.getDimension());
        DoubleVector it = coordProvider.adjustGeomSize(hDomain, vDomain, geomInnerSize);
        boolean bl = false;
        DoubleVector geomOuterSizeAdjusted = marginsLayout.toOuterSize(it);
        return new DoubleRectangle(plottingArea.getOrigin(), geomOuterSizeAdjusted);
    }
}

