/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalTiltedLabelsLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "labelHorizontalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "labelVerticalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "", "axisMapper", "Lkotlin/Function1;", "labelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelNormalSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "Companion", "plot-builder"})
public final class HorizontalTiltedLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Text.HorizontalAnchor labelHorizontalAnchor;
    @NotNull
    private final Text.VerticalAnchor labelVerticalAnchor;
    private static final double MIN_DISTANCE = 5.0;
    private static final double ROTATION_DEGREE = -30.0;
    private static final double SIN = Math.sin(MathKt.toRadians((double)-30.0));
    private static final double COS = Math.cos(MathKt.toRadians((double)-30.0));

    public HorizontalTiltedLabelsLayout(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, axisDomain, breaks, theme);
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported orientation " + (Object)((Object)orientation));
            }
        }
        this.labelHorizontalAnchor = Text.HorizontalAnchor.RIGHT;
        this.labelVerticalAnchor = WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()] == 1 ? Text.VerticalAnchor.BOTTOM : Text.VerticalAnchor.TOP;
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(double axisLength, @NotNull Function1<? super Double, Double> axisMapper) {
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        double height = this.getLabelSpec().height();
        List<Double> ticks = this.mapToAxis$plot_builder(this.getBreaks().getTransformedValues(), axisMapper);
        boolean overlap = false;
        if (this.getBreaks().getSize() >= 2) {
            double minTickDistance = Math.abs((height + 5.0) / SIN);
            double tickDistance = Math.abs(((Number)ticks.get(0)).doubleValue() - ((Number)ticks.get(1)).doubleValue());
            overlap = tickDistance < minTickDistance;
        }
        DoubleRectangle bounds = this.labelsBounds(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        double angle = WhenMappings.$EnumSwitchMapping$0[this.getOrientation().ordinal()] == 1 ? 30.0 : -30.0;
        DoubleRectangle doubleRectangle = bounds;
        Intrinsics.checkNotNull((Object)doubleRectangle);
        return this.createAxisLabelsLayoutInfoBuilder(doubleRectangle, overlap).labelHorizontalAnchor(this.labelHorizontalAnchor).labelVerticalAnchor(this.labelVerticalAnchor).labelRotationAngle(angle).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        double w = Math.abs(labelNormalSize.getX() * COS) + (double)2 * Math.abs(labelNormalSize.getY() * SIN);
        double h = Math.abs(labelNormalSize.getX() * SIN) + Math.abs(labelNormalSize.getY() * COS);
        double x = -(Math.abs(labelNormalSize.getX() * COS) + Math.abs(labelNormalSize.getY() * SIN));
        double y = 0.0;
        return new DoubleRectangle(x, y, w, h);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalTiltedLabelsLayout$Companion;", "", "()V", "COS", "", "MIN_DISTANCE", "ROTATION_DEGREE", "SIN", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

