/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.AxisBreaksProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalFlexBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalRotatedLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalSimpleLabelsLayout;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0012H\u0016J0\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\f2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalFlexBreaksLabelsLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "myBreaksProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProvider;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProvider;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "myRotationAngle", "", "Ljava/lang/Double;", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "axisMapper", "Lkotlin/Function1;", "doLayoutLabels", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "getBreaks", "maxCount", "", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nHorizontalFlexBreaksLabelsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalFlexBreaksLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalFlexBreaksLabelsLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class HorizontalFlexBreaksLabelsLayout
extends AxisLabelsLayout {
    @NotNull
    private final AxisBreaksProvider myBreaksProvider;
    @Nullable
    private final Double myRotationAngle;

    public HorizontalFlexBreaksLabelsLayout(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull AxisBreaksProvider myBreaksProvider, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)myBreaksProvider, (String)"myBreaksProvider");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, axisDomain, theme);
        this.myBreaksProvider = myBreaksProvider;
        this.myRotationAngle = theme.rotateLabels() ? Double.valueOf(theme.labelAngle()) : null;
        if (!orientation.isHorizontal()) {
            boolean $i$a$-require-HorizontalFlexBreaksLabelsLayout$32 = false;
            String $i$a$-require-HorizontalFlexBreaksLabelsLayout$32 = orientation.toString();
            throw new IllegalArgumentException($i$a$-require-HorizontalFlexBreaksLabelsLayout$32.toString());
        }
        if (!(!this.myBreaksProvider.isFixedBreaks())) {
            boolean bl = false;
            String string = "fixed breaks";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(double axisLength, @NotNull Function1<? super Double, Double> axisMapper) {
        int newTargetBreakCount2;
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        int targetBreakCount2 = BreakLabelsLayoutUtil.INSTANCE.estimateBreakCountInitial(axisLength, this.getLabelSpec(), this.myRotationAngle, (Function1<? super DoubleVector, Double>)((Function1)doLayout.targetBreakCount.1.INSTANCE));
        ScaleBreaks breaks = this.getBreaks(targetBreakCount2, axisLength);
        AxisLabelsLayoutInfo labelsInfo = this.doLayoutLabels(breaks, axisLength, axisMapper);
        while (labelsInfo.isOverlap$plot_builder() && (newTargetBreakCount2 = BreakLabelsLayoutUtil.INSTANCE.estimateBreakCount(breaks.getLabels(), axisLength, this.getLabelSpec(), this.myRotationAngle, (Function1<? super DoubleVector, Double>)((Function1)doLayout.newTargetBreakCount.1.INSTANCE))) < targetBreakCount2) {
            targetBreakCount2 = newTargetBreakCount2;
            breaks = this.getBreaks(targetBreakCount2, axisLength);
            labelsInfo = this.doLayoutLabels(breaks, axisLength, axisMapper);
        }
        return labelsInfo;
    }

    private final AxisLabelsLayoutInfo doLayoutLabels(ScaleBreaks breaks, double axisLength, Function1<? super Double, Double> axisMapper) {
        AbstractFixedBreaksLabelsLayout layout = this.myRotationAngle != null ? (AbstractFixedBreaksLabelsLayout)new HorizontalRotatedLabelsLayout(this.getOrientation(), this.getAxisDomain(), breaks, this.getTheme(), this.myRotationAngle) : (AbstractFixedBreaksLabelsLayout)new HorizontalSimpleLabelsLayout(this.getOrientation(), this.getAxisDomain(), breaks, this.getTheme());
        return layout.doLayout(axisLength, axisMapper);
    }

    private final ScaleBreaks getBreaks(int maxCount, double axisLength) {
        return BreakLabelsLayoutUtil.INSTANCE.getFlexBreaks(this.myBreaksProvider, maxCount, axisLength);
    }
}

